/*
 * IBM Watson IoT Platform Organization Information Management REST APIs
 * The Information Management APIs can be used to access device event data as well as  get and update device location and obtain weather information for that location. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html).  version: \"0002\" 
 *
 * OpenAPI spec version: 1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * LECConfig
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:07:14.805+01:00")
public class LECConfig {
  @SerializedName("enabled")
  private Boolean enabled = null;

  @SerializedName("ttlDays")
  private Integer ttlDays = null;

  public LECConfig enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Indicates whether or not the Last Event Cache feature is enabled for your organization
   * @return enabled
  **/
  @ApiModelProperty(example = "true", required = true, value = "Indicates whether or not the Last Event Cache feature is enabled for your organization")
  public Boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public LECConfig ttlDays(Integer ttlDays) {
    this.ttlDays = ttlDays;
    return this;
  }

   /**
   * Indicates the time-to-live (TTL) in days for all cached device events. In other words, the number of days that must pass from the last time a device event was sent until its record will be removed from the Last Event Cache.
   * @return ttlDays
  **/
  @ApiModelProperty(example = "7", value = "Indicates the time-to-live (TTL) in days for all cached device events. In other words, the number of days that must pass from the last time a device event was sent until its record will be removed from the Last Event Cache.")
  public Integer getTtlDays() {
    return ttlDays;
  }

  public void setTtlDays(Integer ttlDays) {
    this.ttlDays = ttlDays;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LECConfig leCConfig = (LECConfig) o;
    return Objects.equals(this.enabled, leCConfig.enabled) &&
        Objects.equals(this.ttlDays, leCConfig.ttlDays);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, ttlDays);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LECConfig {\n");
    
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    ttlDays: ").append(toIndentedString(ttlDays)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

