/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ibm.wiotp.sdk.swagger.model.OrganizationBluemixConfig;
import com.ibm.wiotp.sdk.swagger.model.OrganizationConfig;
import com.ibm.wiotp.sdk.swagger.model.OrganizationIbmMarketplaceConfig;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;

/**
 * Organization
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class Organization {
  @SerializedName("id")
  private String id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("enabled")
  private Boolean enabled = null;

  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    BLUEMIX_FREE("Bluemix Free"),
    
    BLUEMIX_BRONZE("Bluemix Bronze"),
    
    BLUEMIX_SILVER("Bluemix Silver"),
    
    BLUEMIX_GOLD("Bluemix Gold"),
    
    PENDING("Pending"),
    
    TRIAL("Trial"),
    
    BRONZE("Bronze"),
    
    SILVER("Silver"),
    
    GOLD("Gold"),
    
    SUBSCRIPTION("Subscription");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("bluemix")
  private OrganizationBluemixConfig bluemix = null;

  @SerializedName("ibmMarketplace")
  private OrganizationIbmMarketplaceConfig ibmMarketplace = null;

  @SerializedName("config")
  private OrganizationConfig config = null;

  @SerializedName("created")
  private OffsetDateTime created = null;

  @SerializedName("updated")
  private OffsetDateTime updated = null;

  public Organization id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Organization ID
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Organization ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Organization name(String name) {
    this.name = name;
    return this;
  }

   /**
   * User assigned name for the organization
   * @return name
  **/
  @ApiModelProperty(required = true, value = "User assigned name for the organization")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Organization enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether the organization is enabled.  If the organization is disabled all API calls will be rejected and messaging will be disabled across all devices and applications
   * @return enabled
  **/
  @ApiModelProperty(required = true, value = "Whether the organization is enabled.  If the organization is disabled all API calls will be rejected and messaging will be disabled across all devices and applications")
  public Boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public Organization type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Organization bluemix(OrganizationBluemixConfig bluemix) {
    this.bluemix = bluemix;
    return this;
  }

   /**
   * Get bluemix
   * @return bluemix
  **/
  @ApiModelProperty(value = "")
  public OrganizationBluemixConfig getBluemix() {
    return bluemix;
  }

  public void setBluemix(OrganizationBluemixConfig bluemix) {
    this.bluemix = bluemix;
  }

  public Organization ibmMarketplace(OrganizationIbmMarketplaceConfig ibmMarketplace) {
    this.ibmMarketplace = ibmMarketplace;
    return this;
  }

   /**
   * Get ibmMarketplace
   * @return ibmMarketplace
  **/
  @ApiModelProperty(value = "")
  public OrganizationIbmMarketplaceConfig getIbmMarketplace() {
    return ibmMarketplace;
  }

  public void setIbmMarketplace(OrganizationIbmMarketplaceConfig ibmMarketplace) {
    this.ibmMarketplace = ibmMarketplace;
  }

  public Organization config(OrganizationConfig config) {
    this.config = config;
    return this;
  }

   /**
   * Get config
   * @return config
  **/
  @ApiModelProperty(required = true, value = "")
  public OrganizationConfig getConfig() {
    return config;
  }

  public void setConfig(OrganizationConfig config) {
    this.config = config;
  }

  public Organization created(OffsetDateTime created) {
    this.created = created;
    return this;
  }

   /**
   * ISO8601 date-time that the organization was created
   * @return created
  **/
  @ApiModelProperty(required = true, value = "ISO8601 date-time that the organization was created")
  public OffsetDateTime getCreated() {
    return created;
  }

  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }

  public Organization updated(OffsetDateTime updated) {
    this.updated = updated;
    return this;
  }

   /**
   * ISO8601 date-time that the organization was last updated
   * @return updated
  **/
  @ApiModelProperty(required = true, value = "ISO8601 date-time that the organization was last updated")
  public OffsetDateTime getUpdated() {
    return updated;
  }

  public void setUpdated(OffsetDateTime updated) {
    this.updated = updated;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Organization organization = (Organization) o;
    return Objects.equals(this.id, organization.id) &&
        Objects.equals(this.name, organization.name) &&
        Objects.equals(this.enabled, organization.enabled) &&
        Objects.equals(this.type, organization.type) &&
        Objects.equals(this.bluemix, organization.bluemix) &&
        Objects.equals(this.ibmMarketplace, organization.ibmMarketplace) &&
        Objects.equals(this.config, organization.config) &&
        Objects.equals(this.created, organization.created) &&
        Objects.equals(this.updated, organization.updated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, enabled, type, bluemix, ibmMarketplace, config, created, updated);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Organization {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    bluemix: ").append(toIndentedString(bluemix)).append("\n");
    sb.append("    ibmMarketplace: ").append(toIndentedString(ibmMarketplace)).append("\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

