/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.UUID;

/**
 * Only present if the organization was provisioned through Bluemix.
 */
@ApiModel(description = "Only present if the organization was provisioned through Bluemix.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class OrganizationBluemixConfig {
  @SerializedName("region")
  private String region = null;

  @SerializedName("organization")
  private UUID organization = null;

  @SerializedName("space")
  private UUID space = null;

  @SerializedName("serviceInstance")
  private UUID serviceInstance = null;

  @SerializedName("plan")
  private String plan = null;

  public OrganizationBluemixConfig region(String region) {
    this.region = region;
    return this;
  }

   /**
   * The name of the Bluemix region this organization was provisioned in.
   * @return region
  **/
  @ApiModelProperty(required = true, value = "The name of the Bluemix region this organization was provisioned in.")
  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public OrganizationBluemixConfig organization(UUID organization) {
    this.organization = organization;
    return this;
  }

   /**
   * The GUID of the associated organization in Bluemix.
   * @return organization
  **/
  @ApiModelProperty(required = true, value = "The GUID of the associated organization in Bluemix.")
  public UUID getOrganization() {
    return organization;
  }

  public void setOrganization(UUID organization) {
    this.organization = organization;
  }

  public OrganizationBluemixConfig space(UUID space) {
    this.space = space;
    return this;
  }

   /**
   * The GUID of the associated space in Bluemix.
   * @return space
  **/
  @ApiModelProperty(required = true, value = "The GUID of the associated space in Bluemix.")
  public UUID getSpace() {
    return space;
  }

  public void setSpace(UUID space) {
    this.space = space;
  }

  public OrganizationBluemixConfig serviceInstance(UUID serviceInstance) {
    this.serviceInstance = serviceInstance;
    return this;
  }

   /**
   * The GUID of the service instance in Bluemix.
   * @return serviceInstance
  **/
  @ApiModelProperty(required = true, value = "The GUID of the service instance in Bluemix.")
  public UUID getServiceInstance() {
    return serviceInstance;
  }

  public void setServiceInstance(UUID serviceInstance) {
    this.serviceInstance = serviceInstance;
  }

  public OrganizationBluemixConfig plan(String plan) {
    this.plan = plan;
    return this;
  }

   /**
   * The ID of the pricing plan selected for this organization.
   * @return plan
  **/
  @ApiModelProperty(required = true, value = "The ID of the pricing plan selected for this organization.")
  public String getPlan() {
    return plan;
  }

  public void setPlan(String plan) {
    this.plan = plan;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrganizationBluemixConfig organizationBluemixConfig = (OrganizationBluemixConfig) o;
    return Objects.equals(this.region, organizationBluemixConfig.region) &&
        Objects.equals(this.organization, organizationBluemixConfig.organization) &&
        Objects.equals(this.space, organizationBluemixConfig.space) &&
        Objects.equals(this.serviceInstance, organizationBluemixConfig.serviceInstance) &&
        Objects.equals(this.plan, organizationBluemixConfig.plan);
  }

  @Override
  public int hashCode() {
    return Objects.hash(region, organization, space, serviceInstance, plan);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrganizationBluemixConfig {\n");
    
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    organization: ").append(toIndentedString(organization)).append("\n");
    sb.append("    space: ").append(toIndentedString(space)).append("\n");
    sb.append("    serviceInstance: ").append(toIndentedString(serviceInstance)).append("\n");
    sb.append("    plan: ").append(toIndentedString(plan)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

