/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * Only present if the organization was provisioned through IBM Marketplace.
 */
@ApiModel(description = "Only present if the organization was provisioned through IBM Marketplace.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class OrganizationIbmMarketplaceConfig {
  @SerializedName("customerAccountId")
  private BigDecimal customerAccountId = null;

  @SerializedName("masterSubscriptionId")
  private BigDecimal masterSubscriptionId = null;

  public OrganizationIbmMarketplaceConfig customerAccountId(BigDecimal customerAccountId) {
    this.customerAccountId = customerAccountId;
    return this;
  }

   /**
   * The ID of the owning customer account in IBM Marketplace.
   * @return customerAccountId
  **/
  @ApiModelProperty(required = true, value = "The ID of the owning customer account in IBM Marketplace.")
  public BigDecimal getCustomerAccountId() {
    return customerAccountId;
  }

  public void setCustomerAccountId(BigDecimal customerAccountId) {
    this.customerAccountId = customerAccountId;
  }

  public OrganizationIbmMarketplaceConfig masterSubscriptionId(BigDecimal masterSubscriptionId) {
    this.masterSubscriptionId = masterSubscriptionId;
    return this;
  }

   /**
   * The ID of the subscription in IBM Marketplace associated with this organization.
   * @return masterSubscriptionId
  **/
  @ApiModelProperty(required = true, value = "The ID of the subscription in IBM Marketplace associated with this organization.")
  public BigDecimal getMasterSubscriptionId() {
    return masterSubscriptionId;
  }

  public void setMasterSubscriptionId(BigDecimal masterSubscriptionId) {
    this.masterSubscriptionId = masterSubscriptionId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrganizationIbmMarketplaceConfig organizationIbmMarketplaceConfig = (OrganizationIbmMarketplaceConfig) o;
    return Objects.equals(this.customerAccountId, organizationIbmMarketplaceConfig.customerAccountId) &&
        Objects.equals(this.masterSubscriptionId, organizationIbmMarketplaceConfig.masterSubscriptionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerAccountId, masterSubscriptionId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrganizationIbmMarketplaceConfig {\n");
    
    sb.append("    customerAccountId: ").append(toIndentedString(customerAccountId)).append("\n");
    sb.append("    masterSubscriptionId: ").append(toIndentedString(masterSubscriptionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

