/*
 * IBM Watson IoT Platform Organization Information Management REST APIs
 * The Information Management APIs can be used to access device event data as well as  get and update device location and obtain weather information for that location. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html).  version: \"0002\" 
 *
 * OpenAPI spec version: 1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;

/**
 * UpdateableDeviceLocation
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:07:14.805+01:00")
public class UpdateableDeviceLocation {
  @SerializedName("longitude")
  private Double longitude = null;

  @SerializedName("latitude")
  private Double latitude = null;

  @SerializedName("elevation")
  private Double elevation = null;

  @SerializedName("accuracy")
  private Double accuracy = null;

  @SerializedName("measuredDateTime")
  private OffsetDateTime measuredDateTime = null;

  public UpdateableDeviceLocation longitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude in decimal degrees using the WGS84 system
   * @return longitude
  **/
  @ApiModelProperty(required = true, value = "Longitude in decimal degrees using the WGS84 system")
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public UpdateableDeviceLocation latitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude in decimal degrees using the WGS84 system
   * @return latitude
  **/
  @ApiModelProperty(required = true, value = "Latitude in decimal degrees using the WGS84 system")
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public UpdateableDeviceLocation elevation(Double elevation) {
    this.elevation = elevation;
    return this;
  }

   /**
   * Elevation in meters using the WGS84 system
   * @return elevation
  **/
  @ApiModelProperty(value = "Elevation in meters using the WGS84 system")
  public Double getElevation() {
    return elevation;
  }

  public void setElevation(Double elevation) {
    this.elevation = elevation;
  }

  public UpdateableDeviceLocation accuracy(Double accuracy) {
    this.accuracy = accuracy;
    return this;
  }

   /**
   * Accuracy of the position in meters
   * @return accuracy
  **/
  @ApiModelProperty(value = "Accuracy of the position in meters")
  public Double getAccuracy() {
    return accuracy;
  }

  public void setAccuracy(Double accuracy) {
    this.accuracy = accuracy;
  }

  public UpdateableDeviceLocation measuredDateTime(OffsetDateTime measuredDateTime) {
    this.measuredDateTime = measuredDateTime;
    return this;
  }

   /**
   * Date and time of location measurement (ISO8601)
   * @return measuredDateTime
  **/
  @ApiModelProperty(value = "Date and time of location measurement (ISO8601)")
  public OffsetDateTime getMeasuredDateTime() {
    return measuredDateTime;
  }

  public void setMeasuredDateTime(OffsetDateTime measuredDateTime) {
    this.measuredDateTime = measuredDateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateableDeviceLocation updateableDeviceLocation = (UpdateableDeviceLocation) o;
    return Objects.equals(this.longitude, updateableDeviceLocation.longitude) &&
        Objects.equals(this.latitude, updateableDeviceLocation.latitude) &&
        Objects.equals(this.elevation, updateableDeviceLocation.elevation) &&
        Objects.equals(this.accuracy, updateableDeviceLocation.accuracy) &&
        Objects.equals(this.measuredDateTime, updateableDeviceLocation.measuredDateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(longitude, latitude, elevation, accuracy, measuredDateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateableDeviceLocation {\n");
    
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    elevation: ").append(toIndentedString(elevation)).append("\n");
    sb.append("    accuracy: ").append(toIndentedString(accuracy)).append("\n");
    sb.append("    measuredDateTime: ").append(toIndentedString(measuredDateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

