/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.openapi.parser.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException;
import com.ibm.zosconnect.openapi.parser.OperationProcessingException;
import com.ibm.zosconnect.openapi.parser.TracingAspect;
import com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl;
import com.ibm.zosconnect.openapi.parser.internal.ParameterType;
import com.ibm.zosconnect.openapi.parser.internal.util.Message;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class JsonSchemaWrapper {
    static final String copyright_notice = "\nIBM Confidential. PID 5655-CE5. Copyright IBM Corp. 2021\n";
    private Map<String, Object> jsonSchema;
    private Map<String, Object> properties;
    private List<String> required;
    private ObjectType pathParameters;
    private ObjectType queryParameters;
    private ObjectType headers;
    private ObjectType cookies;
    private Schema requestBody;
    private Map<String, Schema> responseBodies;
    private Message message;
    private OpenApiParserImpl.OASVersion oasVersion;
    private static final String type = "object";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COMMA = ",";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    public JsonSchemaWrapper(OpenApiParserImpl.OASVersion oasVersion, Message message) {
        OpenApiParserImpl.OASVersion oASVersion = oasVersion;
        Message message2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)oASVersion), (Object)message2);
        TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
        this.jsonSchema = new LinkedHashMap<String, Object>();
        this.properties = new LinkedHashMap<String, Object>();
        this.required = new LinkedList<String>();
        this.pathParameters = new ObjectType();
        this.queryParameters = new ObjectType();
        this.headers = new ObjectType();
        this.cookies = new ObjectType();
        this.requestBody = null;
        this.responseBodies = new TreeMap<String, Schema>();
        this.oasVersion = oasVersion;
        if (oasVersion == OpenApiParserImpl.OASVersion.THREEZERO) {
            this.jsonSchema.put("$schema", "http://json-schema.org/draft-04/schema#");
        } else {
            this.jsonSchema.put("$schema", "https://json-schema.org/draft/2020-12/schema#");
        }
        this.jsonSchema.put("description", "json-schema");
        this.message = message;
    }

    public void addParameters(PrintStream logPrintStream, String name, String in, boolean required, Map<String, Object> value) throws OperationProcessingException {
        PrintStream printStream = logPrintStream;
        String string = name;
        String string2 = in;
        boolean bl = required;
        Map<String, Object> map = value;
        Object[] objectArray = new Object[]{printStream, string, string2, Conversions.booleanObject((boolean)bl), map};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
            if (ParameterType.PathParameters.getType().equals(in)) {
                this.pathParameters.getProperties().put(name, value);
                this.pathParameters.getRequired().add(name);
                if (!required) {
                    this.message.printMessage(logPrintStream, "PARSER_PARAM_IN_PATH_REQUIRED", name);
                }
            } else if (ParameterType.QueryParameters.getType().equals(in)) {
                this.queryParameters.getProperties().put(name, value);
                if (required) {
                    this.queryParameters.getRequired().add(name);
                }
            } else if (ParameterType.Headers.getType().equals(in)) {
                this.headers.getProperties().put(name, value);
                if (required) {
                    this.headers.getRequired().add(name);
                }
            } else if (ParameterType.Cookies.getType().equals(in)) {
                this.cookies.getProperties().put(name, value);
                if (required) {
                    this.cookies.getRequired().add(name);
                }
            }
            Object var13_13 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var13_13, ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public void addParameters(PrintStream logPrintStream, String name, String in, boolean required, Schema schema) throws OperationProcessingException {
        PrintStream printStream = logPrintStream;
        String string = name;
        String string2 = in;
        boolean bl = required;
        Schema schema2 = schema;
        Object[] objectArray = new Object[]{printStream, string, string2, Conversions.booleanObject((boolean)bl), schema2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
            if (ParameterType.PathParameters.getType().equals(in)) {
                this.pathParameters.getProperties().put(name, schema);
                this.pathParameters.getRequired().add(name);
                if (!required) {
                    this.message.printMessage(logPrintStream, "PARSER_PARAM_IN_PATH_REQUIRED", name);
                }
            } else if (ParameterType.QueryParameters.getType().equals(in)) {
                this.queryParameters.getProperties().put(name, schema);
                if (required) {
                    this.queryParameters.getRequired().add(name);
                }
            } else if (ParameterType.Headers.getType().equals(in)) {
                this.headers.getProperties().put(name, schema);
                if (required) {
                    this.headers.getRequired().add(name);
                }
            } else if (ParameterType.Cookies.getType().equals(in)) {
                this.cookies.getProperties().put(name, schema);
                if (required) {
                    this.cookies.getRequired().add(name);
                }
            }
            Object var13_13 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var13_13, ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public void addQuerys(Map values, String name, boolean required) {
        Map map = values;
        String string = name;
        boolean bl = required;
        Object[] objectArray = new Object[]{map, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_3, joinPoint);
            this.queryParameters.getProperties().putAll(values);
            if (required) {
                this.queryParameters.getRequired().add(name);
            }
            Object var9_9 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var9_9, ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public void addHeaders(Map values, String name, boolean required) {
        Map map = values;
        String string = name;
        boolean bl = required;
        Object[] objectArray = new Object[]{map, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_4, joinPoint);
            this.headers.getProperties().putAll(values);
            if (required) {
                this.headers.getRequired().add(name);
            }
            Object var9_9 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var9_9, ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public void addHeaders(Map values) {
        Map map = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)map);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_5, joinPoint);
            this.headers.getProperties().putAll(values);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    public void addCookies(Map values, String name, boolean required) {
        Map map = values;
        String string = name;
        boolean bl = required;
        Object[] objectArray = new Object[]{map, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_6, joinPoint);
            this.cookies.getProperties().putAll(values);
            if (required) {
                this.cookies.getRequired().add(name);
            }
            Object var9_9 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var9_9, ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    public void addCookies(Map values) {
        Map map = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)map);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_7, joinPoint);
            this.cookies.getProperties().putAll(values);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    public void setRequestBody(Schema schema) {
        Schema schema2 = schema;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)schema2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_8, joinPoint);
            this.requestBody = schema;
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    public Schema getRequestBody() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            Schema schema;
            Schema schema2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_9, joinPoint);
            Schema schema3 = schema2 = (schema = this.requestBody);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(schema2, ajc$tjp_9);
            return schema;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    public void setResponseBody(String responseCode, Schema schema) {
        String string = responseCode;
        Schema schema2 = schema;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)schema2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_10, joinPoint);
            if (responseCode.equalsIgnoreCase("default")) {
                responseCode = "Def";
            }
            this.responseBodies.put("responseCode" + responseCode, schema);
            Object var6_6 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var6_6, ajc$tjp_10);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    public Map<String, Schema> getResponseBodies() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            Map<String, Schema> map;
            Map<String, Schema> map2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_11, joinPoint);
            Map<String, Schema> map3 = map2 = (map = this.responseBodies);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(map2, ajc$tjp_11);
            return map;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    public List<String> getRequired() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            List<String> list;
            List<String> list2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_12, joinPoint);
            List<String> list3 = list2 = (list = this.required);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(list2, ajc$tjp_12);
            return list;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    public String toJson(PrintStream logPrintStream, boolean isRequest) throws IOException, InvalidOpenApiDocumentException, OperationProcessingException {
        PrintStream printStream = logPrintStream;
        boolean bl = isRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)printStream, (Object)Conversions.booleanObject((boolean)bl));
        try {
            String string;
            String string2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_13, joinPoint);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            String jsonString = null;
            this.jsonSchema.put("type", type);
            this.jsonSchema.put("properties", this.properties);
            String dsPath = ParameterType.PathParameters.getNameInJson(isRequest);
            String dsQuery = ParameterType.QueryParameters.getNameInJson(isRequest);
            String dsHeader = ParameterType.Headers.getNameInJson(isRequest);
            String dsCookie = ParameterType.Cookies.getNameInJson(isRequest);
            if (this.pathParameters.getProperties().size() != 0) {
                this.properties.put(dsPath, this.pathParameters);
                this.required.add(dsPath);
            }
            if (this.queryParameters.getProperties().size() != 0) {
                this.properties.put(dsQuery, this.queryParameters);
                this.required.add(dsQuery);
            }
            if (this.headers.getProperties().size() != 0) {
                this.properties.put(dsHeader, this.headers);
                this.required.add(dsHeader);
            }
            if (this.cookies.getProperties().size() != 0) {
                this.properties.put(dsCookie, this.cookies);
                this.required.add(dsCookie);
            }
            if (isRequest) {
                if (this.requestBody != null) {
                    this.properties.put("requestBody", this.requestBody);
                    this.required.add("requestBody");
                }
            } else {
                for (Map.Entry<String, Schema> entry : this.responseBodies.entrySet()) {
                    if (entry.getValue() == null) continue;
                    this.properties.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.required.size() != 0) {
                this.jsonSchema.put("required", this.required);
            }
            jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.jsonSchema);
            if (!isRequest) {
                Map map = (Map)mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){
                    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                    {
                        JsonSchemaWrapper jsonSchemaWrapper = JsonSchemaWrapper.this;
                        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)jsonSchemaWrapper);
                        TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
                    }

                    static {
                        1.ajc$preClinit();
                    }

                    private static /* synthetic */ void ajc$preClinit() {
                        Factory factory = new Factory("JsonSchemaWrapper.java", 1.class);
                        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("0", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$1", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "this$0", ""), 247);
                    }
                });
                this.traverseJSONSchema(logPrintStream, map);
                jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
            }
            jsonString = this.removeUnwantedArtifacts(isRequest, jsonString);
            if (this.oasVersion == OpenApiParserImpl.OASVersion.THREEZERO) {
                jsonString = this.normaliseExclusiveMaxMinNullable(jsonString);
            }
            String string3 = string2 = (string = jsonString);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_13);
            return string;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    public boolean isJSONSchemaRequired(boolean isRequest) {
        boolean bl = isRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        try {
            boolean bl2;
            boolean bl3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_14, joinPoint);
            boolean bl4 = bl3 = isRequest ? (bl2 = this.requestBody != null || this.headers.getProperties().size() != 0 || this.cookies.getProperties().size() != 0 || this.queryParameters.getProperties().size() != 0 || this.pathParameters.getProperties().size() != 0) : (bl2 = this.responseBodies.size() != 0 || this.headers.getProperties().size() != 0);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(Conversions.booleanObject((boolean)bl3), ajc$tjp_14);
            return bl2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_14);
            throw throwable;
        }
    }

    private String normaliseExclusiveMaxMinNullable(String jsonString) {
        String string = jsonString;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            String line;
            int i;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_15, joinPoint);
            StringBuffer returnString = new StringBuffer();
            int typeLocation = 0;
            String[] jsonLines = jsonString.split(System.getProperty("line.separator"));
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(jsonLines));
            for (i = 0; i < lines.size(); ++i) {
                line = lines.get(i);
                if (line.contains("\"type\"")) {
                    typeLocation = i;
                }
                if (line.contains("\"nullable\"") && line.contains("true")) {
                    lines.set(typeLocation, this.mangleTypeToAddNull(lines.get(typeLocation)));
                    String removedLine = lines.remove(i--);
                    if (!removedLine.endsWith(COMMA)) {
                        lines.set(i, lines.get(i).substring(0, lines.get(i).lastIndexOf(COMMA)));
                    }
                }
                if (line.contains("\"exclusiveMaximum\"")) {
                    this.mangleObjectProperties(lines, i, line, "maximum");
                }
                if (!line.contains("\"exclusiveMinimum\"")) continue;
                this.mangleObjectProperties(lines, i, line, "minimum");
            }
            for (i = 0; i < lines.size(); ++i) {
                line = lines.get(i);
                returnString.append(line);
                returnString.append(System.lineSeparator());
            }
            String string4 = string3 = (string2 = returnString.toString());
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_15);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_15);
            throw throwable;
        }
    }

    private String mangleTypeToAddNull(String type) {
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_16, joinPoint);
            StringBuffer arrayType = new StringBuffer(type);
            int quotes = 0;
            boolean fixed = false;
            for (int i = 0; i < type.length(); ++i) {
                if (arrayType.charAt(i) == '\"') {
                    ++quotes;
                }
                if (quotes == 3 && !fixed) {
                    arrayType.insert(i++, '[');
                    fixed = true;
                }
                if (quotes != 4) continue;
                arrayType.insert(++i, ", \"null\"]");
                break;
            }
            String string4 = string3 = (string2 = arrayType.toString());
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_16);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_16);
            throw throwable;
        }
    }

    private void mangleObjectProperties(ArrayList<String> lines, int i, String line, String type) {
        ArrayList<String> arrayList = lines;
        int n = i;
        String string = line;
        String string2 = type;
        Object[] objectArray = new Object[]{arrayList, Conversions.intObject((int)n), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_17, joinPoint);
            int start = 0;
            int stop = 0;
            if (line.contains("false")) {
                lines.remove(i);
            } else if (line.contains("true")) {
                String object;
                int j;
                for (j = i - 1; j > 0; --j) {
                    object = lines.get(j);
                    if (object.indexOf(123) <= -1) continue;
                    start = j + 1;
                    break;
                }
                for (j = i + 1; j < lines.size(); ++j) {
                    object = lines.get(j);
                    if (object.indexOf(125) <= -1) continue;
                    stop = j - 1;
                    break;
                }
                int remove = 0;
                for (int j2 = start; j2 < stop; ++j2) {
                    String objectLine = lines.get(j2);
                    if (!objectLine.contains(DOUBLE_QUOTE + type + DOUBLE_QUOTE)) continue;
                    remove = j2;
                    String value = objectLine.substring(objectLine.indexOf(58) + 1).trim();
                    if (value.charAt(value.length() - 1) == ',') {
                        value = value.substring(0, value.length() - 1);
                    }
                    lines.set(i, line.replaceFirst("true", value));
                    break;
                }
                if (remove > 0) {
                    lines.remove(remove);
                }
            }
            Object var17_18 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var17_18, ajc$tjp_17);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_17);
            throw throwable;
        }
    }

    private String removeUnwantedArtifacts(boolean isRequest, String jsonString) {
        boolean bl = isRequest;
        String string = jsonString;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl), (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_18, joinPoint);
            StringBuffer returnString = new StringBuffer();
            String[] jsonLines = jsonString.split(System.getProperty("line.separator"));
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(jsonLines));
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.indexOf("\"exampleSetFlag\"") > -1) {
                    if (lines.get(i + 1).trim().startsWith(DOUBLE_QUOTE)) continue;
                    returnString.deleteCharAt(returnString.lastIndexOf(COMMA));
                    continue;
                }
                returnString.append(line);
                returnString.append(System.lineSeparator());
            }
            String string4 = string3 = (string2 = returnString.toString());
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_18);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_18);
            throw throwable;
        }
    }

    private void traverseJSONSchema(PrintStream logPrintStream, Map<String, Object> map) throws OperationProcessingException {
        PrintStream printStream = logPrintStream;
        Map<String, Object> map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)printStream, map2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_19, joinPoint);
            try {
                String type = (String)map.get("type");
                Object property = map.get("properties");
                if (property == null) {
                    if (type != null && type.equalsIgnoreCase(type)) {
                        map.put("additionalProperties", true);
                    }
                } else {
                    Map properties = (Map)property;
                    for (Map.Entry entry : properties.entrySet()) {
                        this.traverseJSONSchema(logPrintStream, (Map)entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                this.message.printMessage(logPrintStream, "PARSER_UNEXPECTED_ERROR", e.getMessage());
                throw new OperationProcessingException(this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage()), e);
            }
            Object var11_12 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var11_12, ajc$tjp_19);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_19);
            throw throwable;
        }
    }

    static {
        JsonSchemaWrapper.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JsonSchemaWrapper.java", JsonSchemaWrapper.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion:com.ibm.zosconnect.openapi.parser.internal.util.Message", "oasVersion:message", ""), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addParameters", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.io.PrintStream:java.lang.String:java.lang.String:boolean:java.util.Map", "logPrintStream:name:in:required:value", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 76);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setResponseBody", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.lang.String:io.swagger.v3.oas.models.media.Schema", "responseCode:schema", "", "void"), 174);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResponseBodies", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "", "", "", "java.util.Map"), 182);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequired", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "", "", "", "java.util.List"), 186);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toJson", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.io.PrintStream:boolean", "logPrintStream:isRequest", "java.io.IOException:com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException:com.ibm.zosconnect.openapi.parser.OperationProcessingException", "java.lang.String"), 193);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isJSONSchemaRequired", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "boolean", "isRequest", "", "boolean"), 268);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normaliseExclusiveMaxMinNullable", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.lang.String", "jsonString", "", "java.lang.String"), 305);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mangleTypeToAddNull", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.lang.String", "type", "", "java.lang.String"), 353);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mangleObjectProperties", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.ArrayList:int:java.lang.String:java.lang.String", "lines:i:line:type", "", "void"), 389);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeUnwantedArtifacts", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "boolean:java.lang.String", "isRequest:jsonString", "", "java.lang.String"), 444);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "traverseJSONSchema", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.io.PrintStream:java.util.Map", "logPrintStream:map", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 499);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addParameters", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.io.PrintStream:java.lang.String:java.lang.String:boolean:io.swagger.v3.oas.models.media.Schema", "logPrintStream:name:in:required:schema", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addQuerys", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.Map:java.lang.String:boolean", "values:name:required", "", "void"), 130);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHeaders", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.Map:java.lang.String:boolean", "values:name:required", "", "void"), 138);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHeaders", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.Map", "values", "", "void"), 146);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookies", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.Map:java.lang.String:boolean", "values:name:required", "", "void"), 151);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCookies", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "java.util.Map", "values", "", "void"), 159);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequestBody", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "io.swagger.v3.oas.models.media.Schema", "schema", "", "void"), 164);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestBody", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper", "", "", "", "io.swagger.v3.oas.models.media.Schema"), 169);
    }

    public static class ObjectType {
        private String type;
        private List<String> required;
        private Map<String, Object> properties;
        private Map<String, Schema> schemas;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

        public ObjectType() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
            this.type = JsonSchemaWrapper.type;
            this.required = new ArrayList<String>();
            this.properties = new LinkedHashMap<String, Object>();
            this.schemas = new LinkedHashMap<String, Schema>();
        }

        public String getType() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            try {
                String string;
                String string2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
                String string3 = string2 = (string = this.type);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_1);
                return string;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        public void setType(String type) {
            String string = type;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
                this.type = type;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        public List<String> getRequired() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            try {
                List<String> list;
                List<String> list2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_3, joinPoint);
                List<String> list3 = list2 = (list = this.required);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(list2, ajc$tjp_3);
                return list;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_3);
                throw throwable;
            }
        }

        public void setRequired(List<String> required) {
            List<String> list = required;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_4, joinPoint);
                this.required = required;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_4);
                throw throwable;
            }
        }

        public Map<String, Object> getProperties() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
            try {
                Map<String, Object> map;
                Map<String, Object> map2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_5, joinPoint);
                Map<String, Object> map3 = map2 = (map = this.properties);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(map2, ajc$tjp_5);
                return map;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_5);
                throw throwable;
            }
        }

        public void setProperties(Map<String, Object> properties) {
            Map<String, Object> map = properties;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, map);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_6, joinPoint);
                this.properties = properties;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_6);
                throw throwable;
            }
        }

        public Map<String, Schema> getSchemas() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
            try {
                Map<String, Schema> map;
                Map<String, Schema> map2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_7, joinPoint);
                Map<String, Schema> map3 = map2 = (map = this.schemas);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(map2, ajc$tjp_7);
                return map;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_7);
                throw throwable;
            }
        }

        public void setSchemas(Map<String, Schema> schemas) {
            Map<String, Schema> map = schemas;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, map);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_8, joinPoint);
                this.schemas = schemas;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_8);
                throw throwable;
            }
        }

        static {
            ObjectType.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("JsonSchemaWrapper.java", ObjectType.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "", "", ""), 523);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "", "", "", "java.lang.String"), 530);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setType", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "java.lang.String", "type", "", "void"), 534);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequired", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "", "", "", "java.util.List"), 538);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequired", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "java.util.List", "required", "", "void"), 542);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProperties", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "", "", "", "java.util.Map"), 546);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProperties", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "java.util.Map", "properties", "", "void"), 550);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemas", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "", "", "", "java.util.Map"), 555);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSchemas", "com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper$ObjectType", "java.util.Map", "schemas", "", "void"), 560);
        }
    }
}

