/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.openapi.parser.internal;

import com.ibm.cics.gen.api.IAssistantResponse;
import com.ibm.zosconnect.openapi.parser.DuplicateParseAttemptException;
import com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException;
import com.ibm.zosconnect.openapi.parser.InvalidPropertyException;
import com.ibm.zosconnect.openapi.parser.OpenApiParser;
import com.ibm.zosconnect.openapi.parser.OperationProcessingException;
import com.ibm.zosconnect.openapi.parser.ParseResult;
import com.ibm.zosconnect.openapi.parser.ParseStatus;
import com.ibm.zosconnect.openapi.parser.ParsedOperation;
import com.ibm.zosconnect.openapi.parser.TracingAspect;
import com.ibm.zosconnect.openapi.parser.internal.ArtifactType;
import com.ibm.zosconnect.openapi.parser.internal.CicsAssistantException;
import com.ibm.zosconnect.openapi.parser.internal.JsonSchemaWrapper;
import com.ibm.zosconnect.openapi.parser.internal.ParameterType;
import com.ibm.zosconnect.openapi.parser.internal.ParseResultImpl;
import com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl;
import com.ibm.zosconnect.openapi.parser.internal.ParserJS2LSProperty;
import com.ibm.zosconnect.openapi.parser.internal.ParserProperty;
import com.ibm.zosconnect.openapi.parser.internal.template.CobolTemplate;
import com.ibm.zosconnect.openapi.parser.internal.template.PLITemplate;
import com.ibm.zosconnect.openapi.parser.internal.template.TemplateVarEnum;
import com.ibm.zosconnect.openapi.parser.internal.util.JS2LSUtil;
import com.ibm.zosconnect.openapi.parser.internal.util.Message;
import com.ibm.zosconnect.openapi.parser.internal.util.NameUtil;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiParserImpl
implements OpenApiParser {
    static final String copyright_notice = "\nIBM Confidential. PID 5655-CE5. Copyright IBM Corp. 2021\n";
    private static final String OPEN_API_PARSER_BUNDLE = "com.ibm.zosconnect.openapi.parser.resources.OpenApiParser";
    private static Logger logger;
    private boolean parsed;
    private final Map<ParserProperty, String> localAttributes;
    private Map<ParserJS2LSProperty, String> js2lsAttributes;
    private ParseResultImpl parseResult;
    private Map<String, SecurityScheme> apiKeyDefinitionFromProperties;
    private String apiName;
    private OpenAPI openAPI;
    private Info info;
    private io.swagger.v3.oas.models.Paths paths;
    private Components components;
    private File logFile;
    private PrintStream logPrintStream;
    private String requestJsonSchema;
    private String responseJsonSchema;
    private StringBuffer requestMapping;
    private StringBuffer responseMapping;
    private Map<String, StringBuffer> responseMappingXXX;
    private static Pattern quotes;
    private static Pattern backslash;
    private Path temporaryStore;
    private int operationSeq;
    private Message message;
    private String[] requiredOperations;
    private Map<String, String> operationMediaType;
    private String apiKeyNameProperty;
    private static Set<String> SUPPORTED_ARGS;
    private static Set<String> NOT_NULL_ARGS;
    private static Set<String> SUPPORTED_LANG;
    private static Set<String> IGNORED_HEADERS;
    private static Set<String> SUPPORTED_SIMPLE_TYPES;
    private static List<String> HTTP_SUPPORTED_METHODS;
    private static Set<String> specialChars;
    private static Set<String> pathSpecialChars;
    private static final int apiKeyMaxLengthMinValue = 1;
    private static final int apiKeyMaxLengthMaxValue = Short.MAX_VALUE;
    private static final int defaultCharacterMaxLengthMinValue = 1;
    private static final int defaultCharacterMaxLengthMaxValue = Short.MAX_VALUE;
    private static final int defaultCharacterMaxLengthMaxLongValue = 0xFFFFFE;
    private static final int defaultFractionDigitsMinValue = 0;
    private static final int defaultFractionDigitsMaxValue = 17;
    private static final int defaultFractionDigitsMaxValueWide = 30;
    private static final int SIZE_OF_PDS_MEMBER_PREFIX = 3;
    private static final String YES = "YES";
    private static final String SERVICES = "services";
    private static final String WSBINDS = "ws-binds";
    private static final String JS2LS = "js2ls";
    private static final String SUPPORTED_OPENAPI_VERSIONS = "3.0.x";
    private static final String HTTP_STATUS_CODE_DEFAULT = "default";
    private static final int API_NAME_MAX_LENGTH = 240;
    static final int JVM_ARRAY_OVERHEAD = 256;
    static final int ARRAY_MAX_ITEMS_THRESHOLD = 0x7FFFFEFF;
    private static final HashMap<String, String> cicsErrorMessageConversions;
    private static final String invalidJSONschemaErrorCode = "DFHPI9693E";
    private static final String cicsContainersProhibitedErrorCode = "DFHPI9730E";
    private static final String levelBeyondLimitationErrorCode = "DFHPI9739E";
    private static final String recursiveJSONPointer = "DFHPI9740E";
    private static final String noEnumConstantFound = "No enum constant com.ibm.cics.wsdl.ws2ls.js2ls.JsonType.T";
    private OASVersion oasVersion;
    private ExecutionMode executionMode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;

    public OpenApiParserImpl() throws OperationProcessingException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
        this.parsed = false;
        this.localAttributes = new HashMap<ParserProperty, String>();
        this.js2lsAttributes = new HashMap<ParserJS2LSProperty, String>();
        this.apiKeyDefinitionFromProperties = new HashMap<String, SecurityScheme>();
        this.responseMappingXXX = new HashMap<String, StringBuffer>();
        this.operationSeq = 0;
        this.message = new Message(Locale.getDefault(), OPEN_API_PARSER_BUNDLE);
        this.requiredOperations = null;
        this.operationMediaType = new HashMap<String, String>();
        this.apiKeyNameProperty = "";
        this.oasVersion = OASVersion.THREEZERO;
        this.executionMode = ExecutionMode.REQUESTER;
        try {
            this.setupParser();
        }
        catch (IOException ex) {
            String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", ex.getMessage());
            throw new OperationProcessingException(reason, ex);
        }
    }

    @Override
    public void setProperties(Map<String, String> properties) throws InvalidPropertyException {
        Map<String, String> map = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, map);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
            this.js2lsAttributes = new HashMap<ParserJS2LSProperty, String>();
            HashSet<String> allArgs = new HashSet<String>();
            Set<Map.Entry<String, String>> propEntrySet = properties.entrySet();
            for (Map.Entry<String, String> param : propEntrySet) {
                if (SUPPORTED_ARGS.contains(param.getKey())) {
                    if (ParserProperty.names().contains(param.getKey())) {
                        if (((String)param.getKey()).equals(ParserProperty.requestMediaType.toString())) {
                            this.checkRequestMediaType(ParserProperty.requestMediaType.toString(), (String)param.getValue());
                        }
                        if (((String)param.getKey()).equals(ParserProperty.responseMediaType.toString())) {
                            this.checkRequestMediaType(ParserProperty.responseMediaType.toString(), (String)param.getValue());
                        }
                        this.localAttributes.put(ParserProperty.valueOf((String)param.getKey()), (String)param.getValue());
                    } else {
                        String string = ParserJS2LSProperty.valueOf((String)param.getKey()).js2lsName();
                        String value = (String)param.getValue();
                        if (string.equals("LANG") && ((String)param.getValue()).equals("PLI")) {
                            value = "PLI-ENTERPRISE";
                        }
                        this.js2lsAttributes.put(ParserJS2LSProperty.valueOf((String)param.getKey()), value);
                    }
                    allArgs.add((String)param.getKey());
                    continue;
                }
                throw new InvalidPropertyException(this.message.getMessage("PARSER_INVALID_PROPERTY", param.getKey()));
            }
            HashSet<String> missedArgs = new HashSet<String>();
            for (String string : NOT_NULL_ARGS) {
                if (allArgs.contains(string)) continue;
                missedArgs.add(string);
            }
            if (missedArgs.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String s : missedArgs) {
                    sb.append(s).append(",");
                }
                String string = sb.substring(0, sb.length() - 1);
                throw new InvalidPropertyException(this.message.getMessage("PARSER_INVALID_PROPERTY", string));
            }
            this.validateProperties();
            Object var10_14 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var10_14, ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Override
    public void setLanguage(String language) throws InvalidPropertyException {
        String string = language;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
            language = language.toUpperCase();
            if (language.equals("PLI")) {
                language = "PLI-ENTERPRISE";
            }
            this.js2lsAttributes.put(ParserJS2LSProperty.language, language);
            this.checkLanguage();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Override
    public void setUserLocale(String language, String country) {
        String string = language;
        String string2 = country;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_3, joinPoint);
            this.message = new Message(new Locale(language, country), OPEN_API_PARSER_BUNDLE);
            String locale = language;
            if (country != null && !country.equals("")) {
                locale = locale + "_" + country;
            }
            this.js2lsAttributes.put(ParserJS2LSProperty.languageCountry, locale);
            Object var7_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var7_7, ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Override
    public void setRuntimeCodePage(String codepage) throws InvalidPropertyException {
        String string = codepage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_4, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.runtimeCodePage, codepage);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Override
    public void setRequesterPrefix(String prefix) throws InvalidPropertyException {
        String string = prefix;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_5, joinPoint);
            this.localAttributes.put(ParserProperty.requesterPrefix, prefix);
            this.checkPdsMemberName(this.getArgValue(ParserProperty.requesterPrefix));
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    @Override
    public void setProviderPrefix(String prefix) throws InvalidPropertyException {
        String string = prefix;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_6, joinPoint);
            this.localAttributes.put(ParserProperty.providerPrefix, prefix);
            this.checkPdsMemberName(this.getArgValue(ParserProperty.providerPrefix));
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    @Override
    public void setCharacterMultiplier(String multiplier) throws InvalidPropertyException {
        String string = multiplier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_7, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.characterMultiplier, multiplier);
            this.checkMultiplier();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    @Override
    public void setCharacterWhiteSpace(String handlingType) throws InvalidPropertyException {
        String string = handlingType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_8, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.characterWhiteSpace, handlingType);
            this.checkCharacterWhitespace();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    @Override
    public void setCharacterVarying(String varyingType) throws InvalidPropertyException {
        String string = varyingType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_9, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.characterVarying, varyingType);
            this.checkCharacterVarying();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    @Override
    public void setCharacterVaryingLimit(String varyingLimit) throws InvalidPropertyException {
        String string = varyingLimit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_10, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.characterVaryingLimit, varyingLimit);
            this.checkCharacterVaryingLimit();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_10);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    @Override
    public void setDataTruncation(String truncationType) throws InvalidPropertyException {
        String string = truncationType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_11, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.dataTruncation, truncationType);
            this.checkDataTruncation();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_11);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    @Override
    public void setDateTimeFormat(String dateTimeFormat) throws InvalidPropertyException {
        String string = dateTimeFormat;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_12, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.dateTimeFormat, dateTimeFormat);
            this.checkDateTimeFormat();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_12);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    @Override
    public void setDefaultCharacterMaxLength(String maxLength) throws InvalidPropertyException {
        String string = maxLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_13, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.defaultCharacterMaxLength, maxLength);
            this.checkDefaultCharacterMaxLength();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_13);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    @Override
    public void setDefaultFractionDigits(String maxLength) throws InvalidPropertyException {
        String string = maxLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_14, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.defaultFractionDigits, maxLength);
            this.checkDefaultFractionDigits();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_14);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_14);
            throw throwable;
        }
    }

    @Override
    public void setNameTruncation(String truncationType) throws InvalidPropertyException {
        String string = truncationType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_15, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.nameTruncation, truncationType);
            this.checkNameTruncation();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_15);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_15);
            throw throwable;
        }
    }

    @Override
    public void setGeneratedCodePage(String codepage) throws InvalidPropertyException {
        String string = codepage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_16, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.generatedCodePage, codepage);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_16);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_16);
            throw throwable;
        }
    }

    @Override
    public void setWideComp3(String wideComp3) throws InvalidPropertyException {
        String string = wideComp3;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_17, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.wideComp3, wideComp3);
            this.checkWideComp3();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_17);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_17);
            throw throwable;
        }
    }

    @Override
    public void setInlineMaxOccursLimit(String arrayMaxItems) throws InvalidPropertyException {
        String string = arrayMaxItems;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_18, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.inlineMaxOccursLimit, arrayMaxItems);
            this.checkInlineMaxOccursLimit();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_18);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_18);
            throw throwable;
        }
    }

    @Override
    public void setAdditionalPropertiesSize(String additionalPropertiesSize) throws InvalidPropertyException {
        String string = additionalPropertiesSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_19, joinPoint);
            this.js2lsAttributes.put(ParserJS2LSProperty.additionalPropertiesSize, additionalPropertiesSize);
            this.checkAdditionalPropertiesSize();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_19);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_19);
            throw throwable;
        }
    }

    @Override
    public void setApiKeyParmNameInHeader(String apiKeyParmNameInHeader) throws InvalidPropertyException {
        String string = apiKeyParmNameInHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_20, joinPoint);
            this.localAttributes.put(ParserProperty.apiKeyParmNameInHeader, apiKeyParmNameInHeader);
            this.getApiKeySchemeFromProperties();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_20);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_20);
            throw throwable;
        }
    }

    @Override
    public void setApiKeyParmNameInQuery(String apiKeyParmNameInQuery) throws InvalidPropertyException {
        String string = apiKeyParmNameInQuery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_21, joinPoint);
            this.localAttributes.put(ParserProperty.apiKeyParmNameInQuery, apiKeyParmNameInQuery);
            this.getApiKeySchemeFromProperties();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_21);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_21);
            throw throwable;
        }
    }

    @Override
    public void setApiKeyParmNameInCookie(String apiKeyParmNameInCookie) throws InvalidPropertyException {
        String string = apiKeyParmNameInCookie;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_22, joinPoint);
            this.localAttributes.put(ParserProperty.apiKeyParmNameInCookie, apiKeyParmNameInCookie);
            this.getApiKeySchemeFromProperties();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_22);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_22);
            throw throwable;
        }
    }

    @Override
    public void setApiKeyMaxLength(String apiKeyMaxLength) throws InvalidPropertyException {
        String string = apiKeyMaxLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_23, joinPoint);
            this.localAttributes.put(ParserProperty.apiKeyMaxLength, apiKeyMaxLength);
            this.checkAPIKeyMaxLength();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_23);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_23);
            throw throwable;
        }
    }

    @Override
    public void setOperations(String operations) throws InvalidPropertyException {
        String string = operations;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_24, joinPoint);
            this.localAttributes.put(ParserProperty.operations, operations);
            this.checkOperations();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_24);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_24);
            throw throwable;
        }
    }

    @Override
    public void setExecutionMode(String mode) throws InvalidPropertyException {
        String string = mode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_25, joinPoint);
            this.localAttributes.put(ParserProperty.executionMode, mode);
            this.checkExecutionMode();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_25);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_25);
            throw throwable;
        }
    }

    @Override
    public void setApiName(String apiName) throws InvalidPropertyException {
        String string = apiName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_26, joinPoint);
            this.localAttributes.put(ParserProperty.apiName, apiName);
            this.checkApiName();
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_26);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_26);
            throw throwable;
        }
    }

    @Override
    public void setRequestMediaType(String mediaType) throws InvalidPropertyException {
        String string = mediaType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_27, joinPoint);
            this.localAttributes.put(ParserProperty.requestMediaType, mediaType);
            this.checkRequestMediaType(ParserProperty.requestMediaType.toString(), mediaType);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_27);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_27);
            throw throwable;
        }
    }

    @Override
    public void setDefaultRequestMediaType(String mediaType) {
        String string = mediaType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_28, joinPoint);
            this.localAttributes.put(ParserProperty.defaultRequestMediaType, mediaType);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_28);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_28);
            throw throwable;
        }
    }

    @Override
    public void setResponseMediaType(String mediaType) throws InvalidPropertyException {
        String string = mediaType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_29, joinPoint);
            this.localAttributes.put(ParserProperty.responseMediaType, mediaType);
            this.checkResponseMediaType(ParserProperty.responseMediaType.toString(), mediaType);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_29);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_29);
            throw throwable;
        }
    }

    @Override
    public void setDefaultResponseMediaType(String mediaType) {
        String string = mediaType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_30, joinPoint);
            this.localAttributes.put(ParserProperty.defaultResponseMediaType, mediaType);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_30);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_30);
            throw throwable;
        }
    }

    @Override
    public void setRequesterExtension(String extension) {
        String string = extension;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_31, joinPoint);
            this.localAttributes.put(ParserProperty.requesterExtension, extension);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_31);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_31);
            throw throwable;
        }
    }

    @Override
    public void setProviderExtension(String extension) {
        String string = extension;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_32, joinPoint);
            this.localAttributes.put(ParserProperty.providerExtension, extension);
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_32);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_32);
            throw throwable;
        }
    }

    @Override
    public ParseResult parse(Path document) throws InvalidOpenApiDocumentException, DuplicateParseAttemptException, InvalidPropertyException, OperationProcessingException {
        Path path = document;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)path);
        try {
            ParseResultImpl parseResultImpl;
            ParseResultImpl parseResultImpl2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_33, joinPoint);
            try {
                if (this.parsed) {
                    String reason = this.message.getMessage("DUPLICATE_PARSE_ATTEMPTED", new Object[0]);
                    throw new DuplicateParseAttemptException(reason);
                }
                this.parsed = true;
                this.validateProperties();
                this.processDocument(document);
            }
            catch (IOException | JAXBException e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                throw new OperationProcessingException(reason, e);
            }
            catch (InvalidPropertyException e) {
                this.parseResult.setParseStatus(ParseStatus.FAILURE);
                throw e;
            }
            ParseResultImpl parseResultImpl3 = parseResultImpl2 = (parseResultImpl = this.parseResult);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(parseResultImpl2, ajc$tjp_33);
            return parseResultImpl;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_33);
            throw throwable;
        }
    }

    private void setupParser() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_34, joinPoint);
            if (this.parseResult == null) {
                this.parseResult = new ParseResultImpl(this.message);
                this.temporaryStore = Files.createTempDirectory("BAQ", new FileAttribute[0]);
                this.parseResult.setTemporaryStore(this.temporaryStore);
                this.logFile = File.createTempFile("BAQ", "log", this.temporaryStore.toFile());
                this.logPrintStream = new PrintStream(this.logFile, "UTF-8");
                this.parseResult.setLog(this.logFile, this.logPrintStream);
            }
            cicsErrorMessageConversions.put(levelBeyondLimitationErrorCode, this.message.getMessage("OPENAPI_DOCUMENT_INVALID_NESTING_LEVEL", new Object[0]));
            cicsErrorMessageConversions.put(cicsContainersProhibitedErrorCode, this.message.getMessage("OPENAPI_DOCUMENT_CHAR_ARRAY_MAX_SIZE_EXCEEDED", new Object[0]));
            cicsErrorMessageConversions.put(invalidJSONschemaErrorCode, this.message.getMessage("OPENAPI_DOCUMENT_RESP_REF_TYPE", new Object[0]));
            cicsErrorMessageConversions.put(noEnumConstantFound, this.message.getMessage("OPENAPI_DOCUMENT_NO_ENUM_CONSTANT_FOUND", new Object[0]));
            cicsErrorMessageConversions.put(recursiveJSONPointer, this.message.getMessage("OPENAPI_DOCUMENT_CICS_INVALID_REF_WITH_LOOP", new Object[0]));
            Object var2_2 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var2_2, ajc$tjp_34);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_34);
            throw throwable;
        }
    }

    private ParseResultImpl processDocument(Path document) throws InvalidOpenApiDocumentException, IOException, JAXBException {
        Path path = document;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)path);
        try {
            ParseResultImpl parseResultImpl;
            ParseResultImpl parseResultImpl2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_35, joinPoint);
            this.parseOpenAPIDocument(document);
            Map securitySchemes = this.components != null ? this.components.getSecuritySchemes() : null;
            List globalSecurityRequirements = this.openAPI.getSecurity();
            HashMap<String, String> storedPaths = new HashMap<String, String>();
            for (String currentPath : this.paths.keySet()) {
                String normalizedPath = currentPath.replaceAll("\\{(.*?)\\}", "{}");
                for (String path2 : storedPaths.keySet()) {
                    if (!normalizedPath.equals(path2)) continue;
                    this.parseResult.setParseStatus(ParseStatus.FAILURE);
                    InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_DUPLICATE_PATHS", currentPath)));
                    logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                    throw ise;
                }
                storedPaths.put(normalizedPath, normalizedPath);
            }
            for (Map.Entry pathEntry : this.paths.entrySet()) {
                PathItem pathItem = (PathItem)pathEntry.getValue();
                String path3 = (String)pathEntry.getKey();
                path3 = this.validateCharsInPath(path3);
                Map operationMap = pathItem.readOperationsMap();
                for (Map.Entry operationEntry : operationMap.entrySet()) {
                    this.responseMappingXXX.clear();
                    if (this.requiredOperations != null) {
                        boolean requiredOperation = false;
                        for (String operation : this.requiredOperations) {
                            if (!((Operation)operationEntry.getValue()).getOperationId().equals(operation)) continue;
                            requiredOperation = true;
                            break;
                        }
                        if (!requiredOperation) {
                            this.message.printMessage(this.logPrintStream, "OPERATION_NOT_PROCESSED", ((Operation)operationEntry.getValue()).getOperationId());
                            this.parseResult.setParseStatus(ParseStatus.WARNINGS);
                            continue;
                        }
                    }
                    ParsedOperationImpl parsedOperation = new ParsedOperationImpl();
                    parsedOperation.setPath(path3);
                    String method = ((PathItem.HttpMethod)operationEntry.getKey()).name().toUpperCase();
                    if (HTTP_SUPPORTED_METHODS.stream().filter(m -> {
                        String string = method;
                        String string2 = m;
                        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_92, null, null, (Object)string, (Object)string2);
                        try {
                            boolean bl;
                            boolean bl2;
                            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_92, joinPoint);
                            boolean bl3 = bl2 = (bl = m.equals(method));
                            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(Conversions.booleanObject((boolean)bl2), ajc$tjp_92);
                            return bl;
                        }
                        catch (Throwable throwable) {
                            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_92);
                            throw throwable;
                        }
                    }).collect(Collectors.toList()).size() == 0) {
                        this.parseResult.setParseStatus(ParseStatus.FAILURE);
                        InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_UNSUPPORTED_METHOD", method)));
                        logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                        throw ise;
                    }
                    parsedOperation.setMethod(method);
                    parsedOperation.setRequestJsonSchemaWrapper(new JsonSchemaWrapper(this.oasVersion, this.message));
                    parsedOperation.setResponseJsonSchemaWrapper(new JsonSchemaWrapper(this.oasVersion, this.message));
                    Map.Entry<String, String> operationIdEntry = NameUtil.generateOperationName(((Operation)operationEntry.getValue()).getOperationId(), path3, parsedOperation.getMethod(), this.operationSeq);
                    String operationId = operationIdEntry.getKey();
                    parsedOperation.setOperationId(operationId);
                    String fullOperation = operationIdEntry.getValue();
                    parsedOperation.setFullOperationId(fullOperation);
                    this.requestMapping = new StringBuffer();
                    this.requestMapping.append("---");
                    this.requestMapping.append(System.lineSeparator());
                    this.requestMapping.append("version: 1");
                    this.requestMapping.append(System.lineSeparator());
                    this.requestMapping.append("mappings:");
                    this.requestMapping.append(System.lineSeparator());
                    if (this.executionMode == ExecutionMode.PROVIDER) {
                        this.requestMapping.append("- channel:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("    mappings:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("    - DFHWS-URI:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("        template: \"");
                        String uriTemplate = parsedOperation.getPath();
                        List parameters = ((Operation)operationEntry.getValue()).getParameters();
                        if (parameters != null) {
                            for (Parameter parameter : parameters) {
                                if (!"path".equals(parameter.getIn())) continue;
                                uriTemplate = uriTemplate.replaceAll("\\{" + parameter.getName() + "}", "\\{\\{\\$pathParameters.'" + parameter.getName() + "'}}");
                            }
                        }
                        this.requestMapping.append(uriTemplate);
                        this.requestMapping.append("\"");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("    - DFHWS-URI-QUERY:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("        template: \"{{$join($each($queryParameters, function($value, $key) {$key & \\\"=\\\" & $value}), \\\"&\\\")}}\"");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("    - DFHHTTPMETHOD:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("        template: \"" + parsedOperation.getMethod() + "\"");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("    - data:");
                        this.requestMapping.append(System.lineSeparator());
                        this.requestMapping.append("        mappings:");
                        this.requestMapping.append(System.lineSeparator());
                    }
                    this.responseMapping = new StringBuffer();
                    this.responseMapping.append("---");
                    this.responseMapping.append(System.lineSeparator());
                    this.responseMapping.append("version: 1");
                    this.responseMapping.append(System.lineSeparator());
                    Operation openapiOperation = (Operation)operationEntry.getValue();
                    if (openapiOperation.getDeprecated() != null && openapiOperation.getDeprecated().booleanValue()) {
                        this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_DEPRECATED", openapiOperation.getOperationId());
                        this.parseResult.setParseStatus(ParseStatus.WARNINGS);
                    }
                    try {
                        parsedOperation.setSecuritySchemes(securitySchemes);
                        this.processParameters(parsedOperation, pathItem, openapiOperation, globalSecurityRequirements);
                        this.processRequestBody(parsedOperation, openapiOperation.getRequestBody());
                        this.processResponses(parsedOperation, openapiOperation.getResponses(), openapiOperation, path3, method);
                        if (openapiOperation.getCallbacks() != null) {
                            HashMap<String, Callback> callbacks = new HashMap<String, Callback>();
                            for (Map.Entry entry : openapiOperation.getCallbacks().entrySet()) {
                                Callback callback = (Callback)entry.getValue();
                                if (callback.get$ref() != null) {
                                    String ref = callback.get$ref();
                                    String suffix = this.validateReference(ref, "callbacks");
                                    Callback callback2 = callback = this.components != null ? (Callback)this.components.getCallbacks().get(suffix) : null;
                                    if (callback == null) {
                                        throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "callbacks"));
                                    }
                                }
                                callbacks.put((String)entry.getKey(), callback);
                            }
                            parsedOperation.setCallbacks(callbacks);
                        }
                        this.createJSONSchemaToDriveDFHJS2LS(parsedOperation);
                        if (!this.parseResult.getFailedOperations().containsKey(operationId)) {
                            this.parseResult.getParsedOperations().put(operationId, parsedOperation);
                        }
                        ++this.operationSeq;
                        logger.debug("ParsedOperation", (Object)parsedOperation);
                    }
                    catch (OperationProcessingException e) {
                        this.parseResult.getFailedOperations().put(operationId, parsedOperation);
                        this.message.printMessage(this.logPrintStream, "PARSER_UNSUPPORTED_OPENAPI_DOCUMENT", fullOperation, path3, method, e.getMessage());
                        logger.error(this.message.getMessage("PARSER_UNSUPPORTED_OPENAPI_DOCUMENT", fullOperation, path3, method, e.getMessage()));
                    }
                    catch (InvalidOpenApiDocumentException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace(this.logPrintStream);
                        this.parseResult.getFailedOperations().put(operationId, parsedOperation);
                        this.message.printMessage(this.logPrintStream, "PARSER_UNEXPECTED_ERROR", fullOperation, path3, method, e.getMessage());
                        logger.error(this.message.getMessage("PARSER_UNEXPECTED_ERROR", fullOperation, path3, method, e.getMessage()));
                    }
                }
            }
            this.constructParseSummaryReport();
            if (this.parseResult.getParsedOperations().size() == 0) {
                this.message.printMessage(this.logPrintStream, "NO_OPERATION_SUCCESS", new Object[0]);
                this.parseResult.setParseStatus(ParseStatus.FAILURE);
            } else if (this.parseResult.getFailedOperations().size() > 0) {
                this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_ERRORS", new Object[0]);
                this.parseResult.setParseStatus(ParseStatus.OPERATION_FAILED);
            } else {
                this.message.printMessage(this.logPrintStream, "PARSER_SUCCESS", new Object[0]);
            }
            this.parseResult.createLogInputStream();
            logger.debug("ParseResult", (Object)this.parseResult);
            ParseResultImpl parseResultImpl3 = parseResultImpl2 = (parseResultImpl = this.parseResult);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(parseResultImpl2, ajc$tjp_35);
            return parseResultImpl;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_35);
            throw throwable;
        }
    }

    private void parseOpenAPIDocument(Path document) throws InvalidOpenApiDocumentException, IOException {
        Path path = document;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)path);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_36, joinPoint);
            OpenAPIV3Parser parser = new OpenAPIV3Parser();
            ParseOptions options2 = new ParseOptions();
            options2.setResolve(true);
            options2.setLegacyYamlDeserialization(true);
            SwaggerParseResult result = parser.readLocation(document.toString(), null, options2);
            if (result.getMessages() != null && result.getMessages().size() > 0) {
                List messages = result.getMessages();
                StringBuilder sb = new StringBuilder();
                for (String message : messages) {
                    logger.debug(message);
                    sb.append(message);
                    if (sb.length() <= 0) continue;
                    sb.append("\n");
                }
                InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", sb.toString()));
                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                throw ise;
            }
            this.openAPI = result.getOpenAPI();
            if (this.openAPI == null) {
                this.parseResult.setParseStatus(ParseStatus.FAILURE);
                InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_UNKNOWN_PROBLEM", new Object[0])));
                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                throw ise;
            }
            String version = this.openAPI.getOpenapi();
            if (SUPPORTED_OPENAPI_VERSIONS.indexOf(version.substring(0, 3)) == -1) {
                InvalidOpenApiDocumentException e = new InvalidOpenApiDocumentException(this.message.getMessage("PARSER_UNSUPPORTED_OPENAPI_VERSION", version, SUPPORTED_OPENAPI_VERSIONS));
                logger.error("Invalid OpenAPI Document version", (Object)e.getMessage());
                throw e;
            }
            if (version.startsWith("3.1")) {
                this.oasVersion = OASVersion.THREEONE;
            }
            this.info = this.openAPI.getInfo();
            this.paths = this.openAPI.getPaths();
            this.components = this.openAPI.getComponents();
            this.apiName = this.executionMode == ExecutionMode.REQUESTER ? this.getArgValue(ParserProperty.apiName) : URLEncoder.encode(this.info.getTitle(), StandardCharsets.UTF_8.name());
            this.parseResult.setApiName(this.apiName);
            this.parseResult.setApiVersion("");
            this.parseResult.setOpenApi(this.openAPI);
            Object var11_14 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var11_14, ajc$tjp_36);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_36);
            throw throwable;
        }
    }

    private void processParameters(ParsedOperationImpl parsedOperation, PathItem pathItem, Operation operation, List<SecurityRequirement> globalSecurityRequirements) throws OperationProcessingException, InvalidPropertyException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        PathItem pathItem2 = pathItem;
        Operation operation2 = operation;
        List<SecurityRequirement> list = globalSecurityRequirements;
        Object[] objectArray = new Object[]{parsedOperationImpl, pathItem2, operation2, list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        try {
            Parameter p;
            SecurityScheme scheme;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_37, joinPoint);
            ArrayList<Parameter> operationParams = pathItem.getParameters();
            if (operationParams == null) {
                operationParams = new ArrayList<Parameter>();
            }
            if (operation.getParameters() != null) {
                operationParams.addAll(operation.getParameters());
            }
            HashMap securitySchemeNames = new HashMap();
            if (operation.getSecurity() != null) {
                parsedOperation.setSecurityRequirements(operation.getSecurity());
                for (SecurityRequirement requirement : operation.getSecurity()) {
                    for (String securitySchemeName : requirement.keySet()) {
                        SecurityScheme securityScheme = this.components != null ? (this.components.getSecuritySchemes() != null ? (SecurityScheme)this.components.getSecuritySchemes().get(securitySchemeName) : null) : (scheme = null);
                        if (scheme == null) {
                            throw new OperationProcessingException(this.message.getMessage("PARSER_SECURITY_SCHEME_NOT_FOUND", securitySchemeName, operation.getOperationId()));
                        }
                        if (scheme.getType() == SecurityScheme.Type.APIKEY) {
                            securitySchemeNames.put(scheme.getName(), null);
                            p = this.processApiKeyMappings(scheme);
                            if (p != null) {
                                operationParams.add(p);
                                IGNORED_HEADERS.remove(p.getName().toLowerCase());
                            }
                        }
                        if (this.apiKeyDefinitionFromProperties == null || this.apiKeyDefinitionFromProperties.size() <= 0) continue;
                        this.message.printMessage(this.logPrintStream, "PARSER_APIKEY_OVERRIDDEN", this.apiKeyNameProperty);
                    }
                }
            } else if (globalSecurityRequirements != null) {
                for (SecurityRequirement requirement : globalSecurityRequirements) {
                    for (String securitySchemeName : requirement.keySet()) {
                        SecurityScheme securityScheme = this.components != null ? (this.components.getSecuritySchemes() != null ? (SecurityScheme)this.components.getSecuritySchemes().get(securitySchemeName) : null) : (scheme = null);
                        if (scheme == null) {
                            throw new OperationProcessingException(this.message.getMessage("PARSER_SECURITY_SCHEME_NOT_FOUND", securitySchemeName, operation.getOperationId()));
                        }
                        if (scheme.getType() == SecurityScheme.Type.APIKEY) {
                            securitySchemeNames.put(scheme.getName(), null);
                            p = this.processApiKeyMappings(scheme);
                            if (p != null) {
                                operationParams.add(p);
                                IGNORED_HEADERS.remove(p.getName().toLowerCase());
                            }
                        }
                        if (this.apiKeyDefinitionFromProperties == null || this.apiKeyDefinitionFromProperties.size() <= 0) continue;
                        this.message.printMessage(this.logPrintStream, "PARSER_APIKEY_OVERRIDDEN", this.apiKeyNameProperty);
                    }
                }
            } else if (this.apiKeyDefinitionFromProperties != null && this.apiKeyDefinitionFromProperties.size() > 0) {
                for (SecurityScheme securityScheme : this.apiKeyDefinitionFromProperties.values()) {
                    securitySchemeNames.put(securityScheme.getName(), null);
                    Parameter p2 = this.processApiKeyMappings(securityScheme);
                    if (p2 == null) continue;
                    operationParams.add(p2);
                    IGNORED_HEADERS.remove(p2.getName().toLowerCase());
                }
            }
            if (operationParams != null && operationParams.size() > 0) {
                String[] inTypes;
                ArrayList<Parameter> filteredParams = new ArrayList<Parameter>();
                for (String inType : inTypes = new String[]{ParameterType.PathParameters.getType(), ParameterType.QueryParameters.getType(), ParameterType.Headers.getType(), ParameterType.Cookies.getType()}) {
                    filteredParams = new ArrayList();
                    for (Parameter param : operationParams) {
                        if (param.get$ref() != null) {
                            String ref = param.get$ref();
                            String suffix = this.validateReference(ref, "parameters");
                            Parameter parameter = param = this.components != null ? (Parameter)this.components.getParameters().get(suffix) : null;
                            if (param == null) {
                                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "parameters"));
                            }
                        }
                        if (param.getIn() == null || !param.getIn().equalsIgnoreCase(inType)) continue;
                        filteredParams.add(param);
                    }
                    String modifiedInType = "";
                    String indent = "";
                    if (filteredParams.size() > 0) {
                        if (this.executionMode == ExecutionMode.PROVIDER) {
                            indent = "        ";
                        }
                        if (inType.equals("path")) {
                            this.requestMapping.append(indent + "- requestPathParameters:\n");
                            this.requestMapping.append(indent + "    mappings:\n");
                            modifiedInType = this.executionMode == ExecutionMode.PROVIDER ? "pathParameters" : "requestPathParameters";
                        } else if (inType.equals("query")) {
                            this.requestMapping.append(indent + "- requestQueryParameters:\n");
                            this.requestMapping.append(indent + "    mappings:\n");
                            modifiedInType = this.executionMode == ExecutionMode.PROVIDER ? "queryParameters" : "requestQueryParameters";
                        } else if (inType.equals("header")) {
                            this.requestMapping.append(indent + "- requestHeaders:\n");
                            this.requestMapping.append(indent + "    mappings:\n");
                            modifiedInType = this.executionMode == ExecutionMode.PROVIDER ? "headers" : "requestHeaders";
                        } else if (inType.equals("cookie")) {
                            this.requestMapping.append(indent + "- requestCookies:\n");
                            this.requestMapping.append(indent + "    mappings:\n");
                            modifiedInType = this.executionMode == ExecutionMode.PROVIDER ? "cookies" : "requestCookies";
                        }
                    }
                    for (Parameter param : filteredParams) {
                        if (param.getIn().equals("header") && this.isIgnored(param.getName())) {
                            this.message.printMessage(this.logPrintStream, "HEADER_IGNORED", param.getName());
                            this.parseResult.setParseStatus(ParseStatus.WARNINGS);
                            continue;
                        }
                        String name = param.getName();
                        String in = param.getIn();
                        Schema schema = this.processParameter(modifiedInType, param, indent + "    ");
                        parsedOperation.getRequestJsonSchemaWrapper().addParameters(this.logPrintStream, name, in, (boolean)param.getRequired(), schema);
                        if (!"header".equals(in) && !"cookie".equals(in) && !"query".equals(in) || securitySchemeNames.size() <= 0 || "$$SEC-SCHEME$$".equals(param.getDescription()) || !securitySchemeNames.containsKey(name)) continue;
                        throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_DUPLICATE_APIKEY_DEF", name, in));
                    }
                }
            }
            Object var26_28 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var26_28, ajc$tjp_37);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_37);
            throw throwable;
        }
    }

    private Parameter processApiKeyMappings(SecurityScheme securityScheme) throws OperationProcessingException {
        SecurityScheme securityScheme2 = securityScheme;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)securityScheme2);
        try {
            Parameter parameter;
            Parameter parameter2;
            Parameter parameter3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_38, joinPoint);
            Parameter parameter4 = new Parameter();
            parameter4.name(securityScheme.getName());
            parameter4.description("$$SEC-SCHEME$$");
            Schema schema = new Schema();
            schema.type("string");
            String length = this.getArgValue(ParserProperty.apiKeyMaxLength);
            if (length == null) {
                length = "255";
            }
            schema.maxLength(Integer.valueOf(length));
            parameter4.schema(schema);
            parameter4.required(Boolean.valueOf(true));
            SecurityScheme.In in = securityScheme.getIn();
            if (in.compareTo((Enum)SecurityScheme.In.HEADER) == 0) {
                parameter4.in("header");
                parameter2 = parameter3 = parameter4;
            } else if (in.compareTo((Enum)SecurityScheme.In.QUERY) == 0) {
                parameter4.in("query");
                parameter2 = parameter3 = parameter4;
            } else if (in.compareTo((Enum)SecurityScheme.In.COOKIE) == 0) {
                parameter4.in("cookie");
                parameter2 = parameter3 = parameter4;
            } else {
                parameter2 = parameter3 = null;
            }
            Parameter parameter5 = parameter = parameter2;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(parameter, ajc$tjp_38);
            return parameter3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_38);
            throw throwable;
        }
    }

    private Schema checkParameter(Parameter parameter) throws OperationProcessingException {
        Parameter parameter2 = parameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)parameter2);
        try {
            Schema schema;
            Schema schema2;
            Schema schema3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_39, joinPoint);
            if (parameter.getDeprecated() != null && parameter.getDeprecated().booleanValue()) {
                this.message.printMessage(this.logPrintStream, "PARSER_PARAMETER_DEPRECATED", parameter.getName());
                this.parseResult.setParseStatus(ParseStatus.WARNINGS);
            }
            if ((schema3 = parameter.getSchema()) != null && parameter.getContent() != null) {
                throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_PARAMETER_ERROR", parameter.getName()));
            }
            if (schema3 == null) {
                Content content = parameter.getContent();
                if (content == null) {
                    throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_PARAMETER_ERROR", parameter.getName()));
                }
                Iterator iterator = content.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    schema3 = ((MediaType)entry.getValue()).getSchema();
                }
            }
            if (schema3 != null) {
                String type;
                if (schema3.get$ref() != null) {
                    String ref = schema3.get$ref();
                    String suffix = this.validateReference(ref, "schemas");
                    Schema schema4 = schema3 = this.components != null ? (Schema)this.components.getSchemas().get(suffix) : null;
                    if (schema3 == null) {
                        throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "schemas"));
                    }
                }
                if (!SUPPORTED_SIMPLE_TYPES.contains(type = schema3.getType())) {
                    String reason = this.message.getMessage("OPENAPI_DOCUMENT_SIMPLE_PARAM_TYPE", parameter.getName(), type, SUPPORTED_SIMPLE_TYPES);
                    throw new OperationProcessingException(reason);
                }
            }
            Schema schema5 = schema2 = (schema = schema3);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(schema2, ajc$tjp_39);
            return schema;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_39);
            throw throwable;
        }
    }

    private void processRequestBody(ParsedOperationImpl parsedOperation, RequestBody requestBody) throws OperationProcessingException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        RequestBody requestBody2 = requestBody;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)parsedOperationImpl, (Object)requestBody2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_40, joinPoint);
            if (requestBody != null) {
                Content content;
                if (requestBody.get$ref() != null) {
                    String ref = requestBody.get$ref();
                    String suffix = this.validateReference(ref, "requestBodies");
                    RequestBody requestBody3 = requestBody = this.components != null ? (RequestBody)this.components.getRequestBodies().get(suffix) : null;
                    if (requestBody == null) {
                        throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "requestBodies"));
                    }
                }
                if ((content = requestBody.getContent()) != null) {
                    int numberMediaTypes = content.entrySet().size();
                    String key = this.operationMediaType.get(ParserProperty.requestMediaType.toString() + "/" + parsedOperation.getFullOperationId());
                    int json = 0;
                    String jsonType = null;
                    String defaultType = null;
                    MediaType mediaType = null;
                    MediaType defaultMediaType = null;
                    String defaultRequestMediaType = this.getArgValue(ParserProperty.defaultRequestMediaType);
                    for (Map.Entry entry : content.entrySet()) {
                        if (numberMediaTypes == 1) {
                            parsedOperation.setRequestMediaType((String)entry.getKey());
                            mediaType = (MediaType)entry.getValue();
                            break;
                        }
                        if (key != null) {
                            if (!key.equals(entry.getKey())) continue;
                            parsedOperation.setRequestMediaType((String)entry.getKey());
                            mediaType = (MediaType)entry.getValue();
                            break;
                        }
                        if (((String)entry.getKey()).matches("^application\\/(.+\\+)?json$")) {
                            ++json;
                            jsonType = (String)entry.getKey();
                            mediaType = (MediaType)entry.getValue();
                        }
                        if (!((String)entry.getKey()).equals(defaultRequestMediaType)) continue;
                        defaultType = (String)entry.getKey();
                        defaultMediaType = (MediaType)entry.getValue();
                    }
                    if (parsedOperation.getRequestMediaType() == null) {
                        if (json == 1) {
                            parsedOperation.setRequestMediaType(jsonType);
                        } else if (defaultType != null) {
                            parsedOperation.setRequestMediaType(defaultType);
                            mediaType = defaultMediaType;
                        } else {
                            if (key == null && (json > 1 || numberMediaTypes > 1)) {
                                throw new OperationProcessingException(this.message.getMessage("MULTIPLE_MEDIA_TYPES_EXIST", parsedOperation.getFullOperationId(), "requestBody", ParserProperty.requestMediaType.toString()));
                            }
                            throw new OperationProcessingException(this.message.getMessage("MEDIA_TYPE_NOT_LOCATED", parsedOperation.getFullOperationId(), "requestBody", ParserProperty.requestMediaType.toString()));
                        }
                    }
                    if (mediaType != null) {
                        Schema schema = mediaType.getSchema();
                        if (schema == null) {
                            throw new OperationProcessingException(this.message.getMessage("MISSING_SCHEMA", "Request"));
                        }
                        if (schema.get$ref() != null) {
                            String ref = schema.get$ref();
                            String suffix = this.validateReference(ref, "schemas");
                            Schema schema2 = schema = this.components != null ? (Schema)this.components.getSchemas().get(suffix) : null;
                            if (schema == null) {
                                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "schemas"));
                            }
                        }
                        String indent = "";
                        String location = "requestBody";
                        if (this.executionMode == ExecutionMode.PROVIDER) {
                            indent = "        ";
                            location = "body";
                        }
                        this.requestMapping.append(indent + "- requestBody:\n");
                        this.processSchema(this.resolveSchema(schema, null), null, this.requestMapping, location, indent + "    ");
                        parsedOperation.getRequestJsonSchemaWrapper().setRequestBody(schema);
                    }
                }
            }
            Object var18_19 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var18_19, ajc$tjp_40);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_40);
            throw throwable;
        }
    }

    private static String jsonataString(String s) {
        String string = s;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, null, null, (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_41, joinPoint);
            s = backslash.matcher(s).replaceAll("\\\\\\\\");
            s = quotes.matcher(s).replaceAll("\\\\'");
            String string4 = string3 = (string2 = "'" + s + "'");
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_41);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_41);
            throw throwable;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void processResponses(ParsedOperationImpl parsedOperation, ApiResponses apiResponses, Operation operation, String relativePath, String method) throws OperationProcessingException, InvalidOpenApiDocumentException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        ApiResponses apiResponses2 = apiResponses;
        Operation operation2 = operation;
        String string = relativePath;
        String string2 = method;
        Object[] objectArray = new Object[]{parsedOperationImpl, apiResponses2, operation2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_42, joinPoint);
            ApiResponses responses = operation.getResponses();
            if (responses.size() == 0) {
                throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_NO_RESPONSES", new Object[0])));
            }
            int responseCounter = 0;
            if (this.executionMode == ExecutionMode.PROVIDER && responses.containsKey((Object)"500")) {
                ApiResponse lastResponse = (ApiResponse)responses.get((Object)"500");
                responses.remove((Object)"500");
                responses.put((Object)"900", (Object)lastResponse);
            }
            Map ordered = responses.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
                ApiResponse apiResponse = e1;
                ApiResponse apiResponse2 = e2;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_91, null, null, (Object)apiResponse, (Object)apiResponse2);
                try {
                    ApiResponse apiResponse3;
                    ApiResponse apiResponse4;
                    TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_91, joinPoint);
                    ApiResponse apiResponse5 = apiResponse4 = (apiResponse3 = e1);
                    TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(apiResponse4, ajc$tjp_91);
                    return apiResponse3;
                }
                catch (Throwable throwable) {
                    TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_91);
                    throw throwable;
                }
            }, LinkedHashMap::new));
            for (Map.Entry entry : ordered.entrySet()) {
                Content content;
                Map headers;
                String suffix;
                String ref;
                String code;
                StringBuffer responseMappingXXXFile;
                block57: {
                    ++responseCounter;
                    responseMappingXXXFile = new StringBuffer();
                    code = (String)entry.getKey();
                    if (code.equals("900")) {
                        code = "500";
                    }
                    if (!(code.equals("1XX") || code.equals("2XX") || code.equals("3XX") || code.equals("4XX") || code.equals("5XX") || code.matches("\\d\\d\\d") || code.equals(HTTP_STATUS_CODE_DEFAULT))) {
                        InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_INVALID_HTTP_STATUS", code)));
                        logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                        throw ise;
                    }
                    if (!code.substring(1, 3).equals("XX") && !code.equals(HTTP_STATUS_CODE_DEFAULT)) {
                        InvalidOpenApiDocumentException ise;
                        try {
                            int iCode = Integer.parseInt(code);
                            if (iCode < 100 || iCode > 599) {
                                ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_INVALID_HTTP_STATUS", code)));
                                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                                throw ise;
                            }
                            break block57;
                        }
                        catch (NumberFormatException e) {
                            ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_INVALID_HTTP_STATUS", code)));
                            logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                            throw ise;
                        }
                    }
                    if (this.executionMode == ExecutionMode.PROVIDER) {
                        throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_WILDCARDS_NOT_SUPPORTED", new Object[0])));
                    }
                }
                this.responseMapping.append("response_" + code + ".yaml:\n");
                if (code.equals(HTTP_STATUS_CODE_DEFAULT)) {
                    this.responseMapping.append("  condition: true\n");
                    this.responseMapping.append("  httpStatusCode: 000\n");
                } else if (code.contains("XX")) {
                    Integer codeHigh = Integer.valueOf(code.substring(0, 1));
                    this.responseMapping.append("  condition: \"$apiResponse.statusCode >= " + codeHigh + "00 and $apiResponse.statusCode < " + (codeHigh + 1) + "00\"\n");
                    this.responseMapping.append("  httpStatusCode: 000\n");
                } else if (this.executionMode == ExecutionMode.REQUESTER) {
                    this.responseMapping.append("  condition: \"$apiResponse.statusCode = " + code + "\"\n");
                    this.responseMapping.append("  httpStatusCode: " + code + "\n");
                } else {
                    if (responseCounter < responses.size()) {
                        this.responseMapping.append("  condition: \"$exists($zosAssetResponse.channel.responseCode" + code + ") and $boolean($zosAssetResponse.channel.responseCode" + code + ")\"\n");
                    } else {
                        this.responseMapping.append("  condition: true\n");
                    }
                    this.responseMapping.append("  httpStatusCode: " + code + "\n");
                }
                responseMappingXXXFile.append("---\n");
                responseMappingXXXFile.append("version: 1\n");
                responseMappingXXXFile.append("mappings:\n");
                ApiResponse response = (ApiResponse)entry.getValue();
                parsedOperation.setApiResponse(code, response);
                if (response.get$ref() != null) {
                    String ref2 = response.get$ref();
                    Iterator suffix2 = this.validateReference(ref2, "responses");
                    ApiResponse apiResponse = response = this.components != null ? (ApiResponse)this.components.getResponses().get(suffix2) : null;
                    if (response == null) {
                        throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref2, "responses"));
                    }
                }
                if (response.getLinks() != null) {
                    HashMap<String, Link> links = new HashMap<String, Link>();
                    for (Map.Entry linkEntry : response.getLinks().entrySet()) {
                        Link link = (Link)linkEntry.getValue();
                        if (link.get$ref() != null) {
                            ref = link.get$ref();
                            suffix = this.validateReference(ref, "links");
                            Link link2 = link = this.components != null ? (Link)this.components.getLinks().get(suffix) : null;
                            if (link == null) {
                                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "links"));
                            }
                        }
                        links.put((String)entry.getKey(), link);
                    }
                    response.setLinks(links);
                }
                if ((headers = response.getHeaders()) != null && headers.size() > 0) {
                    if (this.executionMode == ExecutionMode.REQUESTER) {
                        responseMappingXXXFile.append("- responseHeaders:\n");
                    } else {
                        responseMappingXXXFile.append("- headers:\n");
                    }
                    responseMappingXXXFile.append("    mappings:\n");
                    for (Map.Entry headerEntry : headers.entrySet()) {
                        if (this.isIgnored((String)headerEntry.getKey())) continue;
                        Header header = (Header)headerEntry.getValue();
                        if (header.get$ref() != null) {
                            ref = header.get$ref();
                            suffix = this.validateReference(ref, "headers");
                            Header header2 = header = this.components != null ? (Header)this.components.getHeaders().get(suffix) : null;
                            if (header == null) {
                                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "headers"));
                            }
                        }
                        responseMappingXXXFile.append("    - " + (String)headerEntry.getKey() + ":\n");
                        String headerName = OpenApiParserImpl.jsonataString((String)headerEntry.getKey());
                        if (this.executionMode == ExecutionMode.REQUESTER) {
                            if (header.getSchema().getType().equals("string")) {
                                responseMappingXXXFile.append("        template: \"{{$apiResponse.headers." + headerName + "}}\"\n");
                            } else {
                                responseMappingXXXFile.append("        expression: \"$apiResponse.headers." + headerName + "\"\n");
                            }
                        } else if (header.getSchema().getType().equals("string")) {
                            responseMappingXXXFile.append("        template: \"{{$zosAssetResponse.channel.responseHeaders." + headerName + "}}\"\n");
                        } else {
                            responseMappingXXXFile.append("        expression: \"$zosAssetResponse.channel.responseHeaders." + headerName + "\"\n");
                        }
                        Schema schema = this.processHeader(header, responseMappingXXXFile, "        ");
                        parsedOperation.getResponseJsonSchemaWrapper().addParameters(this.logPrintStream, (String)headerEntry.getKey(), ParameterType.Headers.getType(), false, schema);
                    }
                }
                if ((content = response.getContent()) != null) {
                    int numberMediaTypes = content.entrySet().size();
                    String key = this.operationMediaType.get(ParserProperty.responseMediaType.toString() + "/" + parsedOperation.getFullOperationId() + "/" + code);
                    int json = 0;
                    String jsonType = null;
                    String defaultType = null;
                    MediaType mediaType = null;
                    MediaType defaultMediaType = null;
                    String defaultResponseMediaType = this.getArgValue(ParserProperty.defaultResponseMediaType);
                    for (Map.Entry entrySet : content.entrySet()) {
                        if (numberMediaTypes == 1) {
                            parsedOperation.addResponseMediaType(code, (String)entrySet.getKey());
                            mediaType = (MediaType)entrySet.getValue();
                            break;
                        }
                        if (key != null) {
                            if (!key.equals(entrySet.getKey())) continue;
                            parsedOperation.addResponseMediaType(code, (String)entrySet.getKey());
                            mediaType = (MediaType)entrySet.getValue();
                            break;
                        }
                        if (((String)entrySet.getKey()).matches("^application\\/(.+\\+)?json$")) {
                            ++json;
                            jsonType = (String)entrySet.getKey();
                            mediaType = (MediaType)entrySet.getValue();
                        }
                        if (!((String)entrySet.getKey()).equals(defaultResponseMediaType)) continue;
                        defaultType = (String)entrySet.getKey();
                        defaultMediaType = (MediaType)entrySet.getValue();
                    }
                    if (parsedOperation.getResponseMediaType().get(code) == null) {
                        if (json == 1) {
                            parsedOperation.addResponseMediaType(code, jsonType);
                        } else if (defaultType != null) {
                            parsedOperation.addResponseMediaType(code, defaultType);
                            mediaType = defaultMediaType;
                        } else {
                            if (key == null && (json > 1 || numberMediaTypes > 1)) {
                                throw new OperationProcessingException(this.message.getMessage("MULTIPLE_MEDIA_TYPES_EXIST", parsedOperation.getFullOperationId(), "responses/" + code, ParserProperty.responseMediaType.toString()));
                            }
                            throw new OperationProcessingException(this.message.getMessage("MEDIA_TYPE_NOT_LOCATED", parsedOperation.getFullOperationId(), "responses/" + code, ParserProperty.responseMediaType.toString()));
                        }
                    }
                    if (mediaType != null) {
                        Schema schema = mediaType.getSchema();
                        if (schema == null) {
                            throw new OperationProcessingException(this.message.getMessage("MISSING_SCHEMA", code));
                        }
                        if (schema.get$ref() != null) {
                            String ref3 = schema.get$ref();
                            String suffix3 = this.validateReference(ref3, "schemas");
                            Schema schema2 = schema = this.components != null ? (Schema)this.components.getSchemas().get(suffix3) : null;
                            if (schema == null) {
                                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref3, "schemas"));
                            }
                        }
                        Parameter parm = new Parameter();
                        schema = this.resolveSchema(schema, null);
                        String responseCode = "";
                        if (code.equals(HTTP_STATUS_CODE_DEFAULT)) {
                            parm.setName("responseCodeDef");
                        } else {
                            responseCode = "responseCode" + code;
                            parm.setName(responseCode);
                        }
                        String location = "apiResponse.body";
                        if (this.executionMode == ExecutionMode.PROVIDER) {
                            location = "zosAssetResponse.channel." + responseCode;
                            parm.setName("body");
                        }
                        this.processSchema(schema, parm, responseMappingXXXFile, location, "");
                        parsedOperation.getResponseJsonSchemaWrapper().setResponseBody(code, schema);
                    }
                }
                this.responseMappingXXX.put(code, responseMappingXXXFile);
            }
            if (parsedOperation.getApiResponse("2") == null) {
                throw new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_NO_RESPONSE_SUCCESS", new Object[0])));
            }
            Object var35_41 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var35_41, ajc$tjp_42);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_42);
            throw throwable;
        }
    }

    private Schema resolveSchema(Schema schema, RefNode parent) throws OperationProcessingException {
        Schema schema2 = schema;
        RefNode refNode = parent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)schema2, (Object)refNode);
        try {
            Schema schema3;
            Schema schema4;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_43, joinPoint);
            RefNode node = new RefNode();
            node.setParent(parent);
            if (schema.get$ref() != null) {
                String ref = schema.get$ref();
                node.setReference(ref);
                this.checkForRefLoop(node);
                String suffix = this.validateReference(ref, "schemas");
                Schema schema5 = schema = this.components != null ? (Schema)this.components.getSchemas().get(suffix) : null;
                if (schema == null) {
                    throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "schemas"));
                }
            }
            if (schema instanceof ArraySchema) {
                ((ArraySchema)schema).setItems(this.resolveSchema(((ArraySchema)schema).getItems(), node));
            }
            if (schema instanceof ObjectSchema) {
                Map properties = schema.getProperties();
                LinkedHashMap<String, Schema> resolvedProperties = new LinkedHashMap<String, Schema>();
                if (properties != null) {
                    for (Map.Entry objectEntity : properties.entrySet()) {
                        resolvedProperties.put((String)objectEntity.getKey(), this.resolveSchema((Schema)objectEntity.getValue(), node));
                    }
                }
                schema.setProperties(resolvedProperties);
            }
            if (schema instanceof ComposedSchema) {
                List allOf = ((ComposedSchema)schema).getAllOf();
                List anyOf = ((ComposedSchema)schema).getAnyOf();
                List oneOf = ((ComposedSchema)schema).getOneOf();
                ArrayList<Schema> resolvedXOf = new ArrayList<Schema>();
                if (allOf != null) {
                    for (Schema ofSchema : allOf) {
                        resolvedXOf.add(this.resolveSchema(ofSchema, node));
                    }
                    ((ComposedSchema)schema).setAllOf(resolvedXOf);
                }
                if (anyOf != null) {
                    resolvedXOf.clear();
                    for (Schema ofSchema : anyOf) {
                        resolvedXOf.add(this.resolveSchema(ofSchema, node));
                    }
                    ((ComposedSchema)schema).setAnyOf(resolvedXOf);
                }
                if (oneOf != null) {
                    resolvedXOf.clear();
                    for (Schema ofSchema : oneOf) {
                        resolvedXOf.add(this.resolveSchema(ofSchema, node));
                    }
                    ((ComposedSchema)schema).setOneOf(resolvedXOf);
                }
            }
            Schema schema6 = schema4 = (schema3 = schema);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(schema4, ajc$tjp_43);
            return schema3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_43);
            throw throwable;
        }
    }

    private void checkForRefLoop(RefNode node) throws OperationProcessingException {
        RefNode refNode = node;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)refNode);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_44, joinPoint);
            String reference = node.getReference();
            StringBuilder references = new StringBuilder(reference);
            for (RefNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                references.append("->");
                references.append(parent.getReference());
                if (!reference.equals(parent.getReference())) continue;
                String reason = this.message.getMessage("OPENAPI_DOCUMENT_INVALID_REF_WITH_LOOP", references.toString());
                throw new OperationProcessingException(reason);
            }
            Object var8_8 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var8_8, ajc$tjp_44);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_44);
            throw throwable;
        }
    }

    private Schema processParameter(String inType, Parameter param, String indent) throws OperationProcessingException {
        String string = inType;
        Parameter parameter = param;
        String string2 = indent;
        Object[] objectArray = new Object[]{string, parameter, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object[])objectArray);
        try {
            Schema schema;
            Schema schema2;
            Schema schema3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_45, joinPoint);
            if (ParameterType.PathParameters.getType().equals(param.getIn())) {
                param.setRequired(Boolean.valueOf(true));
            }
            if ((schema3 = this.checkParameter(param)) != null) {
                schema3 = this.resolveSchema(schema3, null);
                this.processSchema(schema3, param, this.requestMapping, inType, indent);
            }
            Schema schema4 = schema2 = (schema = schema3);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(schema2, ajc$tjp_45);
            return schema;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_45);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSchema(Schema schema, Parameter param, StringBuffer mappingFile, String location, String indent) throws OperationProcessingException {
        Schema schema2 = schema;
        Parameter parameter = param;
        StringBuffer stringBuffer = mappingFile;
        String string = location;
        String string2 = indent;
        Object[] objectArray = new Object[]{schema2, parameter, stringBuffer, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_46, joinPoint);
            if (schema.get$ref() != null) {
                String ref = schema.get$ref();
                String suffix = this.validateReference(ref, "schemas");
                Schema schema3 = schema = this.components != null ? (Schema)this.components.getSchemas().get(suffix) : null;
                if (schema == null) {
                    throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_NOT_LOCATED", ref, "schemas"));
                }
            }
            schema.setExample(null);
            schema.setXml(null);
            schema.setTypes(null);
            if (schema instanceof ArraySchema) {
                Integer maxItems;
                ArraySchema arraySchema = (ArraySchema)schema;
                if (arraySchema.getMinItems() == null) {
                    arraySchema.setMinItems(Integer.valueOf(0));
                }
                if ((maxItems = arraySchema.getMaxItems()) != null && maxItems > 0x7FFFFEFF) {
                    this.parseResult.setParseStatus(ParseStatus.FAILURE);
                    OperationProcessingException ope = new OperationProcessingException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_ARRAY_MAXSIZE_THRESHOLD_EXCEEDED", param.getName(), maxItems, "maxItems", 0x7FFFFEFF)));
                    throw ope;
                }
                if (param != null && param.getName() != null) {
                    mappingFile.append(indent + "- " + param.getName() + ":\n");
                    this.createParameterMapping(param, mappingFile, indent, "array");
                    if (param.getIn() != null && (arraySchema.getItems().getType().equals("array") || arraySchema.getItems().getType().equals("object"))) {
                        String reason = this.message.getMessage("NESTED_TYPE_NOT_SUPPORTED", param.getName());
                        throw new OperationProcessingException(reason);
                    }
                    indent = indent + "    ";
                }
                mappingFile.append(indent + "foreach:\n");
                if (param != null && param.getIn() != null) {
                    mappingFile.append(indent + "    type: \"" + arraySchema.getItems().getType() + "\"\n");
                }
                indent = indent + "    ";
                mappingFile.append(indent);
                mappingFile.append("input: \"($a := $");
                mappingFile.append(location);
                if (param != null && param.getName() != null) {
                    if (this.executionMode == ExecutionMode.REQUESTER) {
                        if (!"apiResponse.body".equals(location) || !param.getName().startsWith("responseCode")) {
                            mappingFile.append('.');
                            mappingFile.append(OpenApiParserImpl.jsonataString(param.getName()));
                        }
                    } else if (!location.startsWith("zosAssetResponse.channel.responseCode") || !param.getName().startsWith("body")) {
                        mappingFile.append('.');
                        mappingFile.append(OpenApiParserImpl.jsonataString(param.getName()));
                    }
                }
                mappingFile.append("; $a != null ? $a : [])\"\n");
                location = "item";
                Parameter newParam = new Parameter();
                if (param != null) {
                    newParam.setIn(param.getIn());
                }
                this.processSchema(arraySchema.getItems(), newParam, mappingFile, location, indent);
            } else if (schema instanceof ObjectSchema) {
                int bodyLocation;
                if (param != null && param.getName() != null) {
                    mappingFile.append(indent + "- " + param.getName() + ":\n");
                    this.createParameterMapping(param, mappingFile, indent, "object");
                    if (!indent.equals("")) {
                        location = location + "." + OpenApiParserImpl.jsonataString(param.getName());
                    }
                    indent = indent + "    ";
                }
                if ((bodyLocation = mappingFile.indexOf("- requestBody") + mappingFile.indexOf("- responseCode")) > -1) {
                    void var9_23;
                    String mappingSection = "";
                    String[] mappingLines = mappingFile.substring(bodyLocation).split("\n");
                    int n = mappingLines.length - 1;
                    while (var9_23 >= 0) {
                        if (!mappingLines[var9_23].startsWith(indent)) {
                            for (void j = var9_23; j < mappingLines.length; ++j) {
                                mappingSection = mappingSection + (String)mappingLines[j];
                            }
                            break;
                        }
                        --var9_23;
                    }
                    if (mappingSection.indexOf(indent + "mappings:") == -1) {
                        mappingFile.append(indent + "mappings:\n");
                    }
                } else {
                    mappingFile.append(indent + "mappings:\n");
                }
                ObjectSchema objectSchema = (ObjectSchema)schema;
                for (Map.Entry entry : objectSchema.getProperties().entrySet()) {
                    Parameter newParam = new Parameter();
                    newParam.setName((String)entry.getKey());
                    if (param != null) {
                        newParam.setIn(param.getIn());
                    }
                    if (param != null && param.getName() != null && param.getIn() != null && (((Schema)entry.getValue()).getType().equals("object") || ((Schema)entry.getValue()).getType().equals("array"))) {
                        String reason = this.message.getMessage("NESTED_TYPE_NOT_SUPPORTED", param.getName());
                        throw new OperationProcessingException(reason);
                    }
                    this.processSchema((Schema)entry.getValue(), newParam, mappingFile, location, indent);
                }
            } else if (schema instanceof ComposedSchema) {
                ComposedSchema composedSchema = (ComposedSchema)schema;
                List schemaList = new ArrayList();
                String mappingSection = "";
                String[] stringArray = mappingFile.toString().split("\n");
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (stringArray[i].startsWith(indent) && !indent.equals("")) continue;
                    for (int j = i; j < stringArray.length; ++j) {
                        mappingSection = mappingSection + stringArray[j];
                    }
                    break;
                }
                if (mappingSection.indexOf(indent + "mappings:") == -1) {
                    mappingFile.append(indent + "mappings:\n");
                }
                if (composedSchema.getAllOf() != null) {
                    schemaList = composedSchema.getAllOf();
                } else if (composedSchema.getAnyOf() != null) {
                    schemaList = composedSchema.getAnyOf();
                } else if (composedSchema.getOneOf() != null) {
                    schemaList = composedSchema.getOneOf();
                }
                LinkedHashMap compositeSubSchemaProperties = new LinkedHashMap();
                for (Schema subSchema : schemaList) {
                    if (subSchema.getProperties() != null) {
                        compositeSubSchemaProperties.putAll(subSchema.getProperties());
                        continue;
                    }
                    this.processSchema(subSchema, param, mappingFile, location, indent);
                }
                if (!compositeSubSchemaProperties.isEmpty()) {
                    ObjectSchema objectSchema = new ObjectSchema();
                    objectSchema.setProperties(compositeSubSchemaProperties);
                    this.processSchema((Schema)objectSchema, param, mappingFile, location, indent);
                }
            } else {
                String type = schema.getType();
                String format = schema.getFormat();
                String mappingSection = "";
                String[] stringArray = mappingFile.toString().split("\n");
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!stringArray[i].startsWith(indent + "mappings:") && !stringArray[i].startsWith("- requestBody") && !stringArray[i].startsWith("- responseBody")) continue;
                    for (int j = i; j < stringArray.length; ++j) {
                        mappingSection = mappingSection + stringArray[j];
                    }
                    break;
                }
                if (param != null && mappingSection.length() > 0 && mappingSection.indexOf(indent + "- " + param.getName()) > -1) {
                    param = null;
                }
                if (param != null) {
                    if (param.getName() != null) {
                        String parameterName = OpenApiParserImpl.jsonataString(param.getName());
                        mappingFile.append(indent + "- " + param.getName() + ":\n");
                        this.createParameterMapping(param, mappingFile, indent, type);
                        if ("string".equalsIgnoreCase(type)) {
                            if (this.executionMode == ExecutionMode.PROVIDER && "'body'".equals(parameterName)) {
                                if (location.matches("^zosAssetResponse\\.channel\\.responseCode\\d\\d\\d$")) {
                                    mappingFile.append(indent + "    template: \"{{$" + location + "[0]}}\"\n");
                                } else {
                                    mappingFile.append(indent + "    template: \"{{$" + location + "}}\"\n");
                                }
                            } else {
                                mappingFile.append(indent + "    template: \"{{$" + location + "." + parameterName + "}}\"\n");
                            }
                        } else if (this.executionMode == ExecutionMode.PROVIDER && "'body'".equals(parameterName)) {
                            if (location.matches("^zosAssetResponse\\.channel\\.responseCode\\d\\d\\d$")) {
                                mappingFile.append(indent + "    expression: \"$" + location + "[0]\"\n");
                            } else {
                                mappingFile.append(indent + "    expression: \"$" + location + "\"\n");
                            }
                        } else {
                            mappingFile.append(indent + "    expression: \"$" + location + "." + parameterName + "\"\n");
                        }
                    } else {
                        indent = indent.substring(4);
                        if ("string".equalsIgnoreCase(type)) {
                            mappingFile.append(indent + "    template: \"{{$" + location + "}}\"\n");
                        } else {
                            mappingFile.append(indent + "    expression: \"$" + location + "\"\n");
                        }
                    }
                }
                if ("int32".equalsIgnoreCase(format) && "integer".equalsIgnoreCase(type)) {
                    schema.maximum(new BigDecimal(Integer.MAX_VALUE));
                    schema.minimum(new BigDecimal(Integer.MIN_VALUE));
                    schema.setFormat(null);
                } else if ("int64".equalsIgnoreCase(format) && "integer".equalsIgnoreCase(type)) {
                    schema.maximum(new BigDecimal(Long.MAX_VALUE));
                    schema.minimum(new BigDecimal(Long.MIN_VALUE));
                    schema.setFormat(null);
                }
                if ("byte".equalsIgnoreCase(format) && "string".equalsIgnoreCase(type)) {
                    schema.setFormat("base64Binary");
                }
                if ("binary".equalsIgnoreCase(format) && "string".equalsIgnoreCase(type)) {
                    schema.setFormat("hexBinary");
                }
                if ("password".equalsIgnoreCase(format) && "string".equalsIgnoreCase(type)) {
                    schema.setFormat(null);
                }
            }
            Object var20_38 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var20_38, ajc$tjp_46);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_46);
            throw throwable;
        }
    }

    private void createParameterMapping(Parameter param, StringBuffer mappingFile, String indent, String type) throws OperationProcessingException {
        Parameter parameter = param;
        StringBuffer stringBuffer = mappingFile;
        String string = indent;
        String string2 = type;
        Object[] objectArray = new Object[]{parameter, stringBuffer, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_47, joinPoint);
            if (param != null && param.getIn() != null) {
                String style = param.getIn().equals("path") || param.getIn().equals("header") ? Parameter.StyleEnum.SIMPLE.toString() : Parameter.StyleEnum.FORM.toString();
                String explode = param.getIn().equals("path") || param.getIn().equals("header") ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                String allowEmptyValue = Boolean.FALSE.toString();
                String allowReserved = Boolean.FALSE.toString();
                if (param.getStyle() != null) {
                    style = param.getStyle().toString();
                }
                if (!type.equals("array") && !type.equals("object") && (style.equals("spaceDelimited") || style.equals("pipeDelimited"))) {
                    String reason = this.message.getMessage("INCORRECT_STYLE_TYPE", param.getName(), "array|object", style);
                    throw new OperationProcessingException(reason);
                }
                if (!type.equals("object") && style.equals("deepObject")) {
                    String reason = this.message.getMessage("INCORRECT_STYLE_TYPE", param.getName(), "object", style);
                    throw new OperationProcessingException(reason);
                }
                if (param.getExplode() != null) {
                    explode = param.getExplode().toString();
                }
                if (param.getAllowEmptyValue() != null) {
                    allowEmptyValue = param.getAllowEmptyValue().toString();
                }
                if (allowEmptyValue.equals(Boolean.TRUE.toString())) {
                    this.message.printMessage(this.logPrintStream, "ALLOW_EMPTY_VALUE_NOT_SUPPORTED", new Object[0]);
                }
                if (param.getAllowReserved() != null) {
                    allowReserved = param.getAllowReserved().toString();
                }
                if (allowReserved.equals(Boolean.TRUE.toString())) {
                    this.message.printMessage(this.logPrintStream, "ALLOW_RESERVED_NOT_SUPPORTED", new Object[0]);
                }
                mappingFile.append(indent + "    type: \"" + type + "\"\n");
                if (indent.length() == 4) {
                    mappingFile.append(indent + "    style: \"" + style + "\"\n");
                    mappingFile.append(indent + "    explode: " + explode + "\n");
                    mappingFile.append(indent + "    allowEmptyValue: " + allowEmptyValue + "\n");
                    mappingFile.append(indent + "    allowReserved: " + allowReserved + "\n");
                }
            }
            Object var16_17 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var16_17, ajc$tjp_47);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_47);
            throw throwable;
        }
    }

    private Schema processHeader(Header header, StringBuffer mappingFile, String indent) throws OperationProcessingException {
        Header header2 = header;
        StringBuffer stringBuffer = mappingFile;
        String string = indent;
        Object[] objectArray = new Object[]{header2, stringBuffer, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object[])objectArray);
        try {
            Schema schema;
            Schema schema2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_48, joinPoint);
            Schema schema3 = header.getSchema();
            if (schema3 == null) {
                throw new OperationProcessingException(this.message.getMessage("MISSING_SCHEMA", "header"));
            }
            this.processSchema(schema3, null, mappingFile, "header", indent);
            Schema schema4 = schema2 = (schema = schema3);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(schema2, ajc$tjp_48);
            return schema;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_48);
            throw throwable;
        }
    }

    private void createJSONSchemaToDriveDFHJS2LS(ParsedOperationImpl parsedOperation) throws OperationProcessingException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)parsedOperationImpl);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_49, joinPoint);
            String operationId = parsedOperation.getOperationId();
            parsedOperation.setRequestJsonSchemaName(NameUtil.generateReqJsonName(operationId));
            parsedOperation.setResponseJsonSchemaName(NameUtil.generateRespJsonName(operationId));
            parsedOperation.setBindFileName(NameUtil.generateWsBindName(operationId));
            String prefix = this.getArgValue(ParserProperty.requesterPrefix);
            if (this.executionMode == ExecutionMode.PROVIDER) {
                prefix = this.getArgValue(ParserProperty.providerPrefix);
            }
            parsedOperation.setRequestDataStructureName(NameUtil.generateRequesterName(prefix, this.operationSeq, ArtifactType.Q));
            parsedOperation.setResponseDataStructureName(NameUtil.generateRequesterName(prefix, this.operationSeq, ArtifactType.P));
            parsedOperation.setApiInfoDataStructureName(NameUtil.generateRequesterName(prefix, this.operationSeq, ArtifactType.I));
            String requestJsonSchemaPath = this.getJsonSchemaFilePath(operationId, parsedOperation.getRequestJsonSchemaName());
            String responseJsonSchemaPath = this.getJsonSchemaFilePath(operationId, parsedOperation.getResponseJsonSchemaName());
            parsedOperation.setRequestJsonSchemaPath(requestJsonSchemaPath);
            parsedOperation.setResponseJsonSchemaPath(responseJsonSchemaPath);
            try {
                this.writeJsonFiles(parsedOperation);
                this.createMappingFiles(parsedOperation);
            }
            catch (IOException e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                throw new OperationProcessingException(reason, e);
            }
            this.message.printMessage(this.logPrintStream, "PARSER_ARTIFACT_OPERATION", parsedOperation.getFullOperationId());
            String logFile = null;
            try {
                String requestDataStructureName = parsedOperation.getRequestDataStructureName().substring(0, parsedOperation.getRequestDataStructureName().length() - 2);
                String responseDataStructureName = parsedOperation.getResponseDataStructureName().substring(0, parsedOperation.getResponseDataStructureName().length() - 2);
                logFile = NameUtil.generateLogFilePath(this.getJS2LSPath(operationId), parsedOperation.getOperationId(), parsedOperation.getPath(), parsedOperation.getMethod());
                String wsBindPath = this.getWsBindFilePath(operationId, parsedOperation.getBindFileName());
                HashMap<String, String> js2lsProperties = new HashMap<String, String>();
                String js2lsPath = this.getJS2LSPath(operationId);
                js2lsProperties.put("JSON-SCHEMA-REQUEST", requestJsonSchemaPath);
                js2lsProperties.put("JSON-SCHEMA-RESPONSE", responseJsonSchemaPath);
                js2lsProperties.put("REQMEM", requestDataStructureName);
                js2lsProperties.put("RESPMEM", responseDataStructureName);
                js2lsProperties.put("PDSLIB", js2lsPath);
                js2lsProperties.put("WSBIND", wsBindPath);
                js2lsProperties.put("LOGFILE", logFile);
                js2lsProperties.put("CHAR-VARYING-LIMIT", "32767");
                js2lsProperties.put("MAPPING-LEVEL", "5.0");
                js2lsProperties.put("ADDITIONAL-PROPERTIES-MAX", "20");
                js2lsProperties.put("ADDITIONAL-PROPERTIES-DEFAULT", "FALSE");
                js2lsProperties.put("ZOS-CONNECT-EE", "TRUE");
                if (this.executionMode == ExecutionMode.PROVIDER) {
                    js2lsProperties.put("CONTAINER-NAME-SUFFIX", "cont");
                }
                js2lsProperties.put("PGMNAME", "NULL");
                js2lsProperties.put("PGMINT", "CHANNEL");
                js2lsProperties.put("CONTID", "BAQBASE");
                for (Map.Entry<ParserJS2LSProperty, String> entry : this.js2lsAttributes.entrySet()) {
                    js2lsProperties.put(entry.getKey().js2lsName(), entry.getValue());
                }
                this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_START", parsedOperation.getFullOperationId(), parsedOperation.getPath(), parsedOperation.getMethod());
                IAssistantResponse response = JS2LSUtil.invokeAssistant(this.logPrintStream, js2lsProperties);
                response = this.checkNestingLevel(js2lsProperties, response);
                int returnCode = response.getReturnCode();
                if (returnCode == 4) {
                    this.parseResult.setParseStatus(ParseStatus.WARNINGS);
                } else if (returnCode > 4) {
                    this.parseResult.setParseStatus(ParseStatus.FAILURE);
                }
                File file = new File(logFile);
                parsedOperation.addResource(file);
                FileInputStream stream = new FileInputStream(file);
                parsedOperation.setTransformerLog(stream);
                if (returnCode == 0 || returnCode == 4) {
                    AbstractMap.SimpleEntry<String, InputStream> entry;
                    this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_SUCCESS", parsedOperation.getFullOperationId(), parsedOperation.getPath(), parsedOperation.getMethod());
                    if (!parsedOperation.getRequestJsonSchemaWrapper().isJSONSchemaRequired(true)) {
                        parsedOperation.setRequestDataStructureName(null);
                    }
                    if (!parsedOperation.getResponseJsonSchemaWrapper().isJSONSchemaRequired(false)) {
                        parsedOperation.setResponseDataStructureName(null);
                    }
                    String language = this.js2lsAttributes.get((Object)ParserJS2LSProperty.language);
                    String generatedCodePage = this.js2lsAttributes.get((Object)ParserJS2LSProperty.generatedCodePage);
                    String runtimeCodePage = this.js2lsAttributes.get((Object)ParserJS2LSProperty.runtimeCodePage);
                    if (runtimeCodePage != null) {
                        parsedOperation.setRuntimeCodePage(runtimeCodePage);
                    }
                    this.createApiInfoLanguageStructure(parsedOperation, language, generatedCodePage);
                    if (parsedOperation.getRequestDataStructureName() != null) {
                        file = new File(js2lsPath + "/" + parsedOperation.getRequestDataStructureName());
                        parsedOperation.addResource(file);
                        stream = new FileInputStream(file);
                        entry = new AbstractMap.SimpleEntry<String, FileInputStream>(file.getName() + this.getFileExtension(), stream);
                        parsedOperation.setRequestDataStructure(entry);
                    }
                    if (parsedOperation.getResponseDataStructureName() != null) {
                        file = new File(js2lsPath + "/" + parsedOperation.getResponseDataStructureName());
                        parsedOperation.addResource(file);
                        stream = new FileInputStream(file);
                        entry = new AbstractMap.SimpleEntry<String, FileInputStream>(file.getName() + this.getFileExtension(), stream);
                        parsedOperation.setResponseDataStructure(entry);
                    }
                    file = new File(wsBindPath);
                    parsedOperation.addResource(file);
                    stream = new FileInputStream(file);
                    entry = new AbstractMap.SimpleEntry<String, InputStream>(file.getName(), stream);
                    parsedOperation.setTransformerFile(entry);
                } else {
                    this.parseResult.getFailedOperations().put(operationId, parsedOperation);
                    String[] errorMessages = response.getErrorMessages();
                    StringBuilder errorMessage = new StringBuilder();
                    for (String msg : errorMessages) {
                        if (errorMessage.length() > 0) {
                            errorMessage.append(" ");
                        }
                        if (this.messageCanBeConverted(msg)) {
                            String message = this.convertMessage(msg);
                            errorMessage.append(message);
                            continue;
                        }
                        errorMessage.append(msg);
                    }
                    if (errorMessage.length() > 0) {
                        parsedOperation.setFailureReason(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", errorMessage.toString()));
                        this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_FAIL", parsedOperation.getFullOperationId(), parsedOperation.getPath(), parsedOperation.getMethod(), errorMessage.toString());
                    }
                }
                file = new File(requestJsonSchemaPath);
                parsedOperation.addResource(file);
                stream = new FileInputStream(file);
                AbstractMap.SimpleEntry<String, InputStream> entry = new AbstractMap.SimpleEntry<String, InputStream>(file.getName(), stream);
                parsedOperation.setRequestJsonSchema(entry);
                file = new File(responseJsonSchemaPath);
                parsedOperation.addResource(file);
                stream = new FileInputStream(file);
                entry = new AbstractMap.SimpleEntry<String, FileInputStream>(file.getName(), stream);
                parsedOperation.setResponseJsonSchema(entry);
            }
            catch (CicsAssistantException e) {
                FileInputStream stream;
                parsedOperation.setFailureReason(e.getMessage());
                File file = new File(logFile);
                parsedOperation.addResource(file);
                try {
                    stream = new FileInputStream(file);
                }
                catch (FileNotFoundException e1) {
                    String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e1.getMessage());
                    e1.printStackTrace(this.logPrintStream);
                    throw new OperationProcessingException(reason, e1);
                }
                parsedOperation.setTransformerLog(stream);
                this.parseResult.getFailedOperations().put(operationId, parsedOperation);
                this.message.printMessage(this.logPrintStream, "PARSER_OPERATION_FAIL", parsedOperation.getFullOperationId(), parsedOperation.getPath(), parsedOperation.getMethod(), e.getMessage());
                e.printStackTrace(this.logPrintStream);
                logger.error("Transforms Exception", (Object)e.getMessage());
            }
            catch (IOException e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                e.printStackTrace(this.logPrintStream);
                throw new OperationProcessingException(reason, e);
            }
            catch (Exception e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                e.printStackTrace(this.logPrintStream);
                throw new OperationProcessingException(reason, e);
            }
            Object var25_40 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var25_40, ajc$tjp_49);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_49);
            throw throwable;
        }
    }

    private void writeJsonFiles(ParsedOperationImpl parsedOperation) throws IOException, UnsupportedEncodingException, FileNotFoundException, OperationProcessingException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)parsedOperationImpl);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_50, joinPoint);
            File requestJsonFile = new File(parsedOperation.getRequestJsonSchemaPath());
            File responseJsonFile = new File(parsedOperation.getResponseJsonSchemaPath());
            File baseDir = requestJsonFile.getParentFile();
            if (!baseDir.exists()) {
                Files.createDirectories(baseDir.toPath(), new FileAttribute[0]);
            }
            if (requestJsonFile.exists()) {
                Files.delete(requestJsonFile.toPath());
            } else {
                Files.createFile(requestJsonFile.toPath(), new FileAttribute[0]);
            }
            if (responseJsonFile.exists()) {
                Files.delete(responseJsonFile.toPath());
            } else {
                Files.createFile(responseJsonFile.toPath(), new FileAttribute[0]);
            }
            try (PrintWriter requestJsonPw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(requestJsonFile, false), "UTF-8"));){
                this.requestJsonSchema = parsedOperation.getRequestJsonSchemaWrapper().toJson(this.logPrintStream, true);
                requestJsonPw.write(this.requestJsonSchema);
                requestJsonPw.flush();
            }
            catch (InvalidOpenApiDocumentException e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                throw new OperationProcessingException(reason, e);
            }
            try (PrintWriter responseJsonPw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(responseJsonFile, false), "UTF-8"));){
                this.responseJsonSchema = parsedOperation.getResponseJsonSchemaWrapper().toJson(this.logPrintStream, false);
                responseJsonPw.write(this.responseJsonSchema);
                responseJsonPw.flush();
            }
            catch (InvalidOpenApiDocumentException e) {
                String reason = this.message.getMessage("PARSER_UNEXPECTED_ERROR", e.getMessage());
                throw new OperationProcessingException(reason, e);
            }
            Object var10_16 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var10_16, ajc$tjp_50);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_50);
            throw throwable;
        }
    }

    private void createMappingFiles(ParsedOperationImpl parsedOperation) throws IOException, UnsupportedEncodingException, FileNotFoundException, OperationProcessingException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)parsedOperationImpl);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_51, joinPoint);
            File baseDir = new File(parsedOperation.getRequestJsonSchemaPath()).getParentFile();
            File requestMappingFile = new File(baseDir.getAbsolutePath() + "/request.yaml");
            File responseMappingFile = new File(baseDir.getAbsolutePath() + "/response_mapping.yaml");
            if (!baseDir.exists()) {
                Files.createDirectories(baseDir.toPath(), new FileAttribute[0]);
            }
            if (requestMappingFile.exists()) {
                Files.delete(requestMappingFile.toPath());
            } else {
                Files.createFile(requestMappingFile.toPath(), new FileAttribute[0]);
            }
            if (responseMappingFile.exists()) {
                Files.delete(responseMappingFile.toPath());
            } else {
                Files.createFile(responseMappingFile.toPath(), new FileAttribute[0]);
            }
            try (PrintWriter requestMappingPw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(requestMappingFile, false), "UTF-8"));){
                requestMappingPw.write(this.requestMapping.toString());
                requestMappingPw.flush();
            }
            parsedOperation.addResource(requestMappingFile);
            FileInputStream stream = new FileInputStream(requestMappingFile);
            AbstractMap.SimpleEntry<String, InputStream> entry = new AbstractMap.SimpleEntry<String, InputStream>(requestMappingFile.getName(), stream);
            parsedOperation.setRequestMapping(entry);
            try (PrintWriter responseMappingPw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(responseMappingFile, false), "UTF-8"));){
                responseMappingPw.write(this.responseMapping.toString());
                responseMappingPw.flush();
            }
            parsedOperation.addResource(responseMappingFile);
            stream = new FileInputStream(responseMappingFile);
            entry = new AbstractMap.SimpleEntry<String, FileInputStream>(responseMappingFile.getName(), stream);
            parsedOperation.setResponseMapping(entry);
            for (Map.Entry<String, StringBuffer> response : this.responseMappingXXX.entrySet()) {
                File responseMappingXXXFile = new File(baseDir.getAbsolutePath() + "/response_" + response.getKey() + ".yaml");
                if (responseMappingXXXFile.exists()) {
                    Files.delete(responseMappingXXXFile.toPath());
                } else {
                    Files.createFile(responseMappingXXXFile.toPath(), new FileAttribute[0]);
                }
                try (PrintWriter responseMappingXXXPw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(responseMappingXXXFile, false), "UTF-8"));){
                    responseMappingXXXPw.write(response.getValue().toString());
                    responseMappingXXXPw.flush();
                }
                parsedOperation.addResource(responseMappingXXXFile);
                stream = new FileInputStream(responseMappingXXXFile);
                entry = new AbstractMap.SimpleEntry<String, FileInputStream>(responseMappingXXXFile.getName(), stream);
                parsedOperation.addResponseMappingXXX(response.getKey(), entry);
            }
            Object var15_19 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var15_19, ajc$tjp_51);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_51);
            throw throwable;
        }
    }

    private String getJsonSchemaFilePath(String operationId, String jsonName) {
        String string = operationId;
        String string2 = jsonName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            String path;
            String string3;
            String string4;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_52, joinPoint);
            String format = "%s/services/%s/%s";
            String string5 = string4 = (string3 = (path = String.format(format, this.temporaryStore, operationId, jsonName)));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string4, ajc$tjp_52);
            return string3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_52);
            throw throwable;
        }
    }

    private String getWsBindFilePath(String operationId, String bindfileName) throws IOException {
        String string = operationId;
        String string2 = bindfileName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            String string3;
            String string4;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_53, joinPoint);
            String format = "%s/ws-binds/%s/%s";
            String path = String.format(format, this.temporaryStore, operationId, bindfileName);
            Files.createDirectories(Paths.get(path.substring(0, path.lastIndexOf("/")), new String[0]), new FileAttribute[0]);
            String string5 = string4 = (string3 = path);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string4, ajc$tjp_53);
            return string3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_53);
            throw throwable;
        }
    }

    private String getJS2LSPath(String operationId) throws IOException {
        String string = operationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_54, joinPoint);
            String format = "%s/js2ls/%s";
            String path = String.format(format, this.temporaryStore, operationId);
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            String string4 = string3 = (string2 = path);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_54);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_54);
            throw throwable;
        }
    }

    private String getFileExtension() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this);
        try {
            String string;
            String string2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_55, joinPoint);
            String extension = null;
            extension = this.executionMode == ExecutionMode.PROVIDER ? this.getArgValue(ParserProperty.providerExtension) : this.getArgValue(ParserProperty.requesterExtension);
            if (extension == null) {
                extension = "";
            } else if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            String string3 = string2 = (string = extension);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_55);
            return string;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_55);
            throw throwable;
        }
    }

    private void createApiInfoLanguageStructure(ParsedOperationImpl parsedOperation, String language, String generatedCodePage) throws IOException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        String string = language;
        String string2 = generatedCodePage;
        Object[] objectArray = new Object[]{parsedOperationImpl, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object[])objectArray);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_56, joinPoint);
            Map<String, String> replacements = this.replaceVarsInTemplate(parsedOperation);
            switch (language) {
                case "COBOL": {
                    CobolTemplate.getInstance().replaceAndCreate(parsedOperation, replacements, this.getJS2LSPath(parsedOperation.getOperationId()), parsedOperation.getApiInfoDataStructureName(), generatedCodePage);
                    break;
                }
                case "PLI-ENTERPRISE": {
                    PLITemplate.getInstance().replaceAndCreate(parsedOperation, replacements, this.getJS2LSPath(parsedOperation.getOperationId()), parsedOperation.getApiInfoDataStructureName(), generatedCodePage);
                    break;
                }
            }
            File apiInfoFile = (File)parsedOperation.getLastResource();
            FileInputStream stream = new FileInputStream(apiInfoFile);
            AbstractMap.SimpleEntry<String, InputStream> entry = new AbstractMap.SimpleEntry<String, InputStream>(apiInfoFile.getName() + this.getFileExtension(), stream);
            parsedOperation.setApiInfoDataStructure(entry);
            Object var13_14 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var13_14, ajc$tjp_56);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_56);
            throw throwable;
        }
    }

    private Map<String, String> replaceVarsInTemplate(ParsedOperationImpl parsedOperation) throws UnsupportedEncodingException {
        ParsedOperationImpl parsedOperationImpl = parsedOperation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)parsedOperationImpl);
        try {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_57, joinPoint);
            String path = parsedOperation.getPath();
            path = URLEncoder.encode(path, StandardCharsets.UTF_8.toString());
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put(TemplateVarEnum.APINAME.toString(), this.apiName);
            replacements.put(TemplateVarEnum.APINAME_LENGTH.toString(), String.valueOf(this.apiName.length()));
            replacements.put(TemplateVarEnum.APIMETHOD.toString(), parsedOperation.getMethod());
            replacements.put(TemplateVarEnum.APIMETHOD_LENGTH.toString(), String.valueOf(parsedOperation.getMethod().length()));
            replacements.put(TemplateVarEnum.APIOPERATION.toString(), parsedOperation.getOperationId());
            replacements.put(TemplateVarEnum.APIOPERATION_LENGTH.toString(), String.valueOf(parsedOperation.getOperationId().length()));
            replacements.put(TemplateVarEnum.APIPATH.toString(), path);
            replacements.put(TemplateVarEnum.APIPATH_LENGTH.toString(), String.valueOf(path.length()));
            replacements.put(TemplateVarEnum.INTERFACE_NAME.toString(), parsedOperation.getApiInfoDataStructureName());
            if (parsedOperation.getFullOperationId().equals(parsedOperation.getOperationId())) {
                replacements.put(TemplateVarEnum.FULL_OPERATION_ID.toString(), " ");
            } else {
                replacements.put(TemplateVarEnum.FULL_OPERATION_ID.toString(), "Full Operation Id: " + parsedOperation.getFullOperationId());
            }
            HashMap<String, String> hashMap3 = hashMap2 = (hashMap = replacements);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(hashMap2, ajc$tjp_57);
            return hashMap;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_57);
            throw throwable;
        }
    }

    private String convertMessage(String msg) {
        String string = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            String string4;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_58, joinPoint);
            if (msg != null) {
                for (Map.Entry<String, String> mapping : cicsErrorMessageConversions.entrySet()) {
                    if (msg.indexOf(mapping.getKey()) <= -1) continue;
                    if (msg.startsWith(noEnumConstantFound)) {
                        String type = msg.substring(noEnumConstantFound.length());
                        string3 = string4 = String.format(mapping.getValue(), type);
                    } else if (msg.startsWith(recursiveJSONPointer)) {
                        String ptr = msg.substring(msg.indexOf("\""), msg.lastIndexOf("\""));
                        string3 = string4 = String.format(mapping.getValue(), ptr);
                    } else {
                        string3 = string4 = mapping.getValue();
                    }
                    break;
                }
            } else {
                string3 = string4 = null;
            }
            String string5 = string2 = string3;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_58);
            return string4;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_58);
            throw throwable;
        }
    }

    private boolean messageCanBeConverted(String msg) {
        String string = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string);
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_59, joinPoint);
            if (msg != null) {
                for (String cicsMessageCode : cicsErrorMessageConversions.keySet()) {
                    if (msg.indexOf(cicsMessageCode) <= -1) continue;
                    bl2 = bl3 = true;
                    break;
                }
            } else {
                bl2 = bl3 = false;
            }
            boolean bl4 = bl = bl2;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(Conversions.booleanObject((boolean)bl), ajc$tjp_59);
            return bl3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_59);
            throw throwable;
        }
    }

    private IAssistantResponse checkNestingLevel(Map<String, String> cicsParams, IAssistantResponse response) throws CicsAssistantException {
        Map<String, String> map = cicsParams;
        IAssistantResponse iAssistantResponse = response;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, map, (Object)iAssistantResponse);
        try {
            IAssistantResponse iAssistantResponse2;
            IAssistantResponse iAssistantResponse3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_60, joinPoint);
            int returnCode = response.getReturnCode();
            if (returnCode == 12) {
                String[] errorMessages;
                for (String s : errorMessages = response.getErrorMessages()) {
                    if (s == null || s.indexOf(levelBeyondLimitationErrorCode) <= -1) continue;
                    cicsParams.put("SERVICE", "LEVELINC=1");
                    response = JS2LSUtil.invokeAssistant(this.logPrintStream, cicsParams);
                    break;
                }
            }
            IAssistantResponse iAssistantResponse4 = iAssistantResponse3 = (iAssistantResponse2 = response);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(iAssistantResponse3, ajc$tjp_60);
            return iAssistantResponse2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_60);
            throw throwable;
        }
    }

    private String validateCharsInPath(String relativePath) throws InvalidOpenApiDocumentException {
        String string = relativePath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_61, joinPoint);
            for (String specialChars : OpenApiParserImpl.specialChars) {
                if (!relativePath.contains(specialChars)) continue;
                InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_PATH_ERROR", relativePath, specialChars)));
                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                throw ise;
            }
            for (String specialChars : pathSpecialChars) {
                if (!relativePath.contains(specialChars)) continue;
                InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_PATH_ERROR", relativePath, specialChars)));
                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                throw ise;
            }
            if (relativePath.contains("{") && !relativePath.contains("}") || relativePath.contains("}") && !relativePath.contains("{")) {
                InvalidOpenApiDocumentException ise = new InvalidOpenApiDocumentException(this.message.getMessage("OPENAPI_DOCUMENT_IN_ERROR", this.message.getMessage("OPENAPI_DOCUMENT_PATH_TEMPLATE_ERROR", relativePath)));
                logger.error("Invalid OpenAPI Document", (Object)ise.getMessage());
                throw ise;
            }
            String string4 = string3 = (string2 = relativePath);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_61);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_61);
            throw throwable;
        }
    }

    private String validateReference(String ref, String type) throws OperationProcessingException {
        String string = ref;
        String string2 = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            String string3;
            String string4;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_62, joinPoint);
            String suffix = "";
            if (!ref.startsWith("#/components/")) {
                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_LOCAL_SUPPORT_ONLY", ref));
            }
            String refType = ref.substring("#/components/".length());
            if (refType.indexOf(47) == -1) {
                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_FORMAT_INCORRECT", ref));
            }
            if (!refType.substring(0, refType.indexOf(47)).equals(type)) {
                throw new OperationProcessingException(this.message.getMessage("PARSER_$REF_FORMAT_INCORRECT", ref));
            }
            String string5 = string4 = (string3 = (suffix = refType.substring(refType.indexOf(47) + 1)));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string4, ajc$tjp_62);
            return string3;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_62);
            throw throwable;
        }
    }

    private boolean isIgnored(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)string);
        try {
            boolean bl;
            boolean bl2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_63, joinPoint);
            boolean bl3 = bl2 = IGNORED_HEADERS.contains(name.toLowerCase()) ? (bl = true) : (bl = false);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(Conversions.booleanObject((boolean)bl2), ajc$tjp_63);
            return bl;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_63);
            throw throwable;
        }
    }

    private String getArgValue(ParserProperty arg) {
        ParserProperty parserProperty = arg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)((Object)parserProperty));
        try {
            String string;
            String string2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_64, joinPoint);
            String string3 = string2 = (string = this.localAttributes.get((Object)arg));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_64);
            return string;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_64);
            throw throwable;
        }
    }

    private String getDFHJS2LSArgValue(ParserJS2LSProperty arg) {
        ParserJS2LSProperty parserJS2LSProperty = arg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object)((Object)parserJS2LSProperty));
        try {
            String string;
            String string2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_65, joinPoint);
            String string3 = string2 = (string = this.js2lsAttributes.get((Object)arg));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_65);
            return string;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_65);
            throw throwable;
        }
    }

    private void validateProperties() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_66, joinPoint);
            this.checkExecutionMode();
            this.checkLanguage();
            this.checkPdsMemberName(this.getArgValue(ParserProperty.requesterPrefix));
            this.checkPdsMemberName(this.getArgValue(ParserProperty.providerPrefix));
            this.checkAPIKeyMaxLength();
            this.checkDefaultCharacterMaxLength();
            this.checkCharacterVarying();
            this.checkCharacterVaryingLimit();
            this.checkCharacterWhitespace();
            this.checkDataTruncation();
            this.checkDateTimeFormat();
            this.checkNameTruncation();
            this.checkWideComp3();
            this.checkDefaultFractionDigits();
            this.checkInlineMaxOccursLimit();
            this.checkAdditionalPropertiesSize();
            this.checkMultiplier();
            this.checkOperations();
            this.checkApiName();
            this.getApiKeySchemeFromProperties();
            Object var2_2 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var2_2, ajc$tjp_66);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_66);
            throw throwable;
        }
    }

    private void checkCharacterVarying() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_67, joinPoint);
            String value = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterVarying);
            if (value != null && !value.equals("")) {
                value = value.toUpperCase();
                this.js2lsAttributes.put(ParserJS2LSProperty.characterVarying, value);
                if (!(value.equals("NULL") || value.equals("NO") || value.equals(YES))) {
                    String reason = this.message.getMessage("INVALID_CHAR_VARYING_VALUE", value);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_67);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_67);
            throw throwable;
        }
    }

    private void checkCharacterVaryingLimit() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_68, joinPoint);
            String value = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterVaryingLimit);
            if (value != null && !value.equals("")) {
                int maxValue = Short.MAX_VALUE;
                String varying = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterVarying);
                if (varying != null && !varying.equals("") && !YES.equals(varying)) {
                    maxValue = 0xFFFFFE;
                }
                String reason = this.message.getMessage("INVALID_CHAR_VARYING_LIMIT", value, maxValue);
                try {
                    if (Integer.parseInt(value) < 1 || Integer.parseInt(value) > maxValue) {
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var7_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var7_7, ajc$tjp_68);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_68);
            throw throwable;
        }
    }

    private void checkPdsMemberName(String value) throws InvalidPropertyException {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object)string);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_69, joinPoint);
            Pattern pdsNamePattern = Pattern.compile("^[A-Za-z#@$][A-Za-z0-9#@$]*");
            if (value != null && !value.equals("")) {
                if (value.length() > 3) {
                    String reason = this.message.getMessage("VALUE_EXCEED_MAX_LENGTH_PROPERTY", value, 3);
                    throw new InvalidPropertyException(reason);
                }
                Matcher pdsnameMatcher = pdsNamePattern.matcher(value);
                if (!pdsnameMatcher.matches()) {
                    String reason = this.message.getMessage("INVALID_PDS_MEMBER_NAME_PROPERTY", value);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var7_8 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var7_8, ajc$tjp_69);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_69);
            throw throwable;
        }
    }

    private void checkAPIKeyMaxLength() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_70, joinPoint);
            String apiKeyMaxLength = this.getArgValue(ParserProperty.apiKeyMaxLength);
            if (apiKeyMaxLength != null) {
                String reason = this.message.getMessage("INVALID_APIKEY_PROPERTY_MAXLEN", apiKeyMaxLength);
                try {
                    if (Integer.parseInt(apiKeyMaxLength) < 1 || Integer.parseInt(apiKeyMaxLength) > Short.MAX_VALUE) {
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var5_5 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var5_5, ajc$tjp_70);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_70);
            throw throwable;
        }
    }

    private void checkDefaultCharacterMaxLength() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_71, joinPoint);
            String defaultCharacterMaxLength = this.getDFHJS2LSArgValue(ParserJS2LSProperty.defaultCharacterMaxLength);
            if (defaultCharacterMaxLength != null) {
                String charVarying = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterVarying);
                int maxLength = 0xFFFFFE;
                if (charVarying != null && !charVarying.equals("") && YES.equalsIgnoreCase(charVarying)) {
                    maxLength = Short.MAX_VALUE;
                }
                String reason = this.message.getMessage("INVALID_DEFAULTCHARACTER_MAXLEN", defaultCharacterMaxLength, maxLength);
                try {
                    if (Integer.parseInt(defaultCharacterMaxLength) < 1 || Integer.parseInt(defaultCharacterMaxLength) > maxLength) {
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var7_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var7_7, ajc$tjp_71);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_71);
            throw throwable;
        }
    }

    private void checkDefaultFractionDigits() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_72, joinPoint);
            String defaultFractionDigits = this.getDFHJS2LSArgValue(ParserJS2LSProperty.defaultFractionDigits);
            if (defaultFractionDigits != null) {
                String wideComp3 = this.getDFHJS2LSArgValue(ParserJS2LSProperty.wideComp3);
                int maxLength = 17;
                if (wideComp3 != null && !wideComp3.equals("") && YES.equalsIgnoreCase(wideComp3)) {
                    maxLength = 30;
                }
                String reason = this.message.getMessage("INVALID_DEFAULT_FRACTION_DIGITS", defaultFractionDigits, maxLength);
                try {
                    if (Integer.parseInt(defaultFractionDigits) < 0 || Integer.parseInt(defaultFractionDigits) > maxLength) {
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var7_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var7_7, ajc$tjp_72);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_72);
            throw throwable;
        }
    }

    private void checkLanguage() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_73, joinPoint);
            String language = this.js2lsAttributes.get((Object)ParserJS2LSProperty.language);
            if (language == null || !SUPPORTED_LANG.contains(language.toUpperCase())) {
                String reason = this.message.getMessage("NOT_SUPPORTED_LANGUAGE", language, SUPPORTED_LANG);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_73);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_73);
            throw throwable;
        }
    }

    private void checkCharacterWhitespace() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_74, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterWhiteSpace);
            if (!(type == null || type.toUpperCase().equals("COLLAPSE") || type.toUpperCase().equals("REPLACE") || type.toUpperCase().equals("PRESERVE"))) {
                String reason = this.message.getMessage("INVALID_CHARACTER_WHITESPACE", type);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_74);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_74);
            throw throwable;
        }
    }

    private void checkDataTruncation() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_75, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.dataTruncation);
            if (type != null && !type.toUpperCase().equals("DISABLED") && !type.toUpperCase().equals("ENABLED")) {
                String reason = this.message.getMessage("INVALID_DATA_TRUNCATION", type);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_75);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_75);
            throw throwable;
        }
    }

    private void checkDateTimeFormat() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_76, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.dateTimeFormat);
            if (type != null && !type.toUpperCase().equals("PACKED15") && !type.toUpperCase().equals("STRING")) {
                String reason = this.message.getMessage("INVALID_DATE_TIME_FORMAT", type);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_76);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_76);
            throw throwable;
        }
    }

    private void checkNameTruncation() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_77, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.nameTruncation);
            if (type != null && !type.toUpperCase().equals("LEFT") && !type.toUpperCase().equals("RIGHT")) {
                String reason = this.message.getMessage("INVALID_NAME_TRUNCATION", type);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_77);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_77);
            throw throwable;
        }
    }

    private void checkWideComp3() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_78, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.wideComp3);
            if (type != null && !type.toUpperCase().equals("NO") && !type.toUpperCase().equals(YES)) {
                String reason = this.message.getMessage("INVALID_WIDE_COMP3", type);
                throw new InvalidPropertyException(reason);
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_78);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_78);
            throw throwable;
        }
    }

    private void checkMultiplier() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_79, joinPoint);
            String multiplier = this.getDFHJS2LSArgValue(ParserJS2LSProperty.characterMultiplier);
            if (multiplier != null) {
                try {
                    Integer.valueOf(multiplier);
                }
                catch (NumberFormatException e) {
                    String reason = this.message.getMessage("INVALID_CHARACTER_MULTIPLIER", multiplier);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var5_5 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var5_5, ajc$tjp_79);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_79);
            throw throwable;
        }
    }

    private void checkInlineMaxOccursLimit() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_80, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.inlineMaxOccursLimit);
            if (type != null) {
                try {
                    Integer max = Integer.valueOf(type);
                    if (max < 1 || max > Short.MAX_VALUE) {
                        String reason = this.message.getMessage("INVALID_INLINE_MAX_OCCURS_LIMIT", type);
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    String reason = this.message.getMessage("INVALID_INLINE_MAX_OCCURS_LIMIT", type);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var5_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var5_7, ajc$tjp_80);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_80);
            throw throwable;
        }
    }

    private void checkAdditionalPropertiesSize() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_81, joinPoint);
            String type = this.getDFHJS2LSArgValue(ParserJS2LSProperty.additionalPropertiesSize);
            if (type != null) {
                try {
                    Integer max = Integer.valueOf(type);
                    if (max < 16 || max > Short.MAX_VALUE) {
                        String reason = this.message.getMessage("INVALID_ADDITIONAL_PROPERTIES_SIZE", type);
                        throw new InvalidPropertyException(reason);
                    }
                }
                catch (NumberFormatException e) {
                    String reason = this.message.getMessage("INVALID_ADDITIONAL_PROPERTIES_SIZE", type);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var5_7 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var5_7, ajc$tjp_81);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_81);
            throw throwable;
        }
    }

    private void checkOperations() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_82, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_82, joinPoint);
            String operations = this.getArgValue(ParserProperty.operations);
            if (operations != null) {
                if (!operations.equals("")) {
                    if (this.executionMode == ExecutionMode.PROVIDER) {
                        this.localAttributes.put(ParserProperty.operations, null);
                        this.requiredOperations = null;
                    } else {
                        this.requiredOperations = operations.replace(",", " ").replace("  ", " ").split(" ");
                        if (this.requiredOperations.length == 0) {
                            String reason = this.message.getMessage("INVALID_OPERATIONS", operations);
                            throw new InvalidPropertyException(reason);
                        }
                        this.message.printMessage(this.logPrintStream, "PROCESSING_OPERATIONS", operations);
                    }
                } else {
                    String reason = this.message.getMessage("INVALID_OPERATIONS", operations);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var4_5 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_5, ajc$tjp_82);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_82);
            throw throwable;
        }
    }

    private void checkExecutionMode() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_83, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_83, joinPoint);
            String mode = this.getArgValue(ParserProperty.executionMode);
            if (mode != null && !mode.equals("")) {
                if (mode.equalsIgnoreCase(ExecutionMode.REQUESTER.name())) {
                    this.executionMode = ExecutionMode.REQUESTER;
                } else if (mode.equalsIgnoreCase(ExecutionMode.PROVIDER.name())) {
                    this.executionMode = ExecutionMode.PROVIDER;
                    this.checkOperations();
                } else {
                    String reason = this.message.getMessage("INVALID_EXECUTION_MODE", new Object[]{this.executionMode});
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var4_4 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_83);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_83);
            throw throwable;
        }
    }

    private void checkApiName() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_84, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_84, joinPoint);
            String apiName = this.getArgValue(ParserProperty.apiName);
            if (this.executionMode == ExecutionMode.REQUESTER) {
                if (apiName == null || apiName.equals("")) {
                    String reason = this.message.getMessage("MISSING_API_NAME", new Object[0]);
                    throw new InvalidPropertyException(reason);
                }
                if (apiName.length() > 240) {
                    String reason = this.message.getMessage("INVALID_API_NAME", apiName);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var4_5 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_5, ajc$tjp_84);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_84);
            throw throwable;
        }
    }

    private void checkRequestMediaType(String parameter, String mediaTypeParameter) throws InvalidPropertyException {
        String string = parameter;
        String string2 = mediaTypeParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_85, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_85, joinPoint);
            try {
                String[] operations;
                for (String operation : operations = mediaTypeParameter.split("\\s*,\\s*")) {
                    String operationId = operation.substring(0, operation.indexOf(40)).trim();
                    String mediaType = operation.substring(operation.indexOf(40) + 1);
                    String bracket = mediaType.substring(mediaType.indexOf(41)).trim();
                    if (bracket.length() != 1) {
                        String reason = this.message.getMessage("INVALID_REQUEST_MEDIA_TYPE_PARAMETER", parameter, mediaTypeParameter);
                        throw new InvalidPropertyException(reason);
                    }
                    mediaType = mediaType.substring(0, mediaType.indexOf(41)).trim();
                    this.operationMediaType.put(parameter + "/" + operationId, mediaType);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                String reason = this.message.getMessage("INVALID_REQUEST_MEDIA_TYPE_PARAMETER", parameter, mediaTypeParameter);
                throw new InvalidPropertyException(reason);
            }
            Object var15_17 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var15_17, ajc$tjp_85);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_85);
            throw throwable;
        }
    }

    private void checkResponseMediaType(String parameter, String mediaTypeParameter) throws InvalidPropertyException {
        String string = parameter;
        String string2 = mediaTypeParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_86, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_86, joinPoint);
            try {
                String[] operations;
                for (String operation : operations = mediaTypeParameter.split("\\s*,\\s*")) {
                    String operationId = operation.substring(0, operation.indexOf(47)).trim();
                    String statusCode = operation.substring(operation.indexOf(47) + 1, operation.indexOf(40));
                    if (!statusCode.matches("^([1-5][0-9][0-9]|[1-5][0-9]X|[1-5]XX|default)")) {
                        String reason = this.message.getMessage("INVALID_RESPONSE_MEDIA_TYPE_PARAMETER", parameter, mediaTypeParameter);
                        throw new InvalidPropertyException(reason);
                    }
                    String mediaType = operation.substring(operation.indexOf(40) + 1);
                    String bracket = mediaType.substring(mediaType.indexOf(41)).trim();
                    if (bracket.length() != 1) {
                        String reason = this.message.getMessage("INVALID_RESPONSE_MEDIA_TYPE_PARAMETER", parameter, mediaTypeParameter);
                        throw new InvalidPropertyException(reason);
                    }
                    mediaType = mediaType.substring(0, mediaType.indexOf(41)).trim();
                    this.operationMediaType.put(parameter + "/" + operationId + "/" + statusCode, mediaType);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                String reason = this.message.getMessage("INVALID_RESPONSE_MEDIA_TYPE_PARAMETER", parameter, mediaTypeParameter);
                throw new InvalidPropertyException(reason);
            }
            Object var16_18 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var16_18, ajc$tjp_86);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_86);
            throw throwable;
        }
    }

    private void getApiKeySchemeFromProperties() throws InvalidPropertyException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_87, (Object)this, (Object)this);
        try {
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_87, joinPoint);
            boolean set = false;
            if (this.getArgValue(ParserProperty.apiKeyParmNameInHeader) != null) {
                this.apiKeyDefinitionFromProperties.putAll(this.getSecuritySchemeProperties(ParserProperty.apiKeyParmNameInHeader.name(), this.getArgValue(ParserProperty.apiKeyParmNameInHeader)));
                set = true;
            }
            if (this.getArgValue(ParserProperty.apiKeyParmNameInQuery) != null) {
                this.apiKeyDefinitionFromProperties.putAll(this.getSecuritySchemeProperties(ParserProperty.apiKeyParmNameInQuery.name(), this.getArgValue(ParserProperty.apiKeyParmNameInQuery)));
                if (set) {
                    String reason = this.message.getMessage("MULTIPLE_APIKEY_PROPERTIES", new Object[0]);
                    throw new InvalidPropertyException(reason);
                }
                set = true;
            }
            if (this.getArgValue(ParserProperty.apiKeyParmNameInCookie) != null) {
                this.apiKeyDefinitionFromProperties.putAll(this.getSecuritySchemeProperties(ParserProperty.apiKeyParmNameInCookie.name(), this.getArgValue(ParserProperty.apiKeyParmNameInCookie)));
                if (set) {
                    String reason = this.message.getMessage("MULTIPLE_APIKEY_PROPERTIES", new Object[0]);
                    throw new InvalidPropertyException(reason);
                }
            }
            Object var4_5 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_5, ajc$tjp_87);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_87);
            throw throwable;
        }
    }

    private Map<String, SecurityScheme> getSecuritySchemeProperties(String apikeyName, String apikeyNamesDef) {
        String string = apikeyName;
        String string2 = apikeyNamesDef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_88, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            HashMap<String, SecurityScheme> hashMap;
            HashMap<String, SecurityScheme> hashMap2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_88, joinPoint);
            String apiKeyLocation = apikeyName.substring(apikeyName.indexOf(73) + 2);
            String[] names = apikeyNamesDef.split(",");
            this.apiKeyNameProperty = apikeyName;
            HashMap<String, SecurityScheme> apiKeyDefinitionFromProperties = new HashMap<String, SecurityScheme>();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i].trim();
                SecurityScheme securityScheme = new SecurityScheme();
                securityScheme.setName(name);
                if (apiKeyLocation.equals("Header")) {
                    securityScheme.setIn(SecurityScheme.In.HEADER);
                    apiKeyDefinitionFromProperties.put("header." + name, securityScheme);
                    continue;
                }
                if (apiKeyLocation.equals("Query")) {
                    securityScheme.setIn(SecurityScheme.In.QUERY);
                    apiKeyDefinitionFromProperties.put("query." + name, securityScheme);
                    continue;
                }
                if (!apiKeyLocation.equals("Cookie")) continue;
                securityScheme.setIn(SecurityScheme.In.COOKIE);
                apiKeyDefinitionFromProperties.put("cookie." + name, securityScheme);
            }
            HashMap<String, SecurityScheme> hashMap3 = hashMap2 = (hashMap = apiKeyDefinitionFromProperties);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(hashMap2, ajc$tjp_88);
            return hashMap;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_88);
            throw throwable;
        }
    }

    private void constructParseSummaryReport() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_89, (Object)this, (Object)this);
        try {
            ParsedOperation op;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_89, joinPoint);
            int successNum = this.parseResult.getParsedOperations().size();
            int ignoredNum = this.parseResult.getFailedOperations().size();
            int totalNum = successNum + ignoredNum;
            this.logPrintStream.print(System.lineSeparator());
            this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_A", totalNum, successNum, ignoredNum, this.parseResult.getApiName());
            this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_B", new Object[0]);
            for (Map.Entry<String, ParsedOperation> entry : this.parseResult.getParsedOperations().entrySet()) {
                op = entry.getValue();
                this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_C", op.getFullOperationId(), op.getPath(), op.getMethod());
                String reqDataStructure = op.getRequestDataStructure() == null ? this.message.getMessage("PARSE_SUMMARY_REPORT_H", new Object[0]) : op.getRequestDataStructure().getKey();
                String respDataStructure = op.getResponseDataStructure() == null ? this.message.getMessage("PARSE_SUMMARY_REPORT_H", new Object[0]) : op.getResponseDataStructure().getKey();
                this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_D", reqDataStructure);
                this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_E", respDataStructure);
                this.logPrintStream.print(System.lineSeparator());
            }
            if (ignoredNum != 0) {
                this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_F", new Object[0]);
                for (Map.Entry<String, ParsedOperation> entry : this.parseResult.getParsedOperations().entrySet()) {
                    op = entry.getValue();
                    this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_C", op.getFullOperationId(), op.getPath(), op.getMethod());
                    this.message.printMessage(this.logPrintStream, "PARSE_SUMMARY_REPORT_G", op.getFailureReason());
                }
            }
            Object var10_10 = null;
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var10_10, ajc$tjp_89);
            return;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_89);
            throw throwable;
        }
    }

    @Override
    public Set<String> getSupportedArgs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_90, (Object)this, (Object)this);
        try {
            Set<String> set;
            Set<String> set2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_90, joinPoint);
            Set<String> set3 = set2 = (set = SUPPORTED_ARGS);
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(set2, ajc$tjp_90);
            return set;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_90);
            throw throwable;
        }
    }

    static {
        OpenApiParserImpl.ajc$preClinit();
        logger = LoggerFactory.getLogger(OpenApiParserImpl.class);
        quotes = Pattern.compile("'");
        backslash = Pattern.compile("\\\\");
        SUPPORTED_ARGS = new HashSet<String>();
        NOT_NULL_ARGS = new HashSet<String>();
        SUPPORTED_LANG = new HashSet<String>();
        IGNORED_HEADERS = new HashSet<String>();
        SUPPORTED_SIMPLE_TYPES = new HashSet<String>();
        HTTP_SUPPORTED_METHODS = new ArrayList<String>();
        specialChars = new HashSet<String>();
        pathSpecialChars = new HashSet<String>();
        cicsErrorMessageConversions = new HashMap();
        SUPPORTED_ARGS.addAll(ParserProperty.names());
        SUPPORTED_ARGS.addAll(ParserJS2LSProperty.names());
        NOT_NULL_ARGS.add(ParserJS2LSProperty.language.name());
        SUPPORTED_LANG.add("COBOL");
        SUPPORTED_LANG.add("PLI-ENTERPRISE");
        IGNORED_HEADERS.add("authorization");
        IGNORED_HEADERS.add("accept");
        IGNORED_HEADERS.add("content-type");
        SUPPORTED_SIMPLE_TYPES.add("string");
        SUPPORTED_SIMPLE_TYPES.add("number");
        SUPPORTED_SIMPLE_TYPES.add("integer");
        SUPPORTED_SIMPLE_TYPES.add("boolean");
        SUPPORTED_SIMPLE_TYPES.add("array");
        SUPPORTED_SIMPLE_TYPES.add("object");
        pathSpecialChars.add("*");
        pathSpecialChars.add("$");
        pathSpecialChars.add("+");
        pathSpecialChars.add("(");
        pathSpecialChars.add(")");
        pathSpecialChars.add("{}");
        specialChars.add("#");
        specialChars.add("|");
        specialChars.add("\\");
        specialChars.add("^");
        specialChars.add("[");
        specialChars.add("]");
        specialChars.add("~");
        specialChars.add("`");
        specialChars.add("<");
        specialChars.add(">");
        specialChars.add("\"");
        specialChars.add("?");
        HTTP_SUPPORTED_METHODS.add("GET");
        HTTP_SUPPORTED_METHODS.add("POST");
        HTTP_SUPPORTED_METHODS.add("PUT");
        HTTP_SUPPORTED_METHODS.add("DELETE");
        HTTP_SUPPORTED_METHODS.add("OPTIONS");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OpenApiParserImpl.java", OpenApiParserImpl.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.OperationProcessingException"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProperties", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.util.Map", "properties", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 266);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterVaryingLimit", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "varyingLimit", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 379);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataTruncation", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "truncationType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 385);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDateTimeFormat", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "dateTimeFormat", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 391);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultCharacterMaxLength", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "maxLength", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 397);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultFractionDigits", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "maxLength", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 403);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNameTruncation", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "truncationType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 409);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setGeneratedCodePage", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "codepage", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 415);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWideComp3", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "wideComp3", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 420);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInlineMaxOccursLimit", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "arrayMaxItems", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 426);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAdditionalPropertiesSize", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "additionalPropertiesSize", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 432);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLanguage", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "language", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 323);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiKeyParmNameInHeader", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "apiKeyParmNameInHeader", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 438);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiKeyParmNameInQuery", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "apiKeyParmNameInQuery", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 444);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiKeyParmNameInCookie", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "apiKeyParmNameInCookie", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 450);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiKeyMaxLength", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "apiKeyMaxLength", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 456);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOperations", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "operations", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 462);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExecutionMode", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "mode", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 468);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiName", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "apiName", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 474);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequestMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "mediaType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 480);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultRequestMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "mediaType", "", "void"), 486);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setResponseMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "mediaType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 491);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserLocale", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "language:country", "", "void"), 334);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultResponseMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "mediaType", "", "void"), 497);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequesterExtension", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "extension", "", "void"), 502);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProviderExtension", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "extension", "", "void"), 507);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "parse", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.nio.file.Path", "document", "com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException:com.ibm.zosconnect.openapi.parser.DuplicateParseAttemptException:com.ibm.zosconnect.openapi.parser.InvalidPropertyException:com.ibm.zosconnect.openapi.parser.OperationProcessingException", "com.ibm.zosconnect.openapi.parser.ParseResult"), 519);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setupParser", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "java.io.IOException", "void"), 550);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processDocument", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.nio.file.Path", "document", "com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException:java.io.IOException:javax.xml.bind.JAXBException", "com.ibm.zosconnect.openapi.parser.internal.ParseResultImpl"), 593);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseOpenAPIDocument", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.nio.file.Path", "document", "com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException:java.io.IOException", "void"), 888);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processParameters", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl:io.swagger.v3.oas.models.PathItem:io.swagger.v3.oas.models.Operation:java.util.List", "parsedOperation:pathItem:operation:globalSecurityRequirements", "com.ibm.zosconnect.openapi.parser.OperationProcessingException:com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 982);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processApiKeyMappings", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.security.SecurityScheme", "securityScheme", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "io.swagger.v3.oas.models.parameters.Parameter"), 1194);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkParameter", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.parameters.Parameter", "parameter", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "io.swagger.v3.oas.models.media.Schema"), 1235);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRuntimeCodePage", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "codepage", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 344);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processRequestBody", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl:io.swagger.v3.oas.models.parameters.RequestBody", "parsedOperation:requestBody", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 1305);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "jsonataString", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "s", "", "java.lang.String"), 1421);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processResponses", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl:io.swagger.v3.oas.models.responses.ApiResponses:io.swagger.v3.oas.models.Operation:java.lang.String:java.lang.String", "parsedOperation:apiResponses:operation:relativePath:method", "com.ibm.zosconnect.openapi.parser.OperationProcessingException:com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException", "void"), 1447);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "resolveSchema", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.media.Schema:com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "schema:parent", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "io.swagger.v3.oas.models.media.Schema"), 1787);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkForRefLoop", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "node", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 1861);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processParameter", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:io.swagger.v3.oas.models.parameters.Parameter:java.lang.String", "inType:param:indent", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "io.swagger.v3.oas.models.media.Schema"), 1889);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processSchema", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.media.Schema:io.swagger.v3.oas.models.parameters.Parameter:java.lang.StringBuffer:java.lang.String:java.lang.String", "schema:param:mappingFile:location:indent", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 1918);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createParameterMapping", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.parameters.Parameter:java.lang.StringBuffer:java.lang.String:java.lang.String", "param:mappingFile:indent:type", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 2249);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processHeader", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.headers.Header:java.lang.StringBuffer:java.lang.String", "header:mappingFile:indent", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "io.swagger.v3.oas.models.media.Schema"), 2321);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createJSONSchemaToDriveDFHJS2LS", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl", "parsedOperation", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 2349);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequesterPrefix", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "prefix", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 349);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "writeJsonFiles", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl", "parsedOperation", "java.io.IOException:java.io.UnsupportedEncodingException:java.io.FileNotFoundException:com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 2592);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createMappingFiles", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl", "parsedOperation", "java.io.IOException:java.io.UnsupportedEncodingException:java.io.FileNotFoundException:com.ibm.zosconnect.openapi.parser.OperationProcessingException", "void"), 2655);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getJsonSchemaFilePath", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "operationId:jsonName", "", "java.lang.String"), 2741);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWsBindFilePath", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "operationId:bindfileName", "java.io.IOException", "java.lang.String"), 2753);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getJS2LSPath", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "operationId", "java.io.IOException", "java.lang.String"), 2766);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFileExtension", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "", "java.lang.String"), 2778);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createApiInfoLanguageStructure", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl:java.lang.String:java.lang.String", "parsedOperation:language:generatedCodePage", "java.io.IOException", "void"), 2804);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "replaceVarsInTemplate", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParsedOperationImpl", "parsedOperation", "java.io.UnsupportedEncodingException", "java.util.Map"), 2836);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertMessage", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "msg", "", "java.lang.String"), 2872);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "messageCanBeConverted", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "msg", "", "boolean"), 2908);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProviderPrefix", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "prefix", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 355);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkNestingLevel", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.util.Map:com.ibm.cics.gen.api.IAssistantResponse", "cicsParams:response", "com.ibm.zosconnect.openapi.parser.internal.CicsAssistantException", "com.ibm.cics.gen.api.IAssistantResponse"), 2928);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateCharsInPath", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "relativePath", "com.ibm.zosconnect.openapi.parser.InvalidOpenApiDocumentException", "java.lang.String"), 2949);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateReference", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "ref:type", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "java.lang.String"), 2989);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isIgnored", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "name", "", "boolean"), 3014);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getArgValue", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParserProperty", "arg", "", "java.lang.String"), 3026);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDFHJS2LSArgValue", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "com.ibm.zosconnect.openapi.parser.internal.ParserJS2LSProperty", "arg", "", "java.lang.String"), 3035);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateProperties", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3047);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkCharacterVarying", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3076);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkCharacterVaryingLimit", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3093);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPdsMemberName", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "value", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3125);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterMultiplier", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "multiplier", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 361);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkAPIKeyMaxLength", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3147);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDefaultCharacterMaxLength", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3168);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDefaultFractionDigits", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3203);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkLanguage", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3237);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkCharacterWhitespace", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3250);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDataTruncation", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3266);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDateTimeFormat", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3281);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkNameTruncation", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3296);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkWideComp3", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3311);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkMultiplier", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3326);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterWhiteSpace", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "handlingType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 367);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkInlineMaxOccursLimit", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3344);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkAdditionalPropertiesSize", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3365);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkOperations", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3386);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkExecutionMode", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3419);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkApiName", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3442);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkRequestMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "parameter:mediaTypeParameter", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3471);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkResponseMediaType", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "parameter:mediaTypeParameter", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3509);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiKeySchemeFromProperties", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 3550);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSecuritySchemeProperties", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "apikeyName:apikeyNamesDef", "", "java.util.Map"), 3587);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "constructParseSummaryReport", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "", "void"), 3617);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharacterVarying", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String", "varyingType", "com.ibm.zosconnect.openapi.parser.InvalidPropertyException", "void"), 373);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSupportedArgs", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "", "", "", "java.util.Set"), 3658);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$processResponses$1", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "io.swagger.v3.oas.models.responses.ApiResponse:io.swagger.v3.oas.models.responses.ApiResponse", "e1:e2", "", "io.swagger.v3.oas.models.responses.ApiResponse"), 1466);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$processDocument$0", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl", "java.lang.String:java.lang.String", "method:m", "", "boolean"), 669);
    }

    private static class RefNode {
        private String reference;
        private RefNode parent;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

        private RefNode() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
        }

        public RefNode getParent() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            try {
                RefNode refNode;
                RefNode refNode2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
                RefNode refNode3 = refNode2 = (refNode = this.parent);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(refNode2, ajc$tjp_1);
                return refNode;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        public void setParent(RefNode parent) {
            RefNode refNode = parent;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)refNode);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
                this.parent = parent;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        public String getReference() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            try {
                String string;
                String string2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_3, joinPoint);
                String string3 = string2 = (string = this.reference);
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string2, ajc$tjp_3);
                return string;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_3);
                throw throwable;
            }
        }

        public void setReference(String reference) {
            String string = reference;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
            try {
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_4, joinPoint);
                this.reference = reference;
                Object var4_4 = null;
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(var4_4, ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_4);
                throw throwable;
            }
        }

        static {
            RefNode.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("OpenApiParserImpl.java", RefNode.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "", "", ""), 3714);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParent", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "", "", "", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode"), 3719);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setParent", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "parent", "", "void"), 3723);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReference", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "", "", "", "java.lang.String"), 3727);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReference", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "java.lang.String", "reference", "", "void"), 3731);
            ajc$tjp_5 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1000", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$RefNode", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$1", "x0", ""), 3714);
        }
    }

    static final class ExecutionMode
    extends Enum<ExecutionMode> {
        public static final /* enum */ ExecutionMode REQUESTER;
        public static final /* enum */ ExecutionMode PROVIDER;
        private static final /* synthetic */ ExecutionMode[] $VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public static ExecutionMode[] values() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            try {
                ExecutionMode[] executionModeArray;
                ExecutionMode[] executionModeArray2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
                ExecutionMode[] executionModeArray3 = executionModeArray2 = (executionModeArray = (ExecutionMode[])$VALUES.clone());
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(executionModeArray2, ajc$tjp_0);
                return executionModeArray;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        public static ExecutionMode valueOf(String name) {
            String string = name;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
            try {
                ExecutionMode executionMode;
                ExecutionMode executionMode2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
                ExecutionMode executionMode3 = executionMode2 = (executionMode = Enum.valueOf(ExecutionMode.class, name));
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34((Object)executionMode2, ajc$tjp_1);
                return executionMode;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        private ExecutionMode() {
            String string2 = string;
            int n2 = n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string2, (Object)Conversions.intObject((int)n2));
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
        }

        static {
            ExecutionMode.ajc$preClinit();
            REQUESTER = new ExecutionMode();
            PROVIDER = new ExecutionMode();
            $VALUES = new ExecutionMode[]{REQUESTER, PROVIDER};
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("OpenApiParserImpl.java", ExecutionMode.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$ExecutionMode", "", "", "", "[Lcom.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$ExecutionMode;"), 240);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$ExecutionMode", "java.lang.String", "name", "", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$ExecutionMode"), 240);
            ajc$tjp_2 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$ExecutionMode", "java.lang.String:int", "arg0:arg1", ""), 240);
        }
    }

    static final class OASVersion
    extends Enum<OASVersion> {
        public static final /* enum */ OASVersion THREEZERO;
        public static final /* enum */ OASVersion THREEONE;
        private static final /* synthetic */ OASVersion[] $VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public static OASVersion[] values() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            try {
                OASVersion[] oASVersionArray;
                OASVersion[] oASVersionArray2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
                OASVersion[] oASVersionArray3 = oASVersionArray2 = (oASVersionArray = (OASVersion[])$VALUES.clone());
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(oASVersionArray2, ajc$tjp_0);
                return oASVersionArray;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        public static OASVersion valueOf(String name) {
            String string = name;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
            try {
                OASVersion oASVersion;
                OASVersion oASVersion2;
                TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
                OASVersion oASVersion3 = oASVersion2 = (oASVersion = Enum.valueOf(OASVersion.class, name));
                TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34((Object)oASVersion2, ajc$tjp_1);
                return oASVersion;
            }
            catch (Throwable throwable) {
                TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        private OASVersion() {
            String string2 = string;
            int n2 = n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string2, (Object)Conversions.intObject((int)n2));
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
        }

        static {
            OASVersion.ajc$preClinit();
            THREEZERO = new OASVersion();
            THREEONE = new OASVersion();
            $VALUES = new OASVersion[]{THREEZERO, THREEONE};
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("OpenApiParserImpl.java", OASVersion.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion", "", "", "", "[Lcom.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion;"), 230);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion", "java.lang.String", "name", "", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion"), 230);
            ajc$tjp_2 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "com.ibm.zosconnect.openapi.parser.internal.OpenApiParserImpl$OASVersion", "java.lang.String:int", "arg0:arg1", ""), 230);
        }
    }
}

