/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.openapi.parser.internal.util;

import com.ibm.zosconnect.openapi.parser.OperationProcessingException;
import com.ibm.zosconnect.openapi.parser.TracingAspect;
import com.ibm.zosconnect.openapi.parser.internal.ArtifactType;
import java.util.AbstractMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class NameUtil {
    static final String copyright_notice = "\nIBM Confidential. PID 5655-CE5. Copyright IBM Corp. 2021\n";
    private static final int OPERATION_LENGTH = 2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public NameUtil() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_0, joinPoint);
    }

    public static Map.Entry<String, String> generateOperationName(String operationId, String relativePath, String httpMethod, int serviceSeq) {
        String string = operationId;
        String string2 = relativePath;
        String string3 = httpMethod;
        int n = serviceSeq;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object[])objectArray);
        try {
            AbstractMap.SimpleEntry<String, String> simpleEntry;
            AbstractMap.SimpleEntry<String, String> simpleEntry2;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_1, joinPoint);
            String seqHexString = Integer.toHexString(serviceSeq);
            String fullOperation = null;
            if (operationId != null && !operationId.equals("")) {
                fullOperation = operationId;
            } else {
                String nameFormat = "%s_%s";
                relativePath = NameUtil.convertPathToName(relativePath);
                fullOperation = String.format(nameFormat, relativePath, httpMethod);
            }
            String suffix = "_" + seqHexString;
            String mangledOperationId = fullOperation;
            if (fullOperation.length() > 32) {
                mangledOperationId = fullOperation.substring(0, 32 - suffix.length()) + suffix;
            }
            AbstractMap.SimpleEntry<String, String> simpleEntry3 = simpleEntry2 = (simpleEntry = new AbstractMap.SimpleEntry<String, String>(mangledOperationId, fullOperation));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(simpleEntry2, ajc$tjp_1);
            return simpleEntry;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public static String generateWsBindName(String operationName) {
        String string = operationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
        try {
            String name;
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_2, joinPoint);
            String nameFormat = "%s.%s";
            String string4 = string3 = (string2 = (name = String.format(nameFormat, operationName, "wsbind")));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_2);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public static String generateReqJsonName(String operationName) {
        String string = operationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string);
        try {
            String name;
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_3, joinPoint);
            String nameFormat = "%s_%s.%s";
            String string4 = string3 = (string2 = (name = String.format(nameFormat, operationName, "request", "json")));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_3);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public static String generateRespJsonName(String operationName) {
        String string = operationName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string);
        try {
            String name;
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_4, joinPoint);
            String nameFormat = "%s_%s.%s";
            String string4 = string3 = (string2 = (name = String.format(nameFormat, operationName, "response", "json")));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_4);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public static String generateRequesterName(String prefix, int seqNo, ArtifactType type) throws OperationProcessingException {
        String string = prefix;
        int n = seqNo;
        ArtifactType artifactType = type;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), artifactType};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_5, joinPoint);
            String name = null;
            String nameFormat = "%s%s%s%s%s";
            if (prefix == null || prefix.equals("")) {
                prefix = "API";
            }
            String seqInRadix36 = Long.toString(seqNo, 36);
            int seqLength = seqInRadix36.length();
            int zerosToAdd = 2 - seqLength;
            String zeros = "";
            if (zerosToAdd > 0) {
                zeros = String.format("%0" + zerosToAdd + "d", 0);
            }
            String suffix = "01";
            name = String.format(nameFormat, prefix, zeros, seqInRadix36, type.name(), suffix);
            String string4 = string3 = (string2 = name.toUpperCase());
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_5);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    public static String generateLogFilePath(String logFileDir, String operationId, String path, String httpMethod) {
        String string = logFileDir;
        String string2 = operationId;
        String string3 = path;
        String string4 = httpMethod;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object[])objectArray);
        try {
            String logFilePath;
            String string5;
            String string6;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_6, joinPoint);
            String fileName = null;
            if (operationId != null && !operationId.equals("")) {
                fileName = operationId;
            } else {
                String nameFormat = "%s_%s";
                path = NameUtil.convertPathToName(path);
                fileName = String.format(nameFormat, path, httpMethod);
            }
            String pathFormat = "%s%s.log";
            String dir = logFileDir.endsWith("/") ? logFileDir : logFileDir + "/";
            String string7 = string6 = (string5 = (logFilePath = String.format(pathFormat, dir, fileName)));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string6, ajc$tjp_6);
            return string5;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    public static String convertPathToName(String path) {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string);
        try {
            String string2;
            String string3;
            TracingAspect.aspectOf().ajc$before$com_ibm_zosconnect_openapi_parser_TracingAspect$1$14f55b34(ajc$tjp_7, joinPoint);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String string4 = string3 = (string2 = (path = path.replace("/", "_")));
            TracingAspect.aspectOf().ajc$afterReturning$com_ibm_zosconnect_openapi_parser_TracingAspect$2$14f55b34(string3, ajc$tjp_7);
            return string2;
        }
        catch (Throwable throwable) {
            TracingAspect.aspectOf().ajc$afterThrowing$com_ibm_zosconnect_openapi_parser_TracingAspect$3$6cc4c6a8(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        NameUtil.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NameUtil.java", NameUtil.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "", "", ""), 19);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateOperationName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String:java.lang.String:java.lang.String:int", "operationId:relativePath:httpMethod:serviceSeq", "", "java.util.Map$Entry"), 43);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateWsBindName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String", "operationName", "", "java.lang.String"), 65);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateReqJsonName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String", "operationName", "", "java.lang.String"), 71);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateRespJsonName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String", "operationName", "", "java.lang.String"), 77);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateRequesterName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String:int:com.ibm.zosconnect.openapi.parser.internal.ArtifactType", "prefix:seqNo:type", "com.ibm.zosconnect.openapi.parser.OperationProcessingException", "java.lang.String"), 95);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateLogFilePath", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "logFileDir:operationId:path:httpMethod", "", "java.lang.String"), 120);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertPathToName", "com.ibm.zosconnect.openapi.parser.internal.util.NameUtil", "java.lang.String", "path", "", "java.lang.String"), 137);
    }
}

