/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.indeed.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class CollectionSerializer<K>
implements Serializer<Collection<K>> {
    private static final Logger log = Logger.getLogger(CollectionSerializer.class);
    private final Serializer<K> serializer;

    public CollectionSerializer(Serializer<K> serializer) {
        this.serializer = serializer;
    }

    public void write(Collection<K> ks, DataOutput out) throws IOException {
        out.writeInt(ks.size());
        for (K k : ks) {
            this.serializer.write(k, out);
        }
    }

    public Collection<K> read(DataInput in) throws IOException {
        int length = in.readInt();
        ArrayList<Object> ret = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            ret.add(this.serializer.read(in));
        }
        return ret;
    }
}

