/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.indeed.util.io.VIntUtils;
import com.indeed.util.serialization.Serializer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class DeltaEncodedIntegerCollectionSerializer
implements Serializer<Collection<Integer>> {
    private static final Logger log = Logger.getLogger(DeltaEncodedIntegerCollectionSerializer.class);

    public void write(Collection<Integer> integers, DataOutput out) throws IOException {
        out.writeInt(integers.size());
        int previous = 0;
        for (int i : integers) {
            int delta = i - previous;
            VIntUtils.writeVInt((DataOutput)out, (int)delta);
            previous = i;
        }
    }

    public Collection<Integer> read(DataInput in) throws IOException {
        int length = in.readInt();
        IntArrayList ret = new IntArrayList(length);
        int previous = 0;
        for (int i = 0; i < length; ++i) {
            int id;
            int delta = VIntUtils.readVInt((DataInput)in);
            previous = id = previous + delta;
            ret.add(id);
        }
        return ret;
    }
}

