/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.indeed.util.io.VIntUtils;
import com.indeed.util.serialization.Serializer;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class DeltaEncodedLongCollectionSerializer
implements Serializer<Collection<Long>> {
    private static final Logger log = Logger.getLogger(DeltaEncodedLongCollectionSerializer.class);

    public void write(Collection<Long> longs, DataOutput out) throws IOException {
        out.writeInt(longs.size());
        long previous = 0L;
        for (long i : longs) {
            long delta = i - previous;
            VIntUtils.writeVInt64((DataOutput)out, (long)delta);
            previous = i;
        }
    }

    public Collection<Long> read(DataInput in) throws IOException {
        int length = in.readInt();
        LongArrayList ret = new LongArrayList(length);
        long previous = 0L;
        for (int i = 0; i < length; ++i) {
            long id;
            long delta = VIntUtils.readVInt64((DataInput)in);
            previous = id = previous + delta;
            ret.add(id);
        }
        return ret;
    }
}

