/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Longs;
import com.indeed.lsmtree.recordcache.CacheStats;
import com.indeed.util.serialization.Serializer;
import com.indeed.util.serialization.Stringifier;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.spy.memcached.CachedData;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class MemcachedCache<K, V>
implements Closeable {
    private static final Logger log = Logger.getLogger(MemcachedCache.class);
    private static final int CACHE_EXPIRY_SECONDS = (int)TimeUnit.HOURS.toSeconds(6L);
    private final MemcachedClient memcache;
    private final InetSocketAddress host;
    private final String prefix;
    private final Stringifier<K> keyStringifier;
    private final Transcoder<V> valueTranscoder;
    private final ArrayBlockingQueue<Future<Boolean>> addFutureQueue = new ArrayBlockingQueue(10000);
    private final ArrayBlockingQueue<Future<Boolean>> setFutureQueue = new ArrayBlockingQueue(10000);
    private final AtomicBoolean run = new AtomicBoolean(true);
    private static final Transcoder<byte[]> identityTranscoder = new Transcoder<byte[]>(){

        public boolean asyncDecode(CachedData cachedData) {
            return false;
        }

        public CachedData encode(byte[] bytes) {
            return new CachedData(0, bytes, bytes.length);
        }

        public byte[] decode(CachedData cachedData) {
            return cachedData.getData();
        }

        public int getMaxSize() {
            return Integer.MAX_VALUE;
        }
    };

    public static <K, V> MemcachedCache<K, V> create(String host, int port, String prefix, Stringifier<K> keyStringifier, Serializer<V> valueSerializer) throws IOException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        MemcachedClient memcache = new MemcachedClient(new InetSocketAddress[]{address});
        return new MemcachedCache<K, V>(memcache, address, prefix, keyStringifier, valueSerializer);
    }

    MemcachedCache(MemcachedClient memcache, InetSocketAddress address, String prefix, Stringifier<K> keyStringifier, final Serializer<V> valueSerializer) throws IOException {
        this.memcache = memcache;
        this.prefix = prefix;
        this.keyStringifier = keyStringifier;
        this.host = address;
        this.valueTranscoder = new Transcoder<V>(){

            public boolean asyncDecode(CachedData cachedData) {
                return false;
            }

            public CachedData encode(V v) {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                try {
                    valueSerializer.write(v, (DataOutput)out);
                    return identityTranscoder.encode((Object)out.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public V decode(CachedData cachedData) {
                byte[] bytes = (byte[])identityTranscoder.decode(cachedData);
                ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
                try {
                    return valueSerializer.read((DataInput)in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public int getMaxSize() {
                return Integer.MAX_VALUE;
            }
        };
        Thread addFutureChecker = new Thread((Runnable)new FutureQueueChecker(this.run, this.addFutureQueue, "memcached add failed, key already exists in cache", Level.INFO), "addFutureChecker");
        addFutureChecker.setDaemon(true);
        addFutureChecker.start();
        Thread setFutureChecker = new Thread((Runnable)new FutureQueueChecker(this.run, this.setFutureQueue, "memcached set failed, this should never happen", Level.ERROR), "setFutureChecker");
        setFutureChecker.setDaemon(true);
        setFutureChecker.start();
    }

    public void putInCache(K key, V value, boolean addOnly) {
        this.putInCache(key, value, addOnly, -1);
    }

    public void putInCache(K key, V value, boolean addOnly, int expirationTime) {
        String memcacheKey = this.prefix + this.keyStringifier.toString(key);
        try {
            if (addOnly) {
                OperationFuture add = this.memcache.add(memcacheKey, expirationTime < 0 ? CACHE_EXPIRY_SECONDS : expirationTime, value, this.valueTranscoder);
                this.addFutureQueue.put((Future<Boolean>)add);
            } else {
                OperationFuture set = this.memcache.set(memcacheKey, expirationTime < 0 ? Integer.MAX_VALUE : expirationTime, value, this.valueTranscoder);
                this.setFutureQueue.put((Future<Boolean>)set);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"interrupted while queueing", (Throwable)e);
        }
    }

    public Map<K, V> getFromCache(Collection<K> keys, CacheStats cacheStats) {
        Map map;
        if (keys.isEmpty()) {
            log.debug((Object)"got empty request");
            return Collections.emptyMap();
        }
        HashMap results = Maps.newHashMapWithExpectedSize((int)keys.size());
        String[] memcachedKeys = new String[keys.size()];
        int i = 0;
        for (K key : keys) {
            memcachedKeys[i++] = this.prefix + this.keyStringifier.toString(key);
        }
        long start = System.nanoTime();
        try {
            map = this.memcache.getBulk(Arrays.asList(memcachedKeys), this.valueTranscoder);
        }
        catch (Exception e) {
            log.error((Object)"error getting bulk values", (Throwable)e);
            map = Collections.emptyMap();
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        cacheStats.memcacheTime += System.nanoTime() - start;
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String memcachedKey = (String)entry.getKey();
            Object key = this.keyStringifier.fromString(memcachedKey.substring(this.prefix.length(), memcachedKey.length()));
            results.put(key, value);
        }
        cacheStats.memcacheHits += results.size();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Requested " + keys.size() + " items from cache, got " + results.size() + " items back"));
        }
        return results;
    }

    public void delete(K key) {
        String str = this.keyStringifier.toString(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting key " + str));
        }
        this.memcache.delete(this.prefix + str);
    }

    public Map<String, String> getStats() {
        Map retVal = (Map)this.memcache.getStats().get(this.host);
        if (retVal != null) {
            return retVal;
        }
        return Collections.emptyMap();
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Memcached Stats: " + this.memcache.getStats()));
        }
        this.memcache.shutdown();
    }

    public String toString() {
        return "[MemcachedCache: " + this.memcache + "]";
    }

    @Override
    public void close() throws IOException {
        this.run.set(false);
        this.shutdown();
    }

    public boolean checkAvailability(String key) {
        long time = System.nanoTime();
        key = key + "-" + UUID.randomUUID().toString();
        OperationFuture future = this.memcache.set(key, CACHE_EXPIRY_SECONDS, (Object)Longs.toByteArray((long)time), identityTranscoder);
        try {
            if (!((Boolean)future.get()).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        byte[] bytes = (byte[])this.memcache.get(key, identityTranscoder);
        this.memcache.delete(key);
        return bytes != null && Longs.fromByteArray((byte[])bytes) == time;
    }

    private static class FutureQueueChecker
    implements Runnable {
        private final AtomicBoolean run;
        private final BlockingQueue<Future<Boolean>> queue;
        private final String failedMessage;
        private final Priority failureLevel;

        private FutureQueueChecker(AtomicBoolean run, BlockingQueue<Future<Boolean>> queue, String failedMessage, Level failureLevel) {
            this.run = run;
            this.queue = queue;
            this.failedMessage = failedMessage;
            this.failureLevel = failureLevel;
        }

        @Override
        public void run() {
            while (this.run.get()) {
                try {
                    Future<Boolean> put = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (put == null) continue;
                    try {
                        if (put.get().booleanValue()) continue;
                        log.log(this.failureLevel, (Object)this.failedMessage);
                    }
                    catch (ExecutionException e) {
                        log.error((Object)("exception executing memcached operation in thread: " + Thread.currentThread().getName()), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("exception executing memcached operation in thread: " + Thread.currentThread().getName()), (Throwable)e);
                }
            }
        }
    }
}

