/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.indeed.lsmtree.recordcache.CacheStats;
import com.indeed.lsmtree.recordcache.Checkpoint;
import com.indeed.lsmtree.recordcache.Delete;
import com.indeed.lsmtree.recordcache.IndexReadException;
import com.indeed.lsmtree.recordcache.MemcachedCache;
import com.indeed.lsmtree.recordcache.Operation;
import com.indeed.lsmtree.recordcache.PersistentRecordCache;
import com.indeed.lsmtree.recordcache.Put;
import com.indeed.lsmtree.recordcache.RecordCache;
import com.indeed.lsmtree.recordcache.RecordLogDirectoryPoller;
import com.indeed.util.core.Either;
import com.indeed.util.core.LongRecentEventsCounter;
import com.indeed.util.serialization.Serializer;
import com.indeed.util.serialization.Stringifier;
import fj.F;
import fj.P2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class MemcachedMappingRecordCache<A, B, C, D>
implements RecordCache<C, D> {
    private static final Logger log = Logger.getLogger(MemcachedMappingRecordCache.class);
    private final PersistentRecordCache<A, B> baseCache;
    private final F<A, C> aToCFunction;
    private final F<C, A> cToAFunction;
    private final F<B, D> valueMapFunction;
    private final MemcachedCache<C, D> memcache;
    private final RecordLogDirectoryPoller.Functions memcacheUpdateFunctions;
    private final LongRecentEventsCounter memcacheMissCounter = new LongRecentEventsCounter(LongRecentEventsCounter.MINUTE_TICKER, 60);
    private final LongRecentEventsCounter lsmTreeMissCounter = new LongRecentEventsCounter(LongRecentEventsCounter.MINUTE_TICKER, 60);

    public MemcachedMappingRecordCache(PersistentRecordCache<A, B> baseCache, final F<A, C> aToCFunction, F<C, A> cToAFunction, final F<B, D> valueMapFunction, MemcachedCache<C, D> memcachedCache) {
        this.baseCache = baseCache;
        this.aToCFunction = aToCFunction;
        this.cToAFunction = cToAFunction;
        this.valueMapFunction = valueMapFunction;
        this.memcache = memcachedCache;
        this.memcacheUpdateFunctions = new RecordLogDirectoryPoller.Functions(){
            AtomicLong memcachedPutTime = new AtomicLong(0L);
            AtomicLong memcachedDeleteTime = new AtomicLong(0L);
            AtomicInteger memcachedPuts = new AtomicInteger(0);
            AtomicInteger memcachedDeletes = new AtomicInteger(0);
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public void process(long position, Operation op) throws IOException {
                this.count.incrementAndGet();
                if (this.count.get() % 1000 == 0) {
                    int puts = this.memcachedPuts.get();
                    if (log.isDebugEnabled() && puts > 0) {
                        log.debug((Object)("avg memcached put time: " + (double)(this.memcachedPutTime.get() / (long)puts) / 1000.0 + " us"));
                    }
                    int deletes = this.memcachedDeletes.get();
                    if (log.isDebugEnabled() && deletes > 0) {
                        log.debug((Object)("avg memcached delete time: " + (double)(this.memcachedDeleteTime.get() / (long)deletes) / 1000.0 + " us"));
                    }
                }
                if (op.getClass() == Put.class) {
                    Put put = (Put)op;
                    long start = System.nanoTime();
                    MemcachedMappingRecordCache.this.memcache.putInCache(aToCFunction.f(put.getKey()), valueMapFunction.f(put.getValue()), false);
                    this.memcachedPutTime.addAndGet(System.nanoTime() - start);
                    this.memcachedPuts.incrementAndGet();
                } else if (op.getClass() == Delete.class) {
                    Delete delete = (Delete)op;
                    for (Object a : delete.getKeys()) {
                        long start = System.nanoTime();
                        MemcachedMappingRecordCache.this.memcache.delete(aToCFunction.f(a));
                        this.memcachedDeleteTime.addAndGet(System.nanoTime() - start);
                        this.memcachedDeletes.incrementAndGet();
                    }
                } else if (op.getClass() != Checkpoint.class) {
                    log.warn((Object)"operation class unknown");
                }
            }

            public void sync() throws IOException {
            }
        };
    }

    @Override
    public D get(C key, CacheStats cacheStats) {
        Map<C, D> result = this.getAll((Collection<C>)Collections.singleton(key), cacheStats);
        if (result.containsKey(key)) {
            return result.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<C, D> getAll(Collection<C> keys, CacheStats cacheStats) {
        Map<C, D> results = this.memcache.getFromCache(keys, cacheStats);
        int size = results.size();
        if (size < keys.size()) {
            HashSet missingKeys = Sets.newHashSet();
            for (C key : keys) {
                if (results.containsKey(key)) continue;
                missingKeys.add(this.cToAFunction.f(key));
                LongRecentEventsCounter longRecentEventsCounter = this.memcacheMissCounter;
                synchronized (longRecentEventsCounter) {
                    this.memcacheMissCounter.increment();
                }
            }
            if (missingKeys.size() > 0) {
                log.info((Object)("memcached misses: " + missingKeys));
            }
            Map<A, B> baseCacheResults = this.baseCache.getAll(missingKeys, cacheStats);
            for (Object a : missingKeys) {
                B b = baseCacheResults.get(a);
                if (b == null) {
                    LongRecentEventsCounter longRecentEventsCounter = this.lsmTreeMissCounter;
                    synchronized (longRecentEventsCounter) {
                        this.lsmTreeMissCounter.increment();
                    }
                    log.warn((Object)("key " + this.aToCFunction.f(a) + " not found in underlying store"));
                    continue;
                }
                Object c = this.aToCFunction.f(a);
                Object d = this.valueMapFunction.f(b);
                results.put(c, d);
                this.memcache.putInCache(c, d, true);
            }
        }
        cacheStats.persistentStoreHits = results.size() - size;
        log.debug((Object)("persistent store hits: " + (results.size() - size)));
        cacheStats.misses = keys.size() - results.size();
        log.debug((Object)("misses: " + (keys.size() - results.size())));
        return results;
    }

    @Override
    public RecordLogDirectoryPoller.Functions getFunctions() {
        return this.memcacheUpdateFunctions;
    }

    public void removeFromCache(C key) {
        this.memcache.delete(key);
    }

    public Map<String, String> getStats() {
        return this.memcache.getStats();
    }

    public void prime(Iterator<C> keys, @Nullable PrimerStatus status) throws IndexReadException {
        UnmodifiableIterator partitions = Iterators.partition(keys, (int)1000);
        Iterator iterator = Iterators.concat((Iterator)new AbstractIterator<Iterator<A>>((Iterator)partitions, status){
            final /* synthetic */ Iterator val$partitions;
            final /* synthetic */ PrimerStatus val$status;
            {
                this.val$partitions = iterator;
                this.val$status = primerStatus;
            }

            protected Iterator<A> computeNext() {
                try {
                    if (!this.val$partitions.hasNext()) {
                        this.endOfData();
                        return null;
                    }
                    CacheStats cacheStats = new CacheStats();
                    List partition = (List)this.val$partitions.next();
                    Map results = MemcachedMappingRecordCache.this.memcache.getFromCache(partition, cacheStats);
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)(partition.size() - results.size()));
                    int foundInCache = 0;
                    for (Object c : partition) {
                        if (!results.containsKey(c)) {
                            list.add(MemcachedMappingRecordCache.this.cToAFunction.f(c));
                            continue;
                        }
                        ++foundInCache;
                    }
                    if (this.val$status != null) {
                        this.val$status.primerProgress.addAndGet(foundInCache);
                        this.val$status.primerPrimed.addAndGet(foundInCache);
                    }
                    return list.iterator();
                }
                catch (Throwable t) {
                    log.error((Object)"error", t);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        });
        Iterator<Either<Exception, P2<A, B>>> streaming = this.baseCache.getStreaming(iterator, status != null ? status.primerProgress : null, status != null ? status.primerSkipped : null);
        log.info((Object)"store lookup iterator initialized");
        log.info((Object)"starting store lookups");
        while (streaming.hasNext()) {
            Either<Exception, P2<A, B>> next = streaming.next();
            try {
                P2 value = (P2)next.get();
                this.memcache.putInCache(this.aToCFunction.f(value._1()), this.valueMapFunction.f(value._2()), false);
                if (status == null) continue;
                status.primerPrimed.incrementAndGet();
                status.primerProgress.incrementAndGet();
            }
            catch (IndexReadException e) {
                log.error((Object)"error", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)"exception during priming", (Throwable)e);
                if (status == null) continue;
                status.primerErrors.incrementAndGet();
            }
        }
        log.info((Object)"store lookups complete");
    }

    @Override
    public void close() throws IOException {
        this.memcache.close();
    }

    public boolean checkAvailability(String key) {
        return this.memcache.checkAvailability(key);
    }

    public String getMemcacheMissCounter() {
        return this.memcacheMissCounter.toString();
    }

    public String getLsmTreeMissCounter() {
        return this.lsmTreeMissCounter.toString();
    }

    public static class PrimerStatus {
        private final AtomicLong primerErrors;
        private final AtomicInteger primerProgress;
        private final AtomicInteger primerSkipped;
        private final AtomicInteger primerPrimed;

        public PrimerStatus(AtomicLong primerErrors, AtomicInteger primerProgress, AtomicInteger primerSkipped, AtomicInteger primerPrimed) {
            this.primerErrors = primerErrors;
            this.primerProgress = primerProgress;
            this.primerSkipped = primerSkipped;
            this.primerPrimed = primerPrimed;
        }

        public AtomicLong getPrimerErrors() {
            return this.primerErrors;
        }

        public AtomicInteger getPrimerProgress() {
            return this.primerProgress;
        }

        public AtomicInteger getPrimerSkipped() {
            return this.primerSkipped;
        }

        public AtomicInteger getPrimerPrimed() {
            return this.primerPrimed;
        }

        public String toString() {
            return "PrimerStatus{primerErrors=" + this.primerErrors + ", primerProgress=" + this.primerProgress + ", primerSkipped=" + this.primerSkipped + ", primerPrimed=" + this.primerPrimed + '}';
        }
    }

    public static final class Builder<A, B, C, D> {
        private Stringifier<C> keyStringifier;
        private Serializer<C> keySerializer;
        private Serializer<D> valueSerializer;
        private String memcacheHost;
        private int memcachePort = -1;
        private String memcacheKeyPrefix = "";
        private PersistentRecordCache<A, B> baseCache;
        private F<A, C> aToCFunction;
        private F<C, A> cToAFunction;
        private F<B, D> valueMapFunction;

        public MemcachedMappingRecordCache<A, B, C, D> build() throws IOException {
            if (this.keyStringifier == null) {
                throw new IllegalArgumentException("keyStringifier must be set");
            }
            if (this.keySerializer == null) {
                throw new IllegalArgumentException("keySerializer must be set");
            }
            if (this.valueSerializer == null) {
                throw new IllegalArgumentException("valueSerializer must be set");
            }
            if (this.memcacheHost == null) {
                throw new IllegalArgumentException("memcacheHost must be set");
            }
            if (this.memcachePort < 0) {
                throw new IllegalArgumentException("memcachePort must be set");
            }
            MemcachedCache<C, D> memcache = MemcachedCache.create(this.memcacheHost, this.memcachePort, this.memcacheKeyPrefix, this.keyStringifier, this.valueSerializer);
            return new MemcachedMappingRecordCache<A, B, C, D>(this.baseCache, this.aToCFunction, this.cToAFunction, this.valueMapFunction, memcache);
        }

        public Builder setKeyStringifier(Stringifier<C> keyStringifier) {
            this.keyStringifier = keyStringifier;
            return this;
        }

        public Builder setKeySerializer(Serializer<C> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public Builder setValueSerializer(Serializer<D> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public Builder setMemcacheHost(String memcacheHost) {
            this.memcacheHost = memcacheHost;
            return this;
        }

        public Builder setMemcachePort(int memcachePort) {
            this.memcachePort = memcachePort;
            return this;
        }

        public Builder setMemcacheKeyPrefix(String memcacheKeyPrefix) {
            this.memcacheKeyPrefix = memcacheKeyPrefix;
            return this;
        }

        public Builder setBaseCache(PersistentRecordCache<A, B> baseCache) {
            this.baseCache = baseCache;
            return this;
        }

        public Builder setaToCFunction(F<A, C> aToCFunction) {
            this.aToCFunction = aToCFunction;
            return this;
        }

        public Builder setcToAFunction(F<C, A> cToAFunction) {
            this.cToAFunction = cToAFunction;
            return this;
        }

        public Builder setValueMapFunction(F<B, D> valueMapFunction) {
            this.valueMapFunction = valueMapFunction;
            return this;
        }
    }
}

