/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.indeed.lsmtree.recordcache.Checkpoint;
import com.indeed.lsmtree.recordcache.CollectionSerializer;
import com.indeed.lsmtree.recordcache.Delete;
import com.indeed.lsmtree.recordcache.Operation;
import com.indeed.lsmtree.recordcache.Put;
import com.indeed.util.serialization.Serializer;
import fj.P1;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class OperationSerializer<K, V>
implements Serializer<Operation> {
    private static final Logger log = Logger.getLogger(OperationSerializer.class);
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Serializer<Collection<K>> keyCollectionSerializer;

    public OperationSerializer(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(keySerializer, valueSerializer, new CollectionSerializer<K>(keySerializer));
    }

    public OperationSerializer(Serializer<K> keySerializer, Serializer<V> valueSerializer, Serializer<Collection<K>> keyCollectionSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyCollectionSerializer = keyCollectionSerializer;
    }

    public void write(Operation operation, DataOutput out) throws IOException {
        if (operation.getClass() == Put.class) {
            out.writeByte(1);
            Put put = (Put)operation;
            this.keySerializer.write(put.getKey(), out);
            this.valueSerializer.write(put.getValue(), out);
        } else if (operation.getClass() == Delete.class) {
            out.writeByte(2);
            Delete delete = (Delete)operation;
            this.keyCollectionSerializer.write(delete.getKeys(), out);
        } else if (operation.getClass() == Checkpoint.class) {
            Checkpoint checkpoint = (Checkpoint)operation;
            out.writeByte(3);
            out.writeLong(checkpoint.getTimestamp());
        } else {
            throw new RuntimeException("type does not match any of available types");
        }
    }

    public Operation read(final DataInput dataIn) throws IOException {
        try {
            byte type = dataIn.readByte();
            if (type == 1) {
                return new Put(this.keySerializer.read(dataIn), new P1<V>(){
                    V v = null;
                    boolean initialized = false;

                    public synchronized V _1() {
                        if (this.initialized) {
                            return this.v;
                        }
                        this.initialized = true;
                        try {
                            this.v = OperationSerializer.this.valueSerializer.read(dataIn);
                            return this.v;
                        }
                        catch (IOException e) {
                            log.error((Object)"error parsing value", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            if (type == 2) {
                return new Delete((Collection)this.keyCollectionSerializer.read(dataIn));
            }
            if (type == 3) {
                return new Checkpoint(dataIn.readLong());
            }
            throw new RuntimeException("type does not match any of available types");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

