/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.google.common.io.Closer;
import com.indeed.lsmtree.core.Store;
import com.indeed.lsmtree.recordcache.RecordLogDirectoryPoller;
import com.indeed.lsmtree.recordlog.RecordLogDirectory;
import java.io.Closeable;
import java.io.IOException;

public class RecordLogStore<K, V>
implements Closeable {
    private final Store<K, V> store;
    private final RecordLogDirectoryPoller recordLogDirectoryPoller;
    private final RecordLogDirectory recordLogDirectory;
    private final Closer closer = Closer.create();

    public RecordLogStore(Store<K, V> store, RecordLogDirectoryPoller recordLogDirectoryPoller, RecordLogDirectory recordLogDirectory) {
        this.store = (Store)this.closer.register(store);
        this.recordLogDirectory = (RecordLogDirectory)this.closer.register((Closeable)recordLogDirectory);
        this.recordLogDirectoryPoller = (RecordLogDirectoryPoller)((Object)this.closer.register((Closeable)((Object)recordLogDirectoryPoller)));
    }

    public Store<K, V> getStore() {
        return this.store;
    }

    public RecordLogDirectoryPoller getRecordLogDirectoryPoller() {
        return this.recordLogDirectoryPoller;
    }

    public RecordLogDirectory getRecordLogDirectory() {
        return this.recordLogDirectory;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

