/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.indeed.lsmtree.core.StorageType;
import com.indeed.lsmtree.core.Store;
import com.indeed.lsmtree.core.StoreBuilder;
import com.indeed.lsmtree.recordcache.Checkpoint;
import com.indeed.lsmtree.recordcache.CollectionSerializer;
import com.indeed.lsmtree.recordcache.Delete;
import com.indeed.lsmtree.recordcache.Operation;
import com.indeed.lsmtree.recordcache.OperationSerializer;
import com.indeed.lsmtree.recordcache.Put;
import com.indeed.lsmtree.recordcache.RecordLogDirectoryPoller;
import com.indeed.lsmtree.recordcache.RecordLogStore;
import com.indeed.lsmtree.recordlog.RecordLogDirectory;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.compress.SnappyCodec;
import com.indeed.util.serialization.Serializer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;

public final class ReplicatingStoreBuilder<K, V> {
    private static final Logger log = Logger.getLogger(ReplicatingStoreBuilder.class);
    private final StoreBuilder<K, V> storeBuilder;
    private final File recordsPath;
    private final File indexPath;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private Serializer<Collection<K>> keyCollectionSerializer;
    private CompressionCodec codec;
    private File checkpointDir;

    public ReplicatingStoreBuilder(File recordsPath, File indexPath, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.storeBuilder = new StoreBuilder(indexPath, keySerializer, valueSerializer);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.recordsPath = recordsPath;
        this.indexPath = indexPath;
    }

    public ReplicatingStoreBuilder<K, V> setKeyCollectionSerializer(Serializer<Collection<K>> keyCollectionSerializer) {
        this.keyCollectionSerializer = keyCollectionSerializer;
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setCodec(CompressionCodec codec) {
        this.codec = codec;
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setDedicatedPartition(boolean dedicatedPartition) {
        this.storeBuilder.setDedicatedPartition(dedicatedPartition);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setReservedSpaceThreshold(long reservedSpaceThreshold) {
        this.storeBuilder.setReservedSpaceThreshold(reservedSpaceThreshold);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setComparator(Comparator<K> comparator) {
        this.storeBuilder.setComparator(comparator);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setMaxVolatileGenerationSize(long maxVolatileGenerationSize) {
        this.storeBuilder.setMaxVolatileGenerationSize(maxVolatileGenerationSize);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setStorageType(StorageType storageType) {
        this.storeBuilder.setStorageType(storageType);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setStoreCodec(CompressionCodec codec) {
        this.storeBuilder.setCodec(codec);
        return this;
    }

    public ReplicatingStoreBuilder<K, V> setCheckpointDir(File checkpointDir) {
        this.checkpointDir = checkpointDir;
        return this;
    }

    public RecordLogStore<K, V> build() throws IOException {
        if (this.codec == null) {
            SnappyCodec snappyCodec = new SnappyCodec();
            this.codec = snappyCodec;
        }
        if (this.keyCollectionSerializer == null) {
            this.keyCollectionSerializer = new CollectionSerializer<K>(this.keySerializer);
        }
        final Store store = this.storeBuilder.build();
        RecordLogDirectory recordLogDirectory = new RecordLogDirectory.Builder(this.recordsPath, new OperationSerializer<K, V>(this.keySerializer, this.valueSerializer, this.keyCollectionSerializer), this.codec).build();
        RecordLogDirectoryPoller poller = new RecordLogDirectoryPoller((RecordLogDirectory<Operation>)recordLogDirectory, new File(this.indexPath, "lastposition.txt"), true, true);
        final File checkpointDir = this.checkpointDir;
        poller.registerFunctions(new RecordLogDirectoryPoller.Functions(){

            @Override
            public void process(long position, Operation op) throws IOException {
                if (op instanceof Put) {
                    Put put = (Put)op;
                    store.put(put.getKey(), put.getValue());
                } else if (op instanceof Delete) {
                    Delete delete = (Delete)op;
                    for (Object key : delete.getKeys()) {
                        store.delete(key);
                    }
                } else if (op instanceof Checkpoint) {
                    Checkpoint checkpoint = (Checkpoint)op;
                    if (checkpointDir != null) {
                        store.checkpoint(checkpointDir);
                    }
                } else {
                    log.error((Object)("unknown operation of type " + op.getClass().getName()));
                    throw new UnsupportedOperationException();
                }
            }

            public void sync() throws IOException {
                store.sync();
            }
        });
        poller.start();
        return new RecordLogStore(store, poller, recordLogDirectory);
    }
}

