/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordcache;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.indeed.lsmtree.core.StorageType;
import com.indeed.lsmtree.core.Store;
import com.indeed.lsmtree.core.StoreBuilder;
import com.indeed.lsmtree.recordcache.CacheStats;
import com.indeed.lsmtree.recordcache.Checkpoint;
import com.indeed.lsmtree.recordcache.Delete;
import com.indeed.lsmtree.recordcache.IndexReadException;
import com.indeed.lsmtree.recordcache.Operation;
import com.indeed.lsmtree.recordcache.Put;
import com.indeed.lsmtree.recordcache.RecordCache;
import com.indeed.lsmtree.recordcache.RecordLogDirectoryPoller;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.compress.SnappyCodec;
import com.indeed.util.core.Either;
import com.indeed.util.serialization.Serializer;
import com.indeed.util.varexport.Export;
import fj.P;
import fj.P2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.log4j.Logger;

public final class StandalonePersistentRecordCache<K, V>
implements RecordCache<K, V> {
    private static final Logger log = Logger.getLogger(StandalonePersistentRecordCache.class);
    private final Store<K, V> index;
    private final RecordLogDirectoryPoller.Functions indexUpdateFunctions;

    private StandalonePersistentRecordCache(final Store<K, V> index, final File checkpointDir) throws IOException {
        this.index = index;
        this.indexUpdateFunctions = new RecordLogDirectoryPoller.Functions(){
            AtomicLong indexPutTime = new AtomicLong(0L);
            AtomicLong indexDeleteTime = new AtomicLong(0L);
            AtomicInteger indexPuts = new AtomicInteger(0);
            AtomicInteger indexDeletes = new AtomicInteger(0);
            AtomicInteger count = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(long position, Operation op) throws IOException {
                this.count.incrementAndGet();
                if (this.count.get() % 1000 == 0) {
                    int puts = this.indexPuts.get();
                    if (log.isDebugEnabled() && puts > 0) {
                        log.debug((Object)("avg index put time: " + (double)(this.indexPutTime.get() / (long)puts) / 1000.0 + " us"));
                    }
                    int deletes = this.indexDeletes.get();
                    if (log.isDebugEnabled() && deletes > 0) {
                        log.debug((Object)("avg index delete time: " + (double)(this.indexDeleteTime.get() / (long)deletes) / 1000.0 + " us"));
                    }
                }
                if (op.getClass() == Put.class) {
                    Put put = (Put)op;
                    long start = System.nanoTime();
                    Store store = index;
                    synchronized (store) {
                        index.put(put.getKey(), put.getValue());
                    }
                    this.indexPutTime.addAndGet(System.nanoTime() - start);
                    this.indexPuts.incrementAndGet();
                } else if (op.getClass() == Delete.class) {
                    Delete delete = (Delete)op;
                    for (Object k : delete.getKeys()) {
                        long start = System.nanoTime();
                        Store store = index;
                        synchronized (store) {
                            index.delete(k);
                        }
                        this.indexDeleteTime.addAndGet(System.nanoTime() - start);
                        this.indexDeletes.incrementAndGet();
                    }
                } else if (op.getClass() == Checkpoint.class) {
                    Checkpoint checkpoint = (Checkpoint)op;
                    if (checkpointDir != null) {
                        this.sync();
                        index.checkpoint(new File(checkpointDir, String.valueOf(checkpoint.getTimestamp())));
                    }
                } else {
                    log.warn((Object)"operation class unknown");
                }
            }

            public void sync() throws IOException {
                long start = System.nanoTime();
                index.sync();
                log.debug((Object)("sync time: " + (double)(System.nanoTime() - start) / 1000.0 + " us"));
            }
        };
    }

    @Export(name="index-active-space-usage")
    public long getIndexActiveSpaceUsage() throws IOException {
        return this.index.getActiveSpaceUsage();
    }

    @Export(name="index-total-space-usage")
    public long getIndexTotalSpaceUsage() throws IOException {
        return this.index.getTotalSpaceUsage();
    }

    @Export(name="index-reserverd-space-usage")
    public long getIndexReservedSpaceUsage() {
        return this.index.getReservedSpaceUsage();
    }

    @Export(name="index-free-space")
    public long getIndexFreeSpace() throws IOException {
        return this.index.getFreeSpace();
    }

    @Override
    public V get(K key, CacheStats cacheStats) {
        Map<K, V> results = this.getAll(Collections.singleton(key), cacheStats);
        if (results.size() > 0) {
            return results.get(key);
        }
        return null;
    }

    @Override
    public Map<K, V> getAll(Collection<K> keys, CacheStats cacheStats) {
        HashMap results = Maps.newHashMap();
        for (K key : keys) {
            long start = System.nanoTime();
            try {
                Object value = this.index.get(key);
                results.put(key, value);
            }
            catch (Exception e) {
                log.error((Object)("index read error while fetching key " + key), (Throwable)e);
                ++cacheStats.indexReadErrors;
            }
            cacheStats.indexTime += System.nanoTime() - start;
        }
        cacheStats.misses = keys.size() - results.size();
        log.debug((Object)("misses: " + (keys.size() - results.size())));
        return results;
    }

    public Iterator<Either<Exception, P2<K, V>>> getStreaming(Iterator<K> keys, AtomicInteger progress, AtomicInteger skipped) {
        log.info((Object)"starting store lookups");
        ArrayList ret = Lists.newArrayList();
        int notFound = 0;
        while (keys.hasNext()) {
            Object value;
            K key = keys.next();
            try {
                value = this.index.get(key);
            }
            catch (IOException e) {
                log.error((Object)"error", (Throwable)e);
                return Iterators.singletonIterator((Object)Either.Left.of((Throwable)new IndexReadException(e)));
            }
            if (value != null) {
                ret.add(Either.Right.of((Object)P.p(key, (Object)value)));
                continue;
            }
            ++notFound;
        }
        if (progress != null) {
            progress.addAndGet(notFound);
        }
        if (skipped != null) {
            skipped.addAndGet(notFound);
        }
        log.info((Object)"store lookups complete");
        return ret.iterator();
    }

    @Override
    public RecordLogDirectoryPoller.Functions getFunctions() {
        return this.indexUpdateFunctions;
    }

    @Override
    public void close() throws IOException {
        this.index.close();
    }

    public void waitForCompactions() throws InterruptedException {
        this.index.waitForCompactions();
    }

    public static class Builder<K, V> {
        private File indexDir;
        private File checkpointDir;
        private Serializer<K> keySerializer;
        private Serializer<V> valueSerializer;
        private boolean dedicatedIndexPartition;
        private Comparator<K> comparator = new ComparableComparator();
        private boolean mlockIndex = false;
        private boolean mlockBloomFilters = false;
        private long bloomFilterMemory = -1L;

        public StandalonePersistentRecordCache<K, V> build() throws IOException {
            if (this.indexDir == null) {
                throw new IllegalArgumentException("indexDir must be set");
            }
            if (this.keySerializer == null) {
                throw new IllegalArgumentException("keySerializer must be set");
            }
            if (this.valueSerializer == null) {
                throw new IllegalArgumentException("valueSerializer must be set");
            }
            SnappyCodec codec = new SnappyCodec();
            StoreBuilder indexBuilder = new StoreBuilder(this.indexDir, this.keySerializer, this.valueSerializer);
            indexBuilder.setMaxVolatileGenerationSize(0x800000L);
            indexBuilder.setCodec((CompressionCodec)codec);
            indexBuilder.setStorageType(StorageType.BLOCK_COMPRESSED);
            indexBuilder.setComparator(this.comparator);
            indexBuilder.setDedicatedPartition(this.dedicatedIndexPartition);
            indexBuilder.setMlockFiles(this.mlockIndex);
            indexBuilder.setMlockBloomFilters(this.mlockBloomFilters);
            if (this.bloomFilterMemory >= 0L) {
                indexBuilder.setBloomFilterMemory(this.bloomFilterMemory);
            }
            Store index = indexBuilder.build();
            return new StandalonePersistentRecordCache(index, this.checkpointDir);
        }

        public Builder<K, V> setIndexDir(File indexDir) {
            this.indexDir = indexDir;
            return this;
        }

        public Builder<K, V> setKeySerializer(Serializer<K> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public Builder<K, V> setValueSerializer(Serializer<V> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public Builder<K, V> setComparator(Comparator<K> comparator) {
            this.comparator = comparator;
            return this;
        }

        public Builder<K, V> setCheckpointDir(File checkpointDir) {
            this.checkpointDir = checkpointDir;
            return this;
        }

        public boolean isDedicatedIndexPartition() {
            return this.dedicatedIndexPartition;
        }

        public Builder<K, V> setDedicatedIndexPartition(boolean dedicatedIndexPartition) {
            this.dedicatedIndexPartition = dedicatedIndexPartition;
            return this;
        }

        public boolean isMlockIndex() {
            return this.mlockIndex;
        }

        public Builder<K, V> setMlockIndex(boolean mlockIndex) {
            this.mlockIndex = mlockIndex;
            return this;
        }

        public boolean isMlockBloomFilters() {
            return this.mlockBloomFilters;
        }

        public Builder<K, V> setMlockBloomFilters(boolean mlockBloomFilters) {
            this.mlockBloomFilters = mlockBloomFilters;
            return this;
        }

        public long getBloomFilterMemory() {
            return this.bloomFilterMemory;
        }

        public Builder<K, V> setBloomFilterMemory(long bloomFilterMemory) {
            this.bloomFilterMemory = bloomFilterMemory;
            return this;
        }
    }
}

