/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.logging;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.consumer.logging.TestUsageObserver;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;

public class TestMarkingObserver
implements TestUsageObserver {
    private final Set<String> testMarkers;
    private final ProctorResult originalResult;

    public TestMarkingObserver(ProctorResult originalResult) {
        this.originalResult = originalResult;
        this.testMarkers = ConcurrentHashMap.newKeySet(originalResult.getBuckets().size());
    }

    @Override
    public void markUsedForToggling(Collection<String> testNames) {
        this.testMarkers.addAll(testNames);
    }

    @Override
    public void markUsedForToggling(String testName) {
        this.testMarkers.add(testName);
    }

    public void markTestsUsedForLogging(Collection<String> testNames) {
        this.markUsedForToggling(testNames);
    }

    public void markTestsUsedForLogging(String testName) {
        this.markUsedForToggling(testName);
    }

    public ProctorResult asProctorResult() {
        return new ProctorResult(this.originalResult.getMatrixVersion(), Maps.filterKeys((SortedMap)((SortedMap)this.originalResult.getBuckets()), this.testMarkers::contains), Maps.filterKeys((SortedMap)((SortedMap)this.originalResult.getAllocations()), this.testMarkers::contains), Maps.filterKeys((Map)this.originalResult.getTestDefinitions(), this.testMarkers::contains), this.originalResult.getIdentifiers(), this.originalResult.getInputContext());
    }
}

