/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.store.FileBasedPersisterCore;
import com.indeed.proctor.store.FileBasedProctorStore;
import com.indeed.proctor.store.GitProctorCore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.StoreException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class GitProctor
extends FileBasedProctorStore {
    private static final Logger LOGGER = Logger.getLogger(GitProctor.class);
    private final Git git;
    private String branchName;

    public GitProctor(String gitPath, String username, String password, String testDefinitionsDirectory) {
        this(new GitProctorCore(gitPath, username, password, testDefinitionsDirectory, Files.createTempDir()), testDefinitionsDirectory);
    }

    public GitProctor(String gitPath, String username, String password, String testDefinitionsDirectory, String branchName) {
        this(new GitProctorCore(gitPath, username, password, testDefinitionsDirectory, Files.createTempDir(), branchName), testDefinitionsDirectory, branchName);
    }

    public GitProctor(String gitPath, String username, String password) {
        this(gitPath, username, password, "test-definitions");
    }

    public GitProctor(GitProctorCore core) {
        this(core, "test-definitions");
    }

    public GitProctor(GitProctorCore core, String testDefinitionsDirectory) {
        super((FileBasedPersisterCore)core, testDefinitionsDirectory);
        this.git = core.getGit();
    }

    public GitProctor(GitProctorCore core, String testDefinitionsDirectory, String branchName) {
        super((FileBasedPersisterCore)core, testDefinitionsDirectory);
        this.git = core.getGit();
        this.branchName = branchName;
        this.checkoutBranch(branchName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String gitUrl = System.console().readLine("git url: ", new Object[0]);
        String gituser = System.console().readLine("user: ", new Object[0]);
        String password = new String(System.console().readPassword("password: ", new Object[0]));
        int num_revisions = Integer.parseInt(System.console().readLine("number of histories: ", new Object[0]));
        String testDefinitionDirectory = System.console().readLine("test definitions directory: ", new Object[0]);
        File tempDir = Files.createTempDir();
        try {
            GitProctor client = new GitProctor(gitUrl, gituser, password, testDefinitionDirectory);
            System.out.println("Running load matrix for last " + num_revisions + " revisions");
            long start = System.currentTimeMillis();
            List<Revision> revisions = client.getMatrixHistory(0, num_revisions);
            for (Revision rev : revisions) {
                TestMatrixVersion testMatrixVersion = client.getTestMatrix(rev.getRevision());
            }
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("Finished reading matrix history (" + revisions.size() + ") in " + elapsed + " ms");
            client.close();
        }
        catch (StoreException e) {
            LOGGER.error((Object)e);
        }
        finally {
            System.out.println("Deleting temp dir : " + tempDir);
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    public void verifySetup() throws StoreException {
        String refName = this.getGitCore().getRefName();
        try {
            ObjectId branchHead = this.git.getRepository().resolve(refName);
            if (branchHead == null) {
                throw new StoreException("git repository couldn't resolve " + refName);
            }
        }
        catch (IncorrectObjectTypeException e) {
            throw new StoreException("Could get resolve " + refName);
        }
        catch (AmbiguousObjectException e) {
            throw new StoreException("Could get resolve " + refName);
        }
        catch (IOException e) {
            throw new StoreException("Could get resolve " + refName);
        }
    }

    protected GitProctorCore getGitCore() {
        return (GitProctorCore)this.core;
    }

    public boolean cleanUserWorkspace(String username) {
        this.getGitCore().undoLocalChanges();
        this.getGitCore().initializeRepository(false);
        this.checkoutBranch(this.branchName);
        return true;
    }

    public String getLatestVersion() throws StoreException {
        try {
            Ref branch = this.git.getRepository().findRef(this.getGitCore().getRefName());
            return branch.getObjectId().name();
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public List<Revision> getMatrixHistory(int start, int limit) throws StoreException {
        try {
            ObjectId branchHead = this.git.getRepository().resolve(this.getGitCore().getRefName());
            LogCommand logCommand = this.git.log().add((AnyObjectId)branchHead).setSkip(start).setMaxCount(limit);
            return this.getHistoryFromLogCommand(logCommand);
        }
        catch (MissingObjectException e) {
            throw new StoreException("Could not get history for starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
        catch (IncorrectObjectTypeException e) {
            throw new StoreException("Could not get history for starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
        catch (AmbiguousObjectException e) {
            throw new StoreException("Could not get history for starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history for starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    public List<Revision> getHistory(String test, int start, int limit) throws StoreException {
        return this.getHistory(test, this.getLatestVersion(), start, limit);
    }

    public List<Revision> getHistory(String test, String revision, int start, int limit) throws StoreException {
        try {
            ObjectId commitId = ObjectId.fromString((String)revision);
            LogCommand logCommand = this.git.log().addPath(this.getTestDefinitionsDirectory() + File.separator + test + File.separator + "definition.json").add((AnyObjectId)commitId).setSkip(start).setMaxCount(limit);
            return this.getHistoryFromLogCommand(logCommand);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history for " + test + " starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    public Map<String, List<Revision>> getAllHistories() throws StoreException {
        Repository repository = this.git.getRepository();
        try {
            ObjectId head = repository.resolve("HEAD");
            RevWalk revWalk = new RevWalk(repository);
            DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            df.setRepository(this.git.getRepository());
            df.setDiffComparator(RawTextComparator.DEFAULT);
            HistoryParser historyParser = new HistoryParser(revWalk, df, this.getTestDefinitionsDirectory());
            return historyParser.parseFromHead(head);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    private List<Revision> getHistoryFromLogCommand(LogCommand command) throws StoreException {
        Iterable commits;
        ArrayList versions = Lists.newArrayList();
        try {
            commits = command.call();
        }
        catch (GitAPIException e) {
            throw new StoreException("Could not get history", (Throwable)e);
        }
        for (RevCommit commit : commits) {
            versions.add(new Revision(commit.getName(), commit.getAuthorIdent().toExternalString(), new Date(Long.valueOf(commit.getCommitTime()) * 1000L), commit.getFullMessage()));
        }
        return versions;
    }

    public void checkoutBranch(String branchName) {
        this.getGitCore().checkoutBranch(branchName);
    }

    public void refresh() throws StoreException {
        this.getGitCore().refresh();
    }

    public String getName() {
        return "GitProctor-" + this.branchName;
    }

    public static class HistoryParser {
        final RevWalk revWalk;
        final DiffFormatter df;
        final Pattern testNamePattern;
        @Nullable
        final Set<String> activeTests;
        private static final Cache<String, List<DiffEntry>> diffEntriesCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).maximumSize(1000000L).build();

        public HistoryParser(RevWalk revWalk, DiffFormatter df, String definitionDirectory, @Nullable Set<String> activeTests) {
            this.revWalk = revWalk;
            this.df = df;
            this.testNamePattern = HistoryParser.compileTestNamePattern(definitionDirectory);
            this.activeTests = activeTests;
        }

        public HistoryParser(RevWalk revWalk, DiffFormatter df, String definitionDirectory) {
            this(revWalk, df, definitionDirectory, null);
        }

        public Map<String, List<Revision>> parseFromHead(ObjectId head) throws IOException {
            HashMap histories = Maps.newHashMap();
            HashSet visited = Sets.newHashSet();
            LinkedList<RevCommit> queue = new LinkedList<RevCommit>();
            queue.add(this.revWalk.parseCommit((AnyObjectId)head));
            while (!queue.isEmpty()) {
                this.parseCommit((RevCommit)queue.poll(), histories, visited, queue);
            }
            long start = System.currentTimeMillis();
            HistoryParser.sortByDate(histories);
            long end = System.currentTimeMillis();
            LOGGER.info((Object)String.format("Took %d ms to sort revisions in chronological order", end - start));
            return histories;
        }

        private void parseCommit(RevCommit commit, Map<String, List<Revision>> histories, Set<ObjectId> visited, Queue<RevCommit> queue) throws IOException {
            if (visited.contains(commit.getId())) {
                return;
            }
            visited.add(commit.getId());
            RevCommit[] parents = commit.getParents();
            if (parents.length == 1) {
                RevCommit parent = this.revWalk.parseCommit((AnyObjectId)parents[0].getId());
                List<DiffEntry> diffs = this.getDiffEntries(commit, parent);
                for (DiffEntry diff : diffs) {
                    String changePath = diff.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE) ? diff.getOldPath() : diff.getNewPath();
                    Matcher testNameMatcher = this.testNamePattern.matcher(changePath);
                    if (!testNameMatcher.matches()) continue;
                    String testName = testNameMatcher.group(1);
                    if (this.activeTests != null && !this.activeTests.contains(testName)) continue;
                    ArrayList history = histories.get(testName);
                    if (history == null) {
                        history = Lists.newArrayList();
                        histories.put(testName, history);
                    }
                    history.add(new Revision(commit.getName(), commit.getAuthorIdent().toExternalString(), new Date(Long.valueOf(commit.getCommitTime()) * 1000L), commit.getFullMessage()));
                }
                queue.add(parent);
            } else if (parents.length == 2) {
                for (RevCommit parent : parents) {
                    queue.add(this.revWalk.parseCommit((AnyObjectId)parent.getId()));
                }
            }
        }

        private List<DiffEntry> getDiffEntries(final RevCommit commit, final RevCommit parent) throws IOException {
            try {
                return (List)diffEntriesCache.get((Object)commit.getName(), (Callable)new Callable<List<DiffEntry>>(){

                    @Override
                    public List<DiffEntry> call() throws Exception {
                        return HistoryParser.this.df.scan(parent.getTree(), commit.getTree());
                    }
                });
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }

        @VisibleForTesting
        static void sortByDate(Map<String, List<Revision>> histories) {
            Comparator<Revision> comparator = new Comparator<Revision>(){

                @Override
                public int compare(Revision o1, Revision o2) {
                    return o2.getDate().compareTo(o1.getDate());
                }
            };
            for (List<Revision> revisions : histories.values()) {
                Collections.sort(revisions, comparator);
            }
        }

        @VisibleForTesting
        public static Pattern compileTestNamePattern(String definitionDirectory) {
            return Pattern.compile(definitionDirectory + File.separator + "(\\w+)" + File.separator + "definition.json");
        }
    }
}

