/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class LoggerPrintWriter
extends PrintWriter {
    public LoggerPrintWriter(Logger logger, Level level) {
        super(new InternalLoggerWriter(logger, level));
    }

    static class InternalLoggerWriter
    extends Writer {
        final Logger logger;
        final Level level;

        InternalLoggerWriter(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.logger.isEnabledFor((Priority)this.level)) {
                if (cbuf[off] == '\r') {
                    ++off;
                    --len;
                }
                this.logger.log((Priority)this.level, (Object)String.copyValueOf(cbuf, off, len));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

