/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.indeed.proctor.store.GitProctorUtils;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.RevisionDetails;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;

class GitHistoryParser {
    private static final Logger LOGGER = Logger.getLogger(GitHistoryParser.class);
    private static final int EXPECTED_NUMBER_ACTIVE_TESTS = 7000;
    private final RevWalk revWalk;
    private final DiffFormatter diffFormatter;
    private final Pattern testNamePattern;
    private static final Cache<String, List<DiffEntry>> DIFF_ENTRIES_CACHE = CacheBuilder.newBuilder().build();

    private GitHistoryParser(RevWalk revWalk, DiffFormatter diffFormatter, String definitionDirectory) {
        this.revWalk = revWalk;
        this.diffFormatter = diffFormatter;
        this.testNamePattern = GitHistoryParser.compileTestNamePattern(definitionDirectory);
    }

    Map<String, List<Revision>> parseFromHead(ObjectId head) throws IOException {
        HashMap histories = Maps.newHashMapWithExpectedSize((int)7000);
        HashSet visited = Sets.newHashSet();
        LinkedList<RevCommit> queue = new LinkedList<RevCommit>();
        queue.add(this.revWalk.parseCommit((AnyObjectId)head));
        long start = System.currentTimeMillis();
        while (!queue.isEmpty()) {
            this.parseCommit((RevCommit)queue.poll(), histories, visited, queue);
        }
        long middle = System.currentTimeMillis();
        GitHistoryParser.sortByDate(histories);
        long end = System.currentTimeMillis();
        LOGGER.info((Object)String.format("Took %d ms to parse, %d ms to sort revisions in chronological order", middle - start, end - middle));
        return histories;
    }

    @Nonnull
    RevisionDetails parseRevisionDetails(ObjectId revisionId) throws IOException {
        RevCommit commit = this.revWalk.parseCommit((AnyObjectId)revisionId);
        Revision revision = GitHistoryParser.createRevisionFromCommit(commit);
        Set<String> modifiedTests = this.getModifiedTests(commit);
        return new RevisionDetails(revision, modifiedTests);
    }

    private void parseCommit(RevCommit commit, Map<String, List<Revision>> histories, Set<ObjectId> visited, Queue<RevCommit> queue) throws IOException {
        RevCommit[] parents;
        if (!visited.add(commit.getId())) {
            return;
        }
        Set<String> modifiedTests = this.getModifiedTests(commit);
        for (String testName : modifiedTests) {
            List history = histories.computeIfAbsent(testName, x -> new ArrayList());
            history.add(GitHistoryParser.createRevisionFromCommit(commit));
        }
        for (RevCommit parent : parents = commit.getParents()) {
            queue.add(this.revWalk.parseCommit((AnyObjectId)parent.getId()));
        }
    }

    private Set<String> getModifiedTests(RevCommit commit) throws IOException {
        RevCommit[] parents = commit.getParents();
        HashSet<String> result = new HashSet<String>();
        if (parents.length == 1) {
            RevCommit parent = this.revWalk.parseCommit((AnyObjectId)parents[0].getId());
            List<DiffEntry> diffs = this.getDiffEntries(commit, parent);
            for (DiffEntry diff : diffs) {
                String changePath = diff.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE) ? diff.getOldPath() : diff.getNewPath();
                Matcher testNameMatcher = this.testNamePattern.matcher(changePath);
                if (!testNameMatcher.matches()) continue;
                String testName = testNameMatcher.group(1);
                result.add(testName);
            }
        }
        return result;
    }

    private List<DiffEntry> getDiffEntries(RevCommit commit, RevCommit parent) throws IOException {
        try {
            return (List)DIFF_ENTRIES_CACHE.get((Object)commit.getName(), () -> this.diffFormatter.scan(parent.getTree(), commit.getTree()));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    static void sortByDate(Map<String, List<Revision>> histories) {
        Comparator comparator = (o1, o2) -> o2.getDate().compareTo(o1.getDate());
        for (List<Revision> revisions : histories.values()) {
            revisions.sort(comparator);
        }
    }

    @VisibleForTesting
    static Pattern compileTestNamePattern(String definitionDirectory) {
        return Pattern.compile(definitionDirectory + File.separator + "(\\w+)" + File.separator + "definition.json");
    }

    static Revision createRevisionFromCommit(RevCommit commit) {
        return new Revision(commit.getName(), GitProctorUtils.determineAuthorId(commit), new Date((long)commit.getCommitTime() * 1000L), commit.getFullMessage());
    }

    static GitHistoryParser fromRepository(Repository repository, String testDefinitionDirectory) {
        RevWalk revWalk = new RevWalk(repository);
        DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        df.setRepository(repository);
        df.setDiffComparator(RawTextComparator.DEFAULT);
        df.setDetectRenames(false);
        return new GitHistoryParser(revWalk, df, testDefinitionDirectory);
    }
}

