/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.indeed.proctor.store.Revision;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitProctorUtils {
    public static final int DEFAULT_GIT_PULL_PUSH_TIMEOUT_SECONDS = 45;
    public static final int DEFAULT_GIT_CLONE_TIMEOUT_SECONDS = 180;

    private GitProctorUtils() {
    }

    @CheckForNull
    public static String resolveSvnMigratedRevision(@Nullable Revision revision, String branch) {
        if (revision == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^git-svn-id: .*" + branch + "@([0-9]+) ", 8);
        Matcher matcher = pattern.matcher(revision.getMessage());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return revision.getRevision();
    }

    public static String determineAuthorId(RevCommit commit) {
        String name = Strings.nullToEmpty((String)commit.getAuthorIdent().getName());
        String email = Strings.nullToEmpty((String)commit.getAuthorIdent().getEmailAddress());
        return GitProctorUtils.determineAuthorIdFromNameAndEmail(name, email);
    }

    @VisibleForTesting
    static String determineAuthorIdFromNameAndEmail(String name, String email) {
        if (email.contains("@")) {
            return StringUtils.split((String)email, (String)"@")[0];
        }
        return name;
    }
}

