/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.indeed.proctor.store.GitProctorCallable;
import com.indeed.proctor.store.GitWorkspaceProvider;
import com.indeed.proctor.store.StoreException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class GitWorkspaceProviderImpl
implements GitWorkspaceProvider {
    private static final Logger LOGGER = Logger.getLogger(GitWorkspaceProviderImpl.class);
    private static final int DEFAULT_LOCK_TIMEOUT_SECONDS = 90;
    private final File rootDirectory;
    private final Lock directoryLock;
    private final int lockTimeoutSeconds;

    public GitWorkspaceProviderImpl(File rootDirectory) {
        this(rootDirectory, 90);
    }

    public GitWorkspaceProviderImpl(File rootDirectory, int lockTimeoutSeconds) {
        this.rootDirectory = (File)Preconditions.checkNotNull((Object)rootDirectory, (Object)"Root Directory cannot be null");
        this.directoryLock = new ReentrantLock();
        Preconditions.checkArgument((boolean)rootDirectory.isDirectory(), (String)"File %s should be a directory", (Object[])new Object[]{rootDirectory.getAbsolutePath()});
        Preconditions.checkArgument((boolean)rootDirectory.exists(), (String)"File %s should exist", (Object[])new Object[]{rootDirectory.getAbsolutePath()});
        this.lockTimeoutSeconds = lockTimeoutSeconds;
    }

    @Override
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T synchronizedOperation(Callable<T> callable) {
        try {
            if (!this.directoryLock.tryLock(this.lockTimeoutSeconds, TimeUnit.SECONDS)) throw Throwables.propagate((Throwable)new StoreException("Attempt to acquire lock on working directory was timeout: " + this.lockTimeoutSeconds + "s. Maybe due to dead lock"));
            try {
                T t = callable.call();
                return t;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.directoryLock.unlock();
            }
        }
        catch (InterruptedException e2) {
            LOGGER.error((Object)"Thread interrupted. ", (Throwable)e2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T synchronizedUpdateOperation(GitProctorCallable<T> callable) throws StoreException.TestUpdateException {
        try {
            if (!this.directoryLock.tryLock(this.lockTimeoutSeconds, TimeUnit.SECONDS)) throw Throwables.propagate((Throwable)new StoreException("Attempt to acquire lock on working directory was timeout: " + this.lockTimeoutSeconds + "s. Maybe due to dead lock"));
            try {
                T t = callable.call();
                return t;
            }
            finally {
                this.directoryLock.unlock();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Thread interrupted. ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean cleanWorkingDirectory() {
        this.synchronizedOperation(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    FileUtils.cleanDirectory((File)GitWorkspaceProviderImpl.this.rootDirectory);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Unable to clean working directory", (Throwable)e);
                }
                return null;
            }
        });
        return true;
    }
}

