/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.indeed.proctor.store.GitNoAuthorizationException;
import com.indeed.proctor.store.GitNoDevelperAccessLevelException;
import com.indeed.proctor.store.GitNoMasterAccessLevelException;
import com.indeed.proctor.store.GitServerErrorException;
import com.indeed.proctor.store.StoreException;
import org.eclipse.jgit.api.errors.TransportException;

public class GitAPIExceptionWrapper {
    private String gitUrl;

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public StoreException.TestUpdateException wrapException(StoreException.TestUpdateException exception) {
        Throwable cause = exception.getCause();
        if (this.gitUrl.endsWith(".git")) {
            if (cause instanceof TransportException) {
                if (cause.getMessage().contains("not authorized")) {
                    return new GitNoAuthorizationException("Please check your user name and password", (Throwable)exception);
                }
                if (cause.getMessage().contains("git-receive-pack not permitted")) {
                    return new GitNoDevelperAccessLevelException("Check if your access level is developer in [" + this.gitUrl.substring(0, this.gitUrl.length() - 4) + "/project_members]", (Throwable)exception);
                }
                if (cause.getMessage().matches("^50\\d\\s.*")) {
                    return new GitServerErrorException("Check if " + this.gitUrl + " is available", (Throwable)exception);
                }
            } else if (cause instanceof IllegalStateException && "pre-receive hook declined".equals(cause.getMessage())) {
                return new GitNoMasterAccessLevelException("Check if your access level is master in [" + this.gitUrl.substring(0, this.gitUrl.length() - 4) + "/project_members]", (Throwable)exception);
            }
        }
        return exception;
    }
}

