/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.indeed.proctor.store.FileBasedPersisterCore;
import com.indeed.proctor.store.FileBasedProctorStore;
import com.indeed.proctor.store.GitHistoryParser;
import com.indeed.proctor.store.GitProctorCore;
import com.indeed.proctor.store.GitProctorUtils;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.RevisionDetails;
import com.indeed.proctor.store.StoreException;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitProctor
extends FileBasedProctorStore {
    private static final Logger LOGGER = Logger.getLogger(GitProctor.class);
    private final Git git;
    @Nullable
    private final String branchName;

    public GitProctor(String gitPath, String username, String password, String testDefinitionsDirectory) {
        this(gitPath, username, password, testDefinitionsDirectory, null);
    }

    public GitProctor(String gitPath, String username, String password, String testDefinitionsDirectory, @Nullable String branchName) {
        this(new GitProctorCore(gitPath, username, password, testDefinitionsDirectory, Files.createTempDir()), testDefinitionsDirectory, branchName);
    }

    public GitProctor(String gitPath, String username, String password) {
        this(gitPath, username, password, "test-definitions");
    }

    public GitProctor(GitProctorCore core) {
        this(core, "test-definitions");
    }

    public GitProctor(GitProctorCore core, String testDefinitionsDirectory) {
        this(core, testDefinitionsDirectory, null);
    }

    public GitProctor(GitProctorCore core, String testDefinitionsDirectory, @Nullable String branchName) {
        super((FileBasedPersisterCore)core, testDefinitionsDirectory);
        this.git = core.getGit();
        this.branchName = branchName;
        if (branchName != null) {
            this.checkoutBranch(branchName);
        }
    }

    public void verifySetup() throws StoreException {
        String refName = this.getGitCore().getRefName();
        try {
            ObjectId branchHead = this.git.getRepository().resolve(refName);
            if (branchHead == null) {
                throw new StoreException("git repository couldn't resolve " + refName);
            }
        }
        catch (IOException e) {
            throw new StoreException("Could get resolve " + refName);
        }
    }

    protected GitProctorCore getGitCore() {
        return (GitProctorCore)this.core;
    }

    public boolean cleanUserWorkspace(String username) {
        this.getGitCore().undoLocalChanges();
        this.getGitCore().initializeRepository(false);
        if (this.branchName != null) {
            this.checkoutBranch(this.branchName);
        }
        return true;
    }

    @Nonnull
    public String getLatestVersion() throws StoreException {
        try {
            Ref branch = this.git.getRepository().findRef(this.getGitCore().getRefName());
            return branch.getObjectId().name();
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }

    @Nonnull
    public List<Revision> getMatrixHistory(int start, int limit) throws StoreException {
        try {
            ObjectId branchHead = this.git.getRepository().resolve(this.getGitCore().getRefName());
            LogCommand logCommand = this.git.log().add((AnyObjectId)branchHead).setSkip(start).setMaxCount(limit);
            return this.getHistoryFromLogCommand(logCommand);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history for starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    @Nonnull
    public List<Revision> getMatrixHistory(Instant sinceInclusive, Instant untilExclusive) throws StoreException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public List<Revision> getHistory(String test, int start, int limit) throws StoreException {
        return this.getHistory(test, this.getLatestVersion(), start, limit);
    }

    @Nonnull
    public List<Revision> getHistory(String test, String revision, int start, int limit) throws StoreException {
        try {
            ObjectId commitId = ObjectId.fromString((String)revision);
            LogCommand logCommand = this.git.log().addPath(this.getTestDefinitionsDirectory() + File.separator + test + File.separator + "definition.json").add((AnyObjectId)commitId).setSkip(start).setMaxCount(limit);
            return this.getHistoryFromLogCommand(logCommand);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history for " + test + " starting at " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    @CheckForNull
    public RevisionDetails getRevisionDetails(String revisionId) throws StoreException {
        try {
            ObjectId objectId = this.git.getRepository().resolve(revisionId);
            if (objectId == null) {
                return null;
            }
            GitHistoryParser historyParser = GitHistoryParser.fromRepository(this.git.getRepository(), this.getTestDefinitionsDirectory());
            return historyParser.parseRevisionDetails(objectId);
        }
        catch (MissingObjectException e) {
            LOGGER.debug((Object)("unknown revision " + revisionId), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw new StoreException("Could not get detail for " + revisionId, (Throwable)e);
        }
    }

    @Nonnull
    public Map<String, List<Revision>> getAllHistories() throws StoreException {
        Repository repository = this.git.getRepository();
        try {
            ObjectId head = repository.resolve("HEAD");
            GitHistoryParser historyParser = GitHistoryParser.fromRepository(this.git.getRepository(), this.getTestDefinitionsDirectory());
            return historyParser.parseFromHead(head);
        }
        catch (IOException e) {
            throw new StoreException("Could not get history " + this.getGitCore().getRefName(), (Throwable)e);
        }
    }

    private List<Revision> getHistoryFromLogCommand(LogCommand command) throws StoreException {
        Iterable commits;
        ArrayList versions = Lists.newArrayList();
        try {
            commits = command.call();
        }
        catch (GitAPIException e) {
            throw new StoreException("Could not get history", (Throwable)e);
        }
        for (RevCommit commit : commits) {
            versions.add(new Revision(commit.getName(), GitProctorUtils.determineAuthorId(commit), new Date((long)commit.getCommitTime() * 1000L), commit.getFullMessage()));
        }
        return versions;
    }

    public void checkoutBranch(String branchName) {
        this.getGitCore().checkoutBranch(branchName);
    }

    public void refresh() throws StoreException {
        this.getGitCore().refresh();
    }

    public String getName() {
        return "GitProctor-" + this.branchName;
    }
}

