/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.store.ChangeMetadata;
import com.indeed.proctor.store.FileBasedPersisterCore;
import com.indeed.proctor.store.FileBasedProctorStore;
import com.indeed.proctor.store.GitAPIExceptionWrapper;
import com.indeed.proctor.store.GitDirectoryRefresher;
import com.indeed.proctor.store.GitProctorCallable;
import com.indeed.proctor.store.GitProctorUtils;
import com.indeed.proctor.store.GitWorkspaceProvider;
import com.indeed.proctor.store.GitWorkspaceProviderImpl;
import com.indeed.proctor.store.LoggerPrintWriter;
import com.indeed.proctor.store.StoreException;
import com.indeed.proctor.store.TestVersionResult;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitProctorCore
implements FileBasedPersisterCore {
    private static final Logger LOGGER = Logger.getLogger(GitProctorCore.class);
    private static final TextProgressMonitor PROGRESS_MONITOR = new TextProgressMonitor((Writer)new LoggerPrintWriter(LOGGER, Level.DEBUG));
    private static final long GC_INTERVAL_IN_HOURS = 24L;
    private static final AtomicInteger INITIAL_DELAY_SCHEDULE = new AtomicInteger();
    private static final boolean DEFAULT_CLEAN_INITIALIZATION = false;
    private final String username;
    private final String password;
    private final String testDefinitionsDirectory;
    private Git git;
    private final String gitUrl;
    private final String refName;
    @Nullable
    private final String branchName;
    private final GitWorkspaceProvider workspaceProvider;
    private final ScheduledExecutorService gcExecutor;
    private final UsernamePasswordCredentialsProvider user;
    private final GitAPIExceptionWrapper gitAPIExceptionWrapper;
    private final int pullPushTimeoutSeconds;
    private final int cloneTimeoutSeconds;

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, File tempDir) {
        this(gitUrl, username, password, testDefinitionsDirectory, new GitWorkspaceProviderImpl(tempDir));
    }

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, File tempDir, String branchName) {
        this(gitUrl, username, password, testDefinitionsDirectory, new GitWorkspaceProviderImpl(tempDir), 45, 180, false, branchName);
    }

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, GitWorkspaceProvider workspaceProvider) {
        this(gitUrl, username, password, testDefinitionsDirectory, workspaceProvider, 45, 180);
    }

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, GitWorkspaceProvider workspaceProvider, int pullPushTimeoutSeconds, int cloneTimeoutSeconds) {
        this(gitUrl, username, password, testDefinitionsDirectory, workspaceProvider, pullPushTimeoutSeconds, cloneTimeoutSeconds, false);
    }

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, GitWorkspaceProvider workspaceProvider, int pullPushTimeoutSeconds, int cloneTimeoutSeconds, boolean cleanInitialization) {
        this(gitUrl, username, password, testDefinitionsDirectory, workspaceProvider, pullPushTimeoutSeconds, cloneTimeoutSeconds, cleanInitialization, null);
    }

    public GitProctorCore(String gitUrl, String username, String password, String testDefinitionsDirectory, GitWorkspaceProvider workspaceProvider, int pullPushTimeoutSeconds, int cloneTimeoutSeconds, boolean cleanInitialization, @Nullable String branchName) {
        this.gitUrl = gitUrl;
        this.refName = "HEAD";
        this.workspaceProvider = (GitWorkspaceProvider)Preconditions.checkNotNull((Object)workspaceProvider, (Object)"GitWorkspaceProvider should not be null");
        this.username = username;
        this.password = password;
        this.user = new UsernamePasswordCredentialsProvider(username, password);
        this.testDefinitionsDirectory = testDefinitionsDirectory;
        this.gcExecutor = Executors.newSingleThreadScheduledExecutor();
        this.pullPushTimeoutSeconds = pullPushTimeoutSeconds;
        this.cloneTimeoutSeconds = cloneTimeoutSeconds;
        this.branchName = branchName;
        this.gitAPIExceptionWrapper = new GitAPIExceptionWrapper();
        this.gitAPIExceptionWrapper.setGitUrl(gitUrl);
        this.initializeRepository(cleanInitialization);
    }

    private Git pullRepository(File workingDir) throws GitAPIException, IOException {
        Git git = Git.open((File)workingDir);
        ((PullCommand)((PullCommand)git.pull().setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setRebase(true).setCredentialsProvider((CredentialsProvider)this.user)).setTimeout(this.pullPushTimeoutSeconds)).call();
        return git;
    }

    private Git cloneRepository(File workingDir) throws GitAPIException {
        CloneCommand cloneCommand = (CloneCommand)((CloneCommand)Git.cloneRepository().setURI(this.gitUrl).setDirectory(workingDir).setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setCredentialsProvider((CredentialsProvider)this.user)).setTimeout(this.cloneTimeoutSeconds);
        if (StringUtils.isNotEmpty((CharSequence)this.branchName)) {
            String refBranchName = "refs/heads/" + this.branchName;
            cloneCommand.setBranchesToClone((Collection)ImmutableSet.of((Object)refBranchName)).setBranch(refBranchName);
        }
        return cloneCommand.call();
    }

    void initializeRepository(final boolean cleanInitialization) {
        final File workingDir = this.workspaceProvider.getRootDirectory();
        final File gitDirectory = new File(workingDir, ".git");
        LOGGER.info((Object)("Initializing repository " + this.gitUrl + " in working dir " + workingDir.getAbsolutePath()));
        this.workspaceProvider.synchronizedOperation(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    if (!gitDirectory.exists()) {
                        LOGGER.info((Object)"Local repository not found, creating a new clone...");
                        GitProctorCore.this.git = GitProctorCore.this.cloneRepository(workingDir);
                    } else if (cleanInitialization) {
                        LOGGER.info((Object)"Existing local repository found, but creating a new clone to clean up working directory...");
                        GitProctorCore.this.workspaceProvider.cleanWorkingDirectory();
                        GitProctorCore.this.git = GitProctorCore.this.cloneRepository(workingDir);
                    } else {
                        LOGGER.info((Object)"Existing local repository found, pulling latest changes...");
                        try {
                            GitProctorCore.this.git = GitProctorCore.this.pullRepository(workingDir);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"Could not update existing local repository, creating a new clone...", (Throwable)e);
                            GitProctorCore.this.workspaceProvider.cleanWorkingDirectory();
                            GitProctorCore.this.git = GitProctorCore.this.cloneRepository(workingDir);
                        }
                    }
                }
                catch (GitAPIException e) {
                    LOGGER.error((Object)("Unable to clone git repository at " + GitProctorCore.this.gitUrl), (Throwable)e);
                }
                return null;
            }
        });
        StoredConfig config = this.git.getRepository().getConfig();
        config.setBoolean("pack", null, "singlePack", true);
        try {
            config.save();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Could not write .git/config", (Throwable)e);
        }
        try {
            ((FetchCommand)((FetchCommand)this.git.fetch().setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setCredentialsProvider((CredentialsProvider)this.user)).setTimeout(this.pullPushTimeoutSeconds)).call();
        }
        catch (GitAPIException e) {
            LOGGER.error((Object)("Unable to fetch from " + this.gitUrl), (Throwable)e);
        }
        this.gcExecutor.scheduleAtFixedRate(new GitGcTask(), 24L + (long)INITIAL_DELAY_SCHEDULE.getAndIncrement(), 24L, TimeUnit.HOURS);
    }

    @Nullable
    public <C> C getFileContents(Class<C> c, String[] path, @Nullable C defaultValue, String revision) throws StoreException.ReadException, JsonProcessingException {
        try {
            if (!ObjectId.isId((String)revision)) {
                throw new StoreException.ReadException("Malformed id " + revision);
            }
            ObjectId blobOrCommitId = ObjectId.fromString((String)revision);
            ObjectLoader loader = this.git.getRepository().open((AnyObjectId)blobOrCommitId);
            if (loader.getType() == 1) {
                RevCommit commit = RevCommit.parse((byte[])loader.getCachedBytes());
                TreeWalk treeWalk2 = new TreeWalk(this.git.getRepository());
                treeWalk2.addTree((AnyObjectId)commit.getTree());
                treeWalk2.setRecursive(true);
                String joinedPath = String.join((CharSequence)"/", path);
                treeWalk2.setFilter((TreeFilter)PathFilter.create((String)joinedPath));
                if (!treeWalk2.next()) {
                    return defaultValue;
                }
                ObjectId blobId = treeWalk2.getObjectId(0);
                return this.getFileContents(c, blobId);
            }
            if (loader.getType() == 3) {
                return this.getFileContents(c, blobOrCommitId);
            }
            throw new StoreException.ReadException("Invalid Object Type " + loader.getType() + " for id " + revision);
        }
        catch (IOException e) {
            throw new StoreException.ReadException((Throwable)e);
        }
    }

    private <C> C getFileContents(Class<C> c, ObjectId blobId) throws IOException {
        ObjectLoader loader = this.git.getRepository().open((AnyObjectId)blobId);
        ObjectMapper mapper = Serializers.lenient();
        return (C)mapper.readValue(loader.getBytes(), c);
    }

    public boolean cleanWorkingDirectory() {
        return this.workspaceProvider.cleanWorkingDirectory();
    }

    @Deprecated
    public GitDirectoryRefresher createRefresherTask(String username, String password) {
        return new GitDirectoryRefresher(this.workspaceProvider, this, username, password);
    }

    public GitDirectoryRefresher createRefresherTask() {
        return new GitDirectoryRefresher(this.workspaceProvider, this, this.username, this.password);
    }

    public void doInWorkingDirectory(final ChangeMetadata changeMetadata, String previousVersion, final FileBasedProctorStore.ProctorUpdater updater) throws StoreException.TestUpdateException {
        final UsernamePasswordCredentialsProvider user = new UsernamePasswordCredentialsProvider(this.username, this.password);
        final File workingDir = this.workspaceProvider.getRootDirectory();
        this.workspaceProvider.synchronizedUpdateOperation(new GitProctorCallable<Void>(){

            @Override
            public Void call() throws StoreException.TestUpdateException {
                try {
                    GitRcsClient rcsClient;
                    boolean thingsChanged;
                    GitProctorCore.this.git = Git.open((File)workingDir);
                    PullResult pullResult = ((PullCommand)((PullCommand)GitProctorCore.this.git.pull().setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setRebase(true).setCredentialsProvider((CredentialsProvider)user)).setTimeout(GitProctorCore.this.pullPushTimeoutSeconds)).call();
                    if (!pullResult.isSuccessful()) {
                        LOGGER.info((Object)"Failed to pull from the remote repository. Running undo local changes");
                        GitProctorCore.this.undoLocalChanges();
                    }
                    if (thingsChanged = updater.doInWorkingDirectory((FileBasedProctorStore.RcsClient)(rcsClient = new GitRcsClient(GitProctorCore.this.git, GitProctorCore.this.testDefinitionsDirectory)), workingDir)) {
                        Set stagedTests = GitProctorCore.this.parseStagedTestNames();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Staged tests are " + String.join((CharSequence)",", stagedTests)));
                        }
                        if (stagedTests != null && stagedTests.size() >= 2) {
                            LOGGER.error((Object)("Multiple tests are going to be modified at the one commit : " + String.join((CharSequence)",", stagedTests)));
                            throw new IllegalStateException("Another test are staged unintentionally due to invalid local git state");
                        }
                        if (stagedTests != null && stagedTests.isEmpty()) {
                            LOGGER.warn((Object)"Failed to parse staged test names or no test files aren't staged");
                        }
                        GitProctorCore.this.git.commit().setCommitter(new PersonIdent(GitProctorCore.this.username, GitProctorCore.this.username, Date.from(changeMetadata.getTimestamp()), TimeZone.getTimeZone("UTC"))).setAuthor(new PersonIdent(changeMetadata.getAuthor(), changeMetadata.getAuthor(), Date.from(changeMetadata.getTimestamp()), TimeZone.getTimeZone("UTC"))).setMessage(changeMetadata.getComment()).call();
                        Iterable pushResults = ((PushCommand)((PushCommand)GitProctorCore.this.git.push().setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setCredentialsProvider((CredentialsProvider)user)).setTimeout(GitProctorCore.this.pullPushTimeoutSeconds)).call();
                        for (PushResult pushResult : pushResults) {
                            block9: for (RemoteRefUpdate remoteRefUpdate : pushResult.getRemoteUpdates()) {
                                switch (remoteRefUpdate.getStatus()) {
                                    case OK: {
                                        continue block9;
                                    }
                                    case REJECTED_NONFASTFORWARD: {
                                        throw new IllegalStateException("Non-fast-forward push - there have likely been other commits made since starting. Confirm the latest state and try again.");
                                    }
                                }
                                String message = StringUtils.isNotEmpty((CharSequence)remoteRefUpdate.getMessage()) ? remoteRefUpdate.getMessage() : "Non-success push status: " + remoteRefUpdate.getStatus().toString();
                                throw new IllegalStateException(message);
                            }
                        }
                    }
                }
                catch (GitAPIException e) {
                    GitProctorCore.this.undoLocalChanges();
                    throw GitProctorCore.this.gitAPIExceptionWrapper.wrapException(new StoreException.TestUpdateException("Core: Unable to commit/push changes: " + e.getMessage(), (Throwable)e));
                }
                catch (IllegalStateException e) {
                    GitProctorCore.this.undoLocalChanges();
                    throw GitProctorCore.this.gitAPIExceptionWrapper.wrapException(new StoreException.TestUpdateException("Core: Unable to push changes: " + e.getMessage(), (Throwable)e));
                }
                catch (Exception e) {
                    GitProctorCore.this.undoLocalChanges();
                    throw new StoreException.TestUpdateException("Core: Unable to perform operation: " + e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
    }

    @Nullable
    @VisibleForTesting
    static String parseTestName(String testDefinitionsDirectory, String filePath) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)testDefinitionsDirectory) ? "" : testDefinitionsDirectory + File.separator;
        if (filePath != null && filePath.startsWith(prefix)) {
            String[] directories = filePath.substring(prefix.length()).split(File.separator);
            return directories.length > 1 ? directories[0] : null;
        }
        return null;
    }

    @Nullable
    private Set<String> parseStagedTestNames() {
        try {
            Status status = this.git.status().call();
            return Stream.of(status.getAdded(), status.getChanged(), status.getRemoved()).flatMap(Collection::stream).distinct().map(s -> GitProctorCore.parseTestName(this.testDefinitionsDirectory, s)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (GitAPIException | NoWorkTreeException e) {
            LOGGER.warn((Object)"Failed to call git status", e);
            return null;
        }
    }

    void undoLocalChanges() {
        this.workspaceProvider.synchronizedOperation(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    LOGGER.info((Object)"Undo local changes due to failure of git operations");
                    try {
                        GitProctorCore.this.git.rebase().setOperation(RebaseCommand.Operation.ABORT).call();
                    }
                    catch (WrongRepositoryStateException wrongRepositoryStateException) {
                        // empty catch block
                    }
                    String remoteBranch = "refs/remotes/origin/" + GitProctorCore.this.git.getRepository().getBranch();
                    GitProctorCore.this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef(remoteBranch).call();
                    GitProctorCore.this.git.clean().setCleanDirectories(true).call();
                    try {
                        ObjectId head = GitProctorCore.this.git.getRepository().resolve("HEAD");
                        LOGGER.info((Object)("Undo local changes completed. HEAD is " + head.getName()));
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Failed to fetch HEAD", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to undo changes", (Throwable)e);
                }
                return null;
            }
        });
    }

    public TestVersionResult determineVersions(String fetchRevision) throws StoreException.ReadException {
        try {
            RevWalk walk = new RevWalk(this.git.getRepository());
            ObjectId commitId = ObjectId.fromString((String)fetchRevision);
            RevCommit headTree = walk.parseCommit((AnyObjectId)commitId);
            RevTree tree = headTree.getTree();
            TreeWalk treeWalk = new TreeWalk(this.git.getRepository());
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)this.testDefinitionsDirectory), (TreeFilter)PathSuffixFilter.create((String)"definition.json")));
            treeWalk.setRecursive(true);
            ArrayList tests = Lists.newArrayList();
            while (treeWalk.next()) {
                ObjectId id = treeWalk.getObjectId(0);
                String path = treeWalk.getPathString();
                String[] pieces = path.split("/");
                String testname = pieces[pieces.length - 2];
                tests.add(new TestVersionResult.Test(testname, id.name()));
            }
            walk.dispose();
            return new TestVersionResult((List)tests, new Date(Long.valueOf(headTree.getCommitTime()) * 1000L), GitProctorUtils.determineAuthorId(headTree), headTree.toObjectId().getName(), headTree.getFullMessage());
        }
        catch (IOException e) {
            throw new StoreException.ReadException((Throwable)e);
        }
    }

    public void checkoutBranch(final String branchName) {
        Preconditions.checkArgument((StringUtils.isEmpty((CharSequence)this.branchName) || this.branchName.equals(branchName) ? 1 : 0) != 0, (String)"Unable to checkout branch %s because this repository cloned only the branch %s", (Object[])new Object[]{branchName, this.branchName});
        this.workspaceProvider.synchronizedOperation(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    GitProctorCore.this.git.branchCreate().setName(branchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("origin/" + branchName).setForce(true).call();
                    GitProctorCore.this.git.checkout().setName(branchName).call();
                }
                catch (GitAPIException e) {
                    LOGGER.error((Object)("Unable to create/checkout branch " + branchName), (Throwable)e);
                }
                return null;
            }
        });
    }

    Git getGit() {
        return this.git;
    }

    String getRefName() {
        return this.refName;
    }

    String getGitUrl() {
        return this.gitUrl;
    }

    public void close() throws IOException {
        this.git.getRepository().close();
    }

    public String getAddTestRevision() {
        return ObjectId.zeroId().name();
    }

    public void refresh() {
        this.workspaceProvider.synchronizedOperation(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    LOGGER.debug((Object)"Started refresh with git pull");
                    PullResult result = ((PullCommand)GitProctorCore.this.getGit().pull().setProgressMonitor((ProgressMonitor)PROGRESS_MONITOR).setRebase(true).setCredentialsProvider((CredentialsProvider)GitProctorCore.this.user)).call();
                    if (!result.isSuccessful()) {
                        LOGGER.info((Object)"refresh failed. Running undo local changes");
                        GitProctorCore.this.undoLocalChanges();
                    }
                    LOGGER.debug((Object)"Finished refresh");
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Error when refreshing git directory " + GitProctorCore.this.workspaceProvider.getRootDirectory()), (Throwable)e);
                }
                return null;
            }
        });
    }

    public class GitGcTask
    implements Runnable {
        @Override
        public void run() {
            GitProctorCore.this.workspaceProvider.synchronizedOperation(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        LOGGER.info((Object)"Start running `git gc` command to clean up git garbage");
                        Properties call = GitProctorCore.this.getGit().gc().call();
                        LOGGER.info((Object)("`git gc` has been completed " + call.toString()));
                    }
                    catch (GitAPIException e) {
                        LOGGER.error((Object)"Failed to run `git gc` command.", (Throwable)e);
                    }
                    return null;
                }
            });
        }
    }

    static class GitRcsClient
    implements FileBasedProctorStore.RcsClient {
        private final Git git;
        private final String testDefinitionsDirectory;

        public GitRcsClient(Git git, String testDefinitionsDirectory) {
            this.git = git;
            this.testDefinitionsDirectory = testDefinitionsDirectory;
        }

        public void add(File file) throws GitAPIException {
            this.git.add().addFilepattern(this.testDefinitionsDirectory + "/" + file.getAbsoluteFile().getParentFile().getName() + "/" + file.getName()).call();
        }

        public void delete(File testDefinitionDirectory) throws GitAPIException {
            for (File file : testDefinitionDirectory.listFiles()) {
                this.git.rm().addFilepattern(this.testDefinitionsDirectory + "/" + testDefinitionDirectory.getName() + "/" + file.getName()).call();
            }
        }

        public String getRevisionControlType() {
            return "git";
        }
    }
}

