/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.store.FileBasedPersisterCore;
import com.indeed.proctor.store.ProctorStore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.StoreException;
import com.indeed.proctor.store.TestVersionResult;
import com.indeed.util.varexport.Export;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class FileBasedProctorStore
implements ProctorStore {
    private static final Logger LOGGER = Logger.getLogger(FileBasedProctorStore.class);
    private static final String SUFFIX = ".json";
    static final String TEST_DEFINITIONS_DIRECTORY = "test-definitions";
    static final String TEST_METADATA_FILENAME = "metadata.json";
    static final String TEST_DEFINITION_FILENAME = "definition.json";
    final ObjectMapper objectMapper = Serializers.strict();
    protected final FileBasedPersisterCore core;

    protected FileBasedProctorStore(FileBasedPersisterCore core) {
        this.core = core;
    }

    protected static <T> boolean writeIfChanged(ObjectMapper mapper, File f, T newThing) throws StoreException.TestUpdateException {
        if (f.exists()) {
            try {
                Object currentThing = mapper.readValue(f, newThing.getClass());
                if (currentThing.equals(newThing)) {
                    return false;
                }
            }
            catch (JsonParseException e) {
                throw new StoreException.TestUpdateException("Unable to parse instance of " + newThing.getClass().getCanonicalName() + " from " + f, e);
            }
            catch (JsonMappingException e) {
                throw new StoreException.TestUpdateException("Unable to parse instance of " + newThing.getClass().getCanonicalName() + " from " + f, e);
            }
            catch (IOException e) {
                throw new StoreException.TestUpdateException("Unable to parse instance of " + newThing.getClass().getCanonicalName() + " from " + f, e);
            }
        }
        FileBasedProctorStore.writeThing(mapper, f, newThing);
        return true;
    }

    protected static <T> void writeThing(ObjectMapper mapper, File f, T newThing) throws StoreException.TestUpdateException {
        try {
            mapper.defaultPrettyPrintingWriter().writeValue(f, newThing);
        }
        catch (JsonGenerationException e) {
            throw new StoreException.TestUpdateException("Unable to write instance of " + newThing.getClass().getCanonicalName() + " to " + f, e);
        }
        catch (JsonMappingException e) {
            throw new StoreException.TestUpdateException("Unable to write instance of " + newThing.getClass().getCanonicalName() + " to " + f, e);
        }
        catch (IOException e) {
            throw new StoreException.TestUpdateException("Unable to write instance of " + newThing.getClass().getCanonicalName() + " to " + f, e);
        }
    }

    static File getTestDefinitionDirectory(String testName, File workingDir) {
        return new File(workingDir + File.separator + TEST_DEFINITIONS_DIRECTORY + File.separator + testName);
    }

    @Override
    public TestMatrixVersion getCurrentTestMatrix() throws StoreException {
        return this.getTestMatrix(this.getLatestVersion());
    }

    @Export(name="core", doc="")
    public FileBasedPersisterCore getCore() {
        return this.core;
    }

    @Override
    public final TestMatrixVersion getTestMatrix(String fetchRevision) throws StoreException {
        long start = System.currentTimeMillis();
        TestVersionResult result = this.core.determineVersions(fetchRevision);
        if (LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug((Object)String.format("Took %d ms to identify %d potential tests", elapsed, result.getTests().size()));
        }
        if (result == null) {
            LOGGER.error((Object)("Unable to determine tests for " + this.core.toString()));
            return null;
        }
        TestMatrixVersion tmv = new TestMatrixVersion();
        LinkedHashMap testDefinitions = Maps.newLinkedHashMap();
        start = System.currentTimeMillis();
        for (TestVersionResult.Test testDefFile : result.getTests()) {
            long startForTest = System.currentTimeMillis();
            TestDefinition testDefinition = this.getTestDefinition(testDefFile.getTestName(), testDefFile.getRevision());
            if (LOGGER.isTraceEnabled()) {
                long elapsed = System.currentTimeMillis() - startForTest;
                LOGGER.debug((Object)String.format("Took %d ms to load %s (r%s) %s", elapsed, testDefFile.getTestName(), testDefFile.getRevision(), testDefinition == null ? "unsuccessfully" : "successfully"));
            }
            if (testDefinition == null) {
                LOGGER.info((Object)("Returning null TestMatrix because " + testDefFile.getTestName() + " returned null test-definition."));
                return null;
            }
            testDefinitions.put(testDefFile.getTestName(), testDefinition);
        }
        if (LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug((Object)String.format("Took %d ms to load all %d tests", elapsed, testDefinitions.size()));
        }
        TestMatrixDefinition tmd = new TestMatrixDefinition();
        tmd.setTests((Map)testDefinitions);
        tmv.setTestMatrixDefinition(tmd);
        tmv.setPublished(result.getPublished());
        tmv.setAuthor(result.getAuthor());
        tmv.setVersion(result.getVersion());
        tmv.setDescription(result.getDescription());
        return tmv;
    }

    @Override
    public TestDefinition getCurrentTestDefinition(String testName) throws StoreException {
        List<Revision> tdvList = this.getHistory(testName, 0, 1);
        if (tdvList.size() == 1) {
            Revision tdv = tdvList.get(0);
            return this.getTestDefinition(testName, tdv.getRevision());
        }
        LOGGER.info((Object)("Not history returned for " + testName + ", returning null"));
        return null;
    }

    @Override
    public TestDefinition getTestDefinition(String testName, String fetchRevision) throws StoreException {
        try {
            return this.getFileContents(TestDefinition.class, new String[]{TEST_DEFINITIONS_DIRECTORY, testName, TEST_DEFINITION_FILENAME}, null, fetchRevision);
        }
        catch (JsonProcessingException e) {
            throw new StoreException(String.format("Unable to deserialize JSON for %s r%s", testName, fetchRevision), e);
        }
        catch (StoreException.ReadException e) {
            throw e;
        }
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Ignored exception during closing", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    private final <C> C getFileContents(Class<C> c, String[] path, C defaultValue, String revision) throws StoreException.ReadException, JsonProcessingException {
        return this.core.getFileContents(c, path, defaultValue, revision);
    }

    protected final <T> boolean updateThing(RcsClient rcsClient, File file, T thing) throws Exception {
        boolean thingExisted = file.exists();
        boolean thingChanged = FileBasedProctorStore.writeIfChanged(this.objectMapper, file, thing);
        if (!thingExisted || rcsClient.getRevisionControlType().equals("git")) {
            rcsClient.add(file);
        }
        return thingChanged;
    }

    @Override
    public final void updateTestDefinition(String username, String password, String previousVersion, final String testName, final TestDefinition testDefinition, final Map<String, String> metadata, String comment) throws StoreException.TestUpdateException {
        LOGGER.info((Object)String.format("Update Test Definition: %s %s r%s", username, testName, previousVersion));
        this.core.doInWorkingDirectory(username, password, comment, previousVersion, new ProctorUpdater(){

            @Override
            public boolean doInWorkingDirectory(RcsClient rcsClient, File workingDir) throws Exception {
                File testDefinitionDirectory = FileBasedProctorStore.getTestDefinitionDirectory(testName, workingDir);
                File testDefinitionFile = new File(testDefinitionDirectory + File.separator + FileBasedProctorStore.TEST_DEFINITION_FILENAME);
                File metaDataFile = new File(testDefinitionDirectory + File.separator + FileBasedProctorStore.TEST_METADATA_FILENAME);
                if (!testDefinitionFile.exists()) {
                    throw new StoreException.TestUpdateException("Attempting to update non-existent test " + testName);
                }
                boolean thingsChanged = FileBasedProctorStore.this.updateThing(rcsClient, testDefinitionFile, testDefinition);
                thingsChanged = FileBasedProctorStore.this.updateThing(rcsClient, metaDataFile, metadata) || thingsChanged;
                return thingsChanged;
            }
        });
    }

    @Override
    public final void addTestDefinition(String username, String password, final String testName, final TestDefinition testDefinition, final Map<String, String> metadata, String comment) throws StoreException.TestUpdateException {
        LOGGER.info((Object)String.format("Add Test Definition: %s %s", username, testName));
        this.core.doInWorkingDirectory(username, password, comment, this.core.getAddTestRevision(), new ProctorUpdater(){

            @Override
            public boolean doInWorkingDirectory(RcsClient rcsClient, File workingDir) throws Exception {
                File testDefinitionDirectory = FileBasedProctorStore.getTestDefinitionDirectory(testName, workingDir);
                File testDefinitionFile = new File(testDefinitionDirectory + File.separator + FileBasedProctorStore.TEST_DEFINITION_FILENAME);
                File metaDataFile = new File(testDefinitionDirectory + File.separator + FileBasedProctorStore.TEST_METADATA_FILENAME);
                if (testDefinitionFile.exists() || metaDataFile.exists()) {
                    throw new StoreException.TestUpdateException("Supposedly new test '" + testName + "' already exists");
                }
                testDefinitionDirectory.mkdirs();
                FileBasedProctorStore.writeThing(FileBasedProctorStore.this.objectMapper, testDefinitionFile, testDefinition);
                rcsClient.add(testDefinitionFile);
                FileBasedProctorStore.writeThing(FileBasedProctorStore.this.objectMapper, metaDataFile, metadata);
                rcsClient.add(metaDataFile);
                return true;
            }
        });
    }

    @Override
    public final void deleteTestDefinition(String username, String password, String previousVersion, final String testName, TestDefinition testDefinition, String comment) throws StoreException.TestUpdateException {
        LOGGER.info((Object)String.format("Delete Test Definition: %s %s r%s ", username, testName, previousVersion));
        this.core.doInWorkingDirectory(username, password, comment, previousVersion, new ProctorUpdater(){

            @Override
            public boolean doInWorkingDirectory(RcsClient rcsClient, File workingDir) throws Exception {
                File testDefinitionDirectory = FileBasedProctorStore.getTestDefinitionDirectory(testName, workingDir);
                if (!testDefinitionDirectory.exists()) {
                    throw new StoreException.TestUpdateException("Unable to delete non-existent test " + testName);
                }
                rcsClient.delete(testDefinitionDirectory);
                return true;
            }
        });
    }

    public static interface RcsClient {
        public void add(File var1) throws Exception;

        public void delete(File var1) throws Exception;

        public String getRevisionControlType();
    }

    public static interface ProctorUpdater {
        public boolean doInWorkingDirectory(RcsClient var1, File var2) throws Exception;
    }
}

