/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.store.FileBasedPersisterCore;
import com.indeed.proctor.store.FileBasedProctorStore;
import com.indeed.proctor.store.StoreException;
import com.indeed.proctor.store.TestVersionResult;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;

public class LocalDirectoryCore
implements FileBasedPersisterCore {
    private static final Logger LOGGER = Logger.getLogger(LocalDirectoryCore.class);
    private final ObjectMapper objectMapper = Serializers.strict();
    private final File baseDir;
    private final String testDefinitionsDirectory;

    public LocalDirectoryCore(File baseDir, String testDefinitionsDirectory) {
        this.baseDir = baseDir;
        this.testDefinitionsDirectory = testDefinitionsDirectory;
    }

    @Override
    public <C> C getFileContents(Class<C> c, String[] path_parts, C defaultValue, String revision) throws StoreException.ReadException, JsonProcessingException {
        String path = Joiner.on((String)File.separator).join((Object[])path_parts);
        InputStreamReader reader = null;
        try {
            File file = new File(this.baseDir + File.separator + path);
            if (file.exists()) {
                Object testDefinition;
                reader = new FileReader(file);
                Object object = testDefinition = this.objectMapper.readValue((Reader)reader, c);
                return (C)object;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(file + " does not exists, returning defaultValue."));
            }
            C c2 = defaultValue;
            return c2;
        }
        catch (IOException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, JsonProcessingException.class);
            throw new StoreException.ReadException("Error reading " + path, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Suppressing throwable thrown when closing " + reader), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void doInWorkingDirectory(String username, String password, String comment, String previousVersion, FileBasedProctorStore.ProctorUpdater updater) throws StoreException.TestUpdateException {
        try {
            LocalRcsClient rcsClient = new LocalRcsClient();
            boolean thingsChanged = updater.doInWorkingDirectory(rcsClient, this.baseDir);
        }
        catch (Exception e) {
            throw new StoreException.TestUpdateException("Unable to perform operation", e);
        }
    }

    @Override
    public TestVersionResult determineVersions(String fetchRevision) throws StoreException.ReadException {
        File testDir = new File(this.baseDir + File.separator + this.testDefinitionsDirectory);
        File[] testDefFiles = testDir.listFiles((FileFilter)FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.directoryFileFilter()));
        ArrayList tests = Lists.newArrayListWithExpectedSize((int)testDefFiles.length);
        for (File testDefFile : testDefFiles) {
            String testName = testDefFile.getName();
            tests.add(new TestVersionResult.Test(testName, fetchRevision));
        }
        return new TestVersionResult(tests, new Date(System.currentTimeMillis()), System.getenv("USER"), String.valueOf(System.currentTimeMillis()), "");
    }

    @Override
    public String getAddTestRevision() {
        return "";
    }

    static class LocalRcsClient
    implements FileBasedProctorStore.RcsClient {
        LocalRcsClient() {
        }

        @Override
        public void add(File file) throws Exception {
        }

        @Override
        public void delete(File testDefinitionDirectory) throws Exception {
            testDefinitionDirectory.delete();
        }

        @Override
        public String getRevisionControlType() {
            return null;
        }
    }
}

