/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.store.ProctorStore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.StoreException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class CachingProctorStore
implements ProctorStore {
    private static final Logger LOGGER = Logger.getLogger(CachingProctorStore.class);
    private static final long REFRESH_RATE_IN_SECOND = 10L;
    private static final long READ_TIMEOUT_IN_SECOND = 30L;
    private static final long WRITE_TIMEOUT_IN_SECOND = 180L;
    private final ProctorStore delegate;
    private final CacheHolder cacheHolder;

    public CachingProctorStore(ProctorStore delegate) {
        this.delegate = delegate;
        this.cacheHolder = new CacheHolder();
        try {
            this.cacheHolder.start();
        }
        catch (StoreException e) {
            LOGGER.error((Object)"Failed to initialize CachingProctorStore", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public TestMatrixVersion getCurrentTestMatrix() throws StoreException {
        return this.cacheHolder.getCachedCurrentTestMatrix();
    }

    @Override
    public TestDefinition getCurrentTestDefinition(String test) throws StoreException {
        TestMatrixDefinition testMatrixDefinition = this.cacheHolder.getCachedCurrentTestMatrix().getTestMatrixDefinition();
        Preconditions.checkNotNull((Object)testMatrixDefinition, (Object)"TestMatrix should contain non null TestMatrixDefinition");
        return (TestDefinition)testMatrixDefinition.getTests().get(test);
    }

    @Override
    public void verifySetup() throws StoreException {
        this.delegate.verifySetup();
    }

    @Override
    public String getLatestVersion() throws StoreException {
        return this.cacheHolder.getCachedLatestVersion();
    }

    @Override
    public TestMatrixVersion getTestMatrix(String fetchRevision) throws StoreException {
        return this.cacheHolder.getCachedTestMatrix(fetchRevision);
    }

    @Override
    public TestDefinition getTestDefinition(String test, String fetchRevision) throws StoreException {
        if (!this.cacheHolder.getCachedHistory().containsKey(test)) {
            LOGGER.info((Object)String.format("Test {%s} doesn't exist", test));
            return null;
        }
        TestMatrixVersion version = this.cacheHolder.getCachedTestMatrix(fetchRevision);
        if (version == null) {
            LOGGER.info((Object)String.format("Fetch revision {%s} doesn't exists", fetchRevision));
            return null;
        }
        TestMatrixDefinition testMatrixDefinition = version.getTestMatrixDefinition();
        if (testMatrixDefinition == null) {
            LOGGER.info((Object)String.format("Fetch revision {%s} doesn't contain any test", fetchRevision));
            return null;
        }
        TestDefinition testDefinition = (TestDefinition)testMatrixDefinition.getTests().get(test);
        if (testDefinition == null) {
            LOGGER.info((Object)String.format("Fetch revision {%s} doesn't contain test {%s}", fetchRevision, test));
        }
        return testDefinition;
    }

    @Override
    public List<Revision> getMatrixHistory(int start, int limit) throws StoreException {
        return this.delegate.getMatrixHistory(start, limit);
    }

    @Override
    public List<Revision> getHistory(String test, int start, int limit) throws StoreException {
        return CachingProctorStore.selectHistorySet(this.cacheHolder.getCachedHistory().get(test), start, limit);
    }

    @Override
    public List<Revision> getHistory(String test, String revision, int start, int limit) throws StoreException {
        return CachingProctorStore.selectRevisionHistorySetFrom(this.cacheHolder.getCachedHistory().get(test), revision, start, limit);
    }

    @Override
    public Map<String, List<Revision>> getAllHistories() throws StoreException {
        return this.cacheHolder.getCachedHistory();
    }

    @Override
    public void refresh() throws StoreException {
        this.cacheHolder.refreshAll();
    }

    @VisibleForTesting
    public static <T> List<T> selectHistorySet(List<T> histories, int start, int limit) {
        if (histories == null || start >= histories.size() || limit < 1) {
            return Collections.emptyList();
        }
        int s = Math.max(start, 0);
        int l = Math.min(limit, histories.size() - s);
        return histories.subList(s, s + l);
    }

    @VisibleForTesting
    public static List<Revision> selectRevisionHistorySetFrom(List<Revision> history, String from, int start, int limit) {
        int i = 0;
        for (Revision rev : history) {
            if (rev.getRevision().equals(from)) break;
            ++i;
        }
        return CachingProctorStore.selectHistorySet(history, start + i, limit);
    }

    @Override
    public boolean cleanUserWorkspace(String username) {
        return this.delegate.cleanUserWorkspace(username);
    }

    @Override
    public void updateTestDefinition(String username, String password, String previousVersion, String testName, TestDefinition testDefinition, Map<String, String> metadata, String comment) throws StoreException.TestUpdateException {
        this.delegate.updateTestDefinition(username, password, previousVersion, testName, testDefinition, metadata, comment);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public void deleteTestDefinition(String username, String password, String previousVersion, String testName, TestDefinition testDefinition, String comment) throws StoreException.TestUpdateException {
        this.delegate.deleteTestDefinition(username, password, previousVersion, testName, testDefinition, comment);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public void addTestDefinition(String username, String password, String testName, TestDefinition testDefinition, Map<String, String> metadata, String comment) throws StoreException.TestUpdateException {
        this.delegate.addTestDefinition(username, password, testName, testDefinition, metadata, comment);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @VisibleForTesting
    ScheduledFuture<?> getRefreshTaskFuture() {
        return this.cacheHolder.scheduledFuture;
    }

    class CacheHolder {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final Lock readLock = this.readWriteLock.readLock();
        private final Lock writeLock = this.readWriteLock.writeLock();
        private TestMatrixVersion cachedLatestTestMatrixVersion;
        private Map<String, List<Revision>> historyCache;
        private final Cache<String, TestMatrixVersion> revisionCache = CacheBuilder.newBuilder().maximumSize(5L).build();
        private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        private ScheduledFuture<?> scheduledFuture;
        final Runnable refreshCacheTask = new Runnable(){

            @Override
            public void run() {
                try {
                    CacheHolder.this.refreshAll();
                }
                catch (StoreException e) {
                    LOGGER.error((Object)"Failed to update cache", (Throwable)e);
                }
            }
        };

        CacheHolder() {
        }

        @Nonnull
        public Map<String, List<Revision>> getCachedHistory() throws StoreException {
            return this.synchronizedCacheRead(new Callable<Map<String, List<Revision>>>(){

                @Override
                public Map<String, List<Revision>> call() {
                    return CacheHolder.this.historyCache;
                }
            });
        }

        @Nonnull
        public String getCachedLatestVersion() throws StoreException {
            return this.synchronizedCacheRead(new Callable<String>(){

                @Override
                public String call() {
                    return CacheHolder.this.cachedLatestTestMatrixVersion.getVersion();
                }
            });
        }

        public TestMatrixVersion getCachedTestMatrix(final String fetchRevision) throws StoreException {
            return this.synchronizedCacheRead(new Callable<TestMatrixVersion>(){

                @Override
                public TestMatrixVersion call() throws StoreException {
                    TestMatrixVersion testMatrix = (TestMatrixVersion)CacheHolder.this.revisionCache.getIfPresent((Object)fetchRevision);
                    if (testMatrix == null) {
                        LOGGER.debug((Object)("Cache miss for fetch revision: " + fetchRevision));
                        testMatrix = CachingProctorStore.this.delegate.getTestMatrix(fetchRevision);
                        CacheHolder.this.revisionCache.put((Object)fetchRevision, (Object)testMatrix);
                    }
                    return testMatrix;
                }
            });
        }

        public TestMatrixVersion getCachedCurrentTestMatrix() throws StoreException {
            return this.synchronizedCacheRead(new Callable<TestMatrixVersion>(){

                @Override
                public TestMatrixVersion call() throws StoreException {
                    return CacheHolder.this.cachedLatestTestMatrixVersion;
                }
            });
        }

        private boolean hasNewVersion() throws StoreException {
            String newVersion = CachingProctorStore.this.delegate.getLatestVersion();
            return !newVersion.equals(this.getCachedLatestVersion());
        }

        public void refreshAll() throws StoreException {
            CachingProctorStore.this.delegate.refresh();
            if (this.hasNewVersion()) {
                this.lockAndRefreshCache();
            } else {
                LOGGER.debug((Object)String.format("[%s] Latest version is not changed. Do not refresh cache", CachingProctorStore.this.delegate.getName()));
            }
        }

        private void lockAndRefreshCache() throws StoreException {
            LOGGER.debug((Object)String.format("[%s] Refreshing cache data started", CachingProctorStore.this.delegate.getName()));
            this.synchronizedCacheWrite(new Callable<Void>(){

                @Override
                public Void call() throws StoreException {
                    TestMatrixVersion currentTestMatrix = CachingProctorStore.this.delegate.getCurrentTestMatrix();
                    Revision revision = CachingProctorStore.this.delegate.getMatrixHistory(0, 1).get(0);
                    Map<String, List<Revision>> allHistories = CachingProctorStore.this.delegate.getAllHistories();
                    CacheHolder.this.revisionCache.put((Object)revision.getRevision(), (Object)currentTestMatrix);
                    CacheHolder.this.cachedLatestTestMatrixVersion = currentTestMatrix;
                    CacheHolder.this.historyCache = allHistories;
                    return null;
                }
            });
            LOGGER.debug((Object)String.format("[%s] Refreshing cache data finished", CachingProctorStore.this.delegate.getName()));
        }

        public void start() throws StoreException {
            LOGGER.info((Object)String.format("[%s] Starting Caching for ProctorStore ", CachingProctorStore.this.delegate.getName()));
            this.lockAndRefreshCache();
            this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.refreshCacheTask, 10L, 10L, TimeUnit.SECONDS);
        }

        public void startRefreshCacheTask() {
            LOGGER.info((Object)String.format("[%s] Rescheduling UpdateCacheTask due to new updates.", CachingProctorStore.this.delegate.getName()));
            this.scheduledFuture.cancel(false);
            try {
                this.lockAndRefreshCache();
            }
            catch (StoreException e) {
                LOGGER.error((Object)"failed to update the cache");
            }
            this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.refreshCacheTask, 10L, 10L, TimeUnit.SECONDS);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T synchronizedCacheRead(Callable<T> callable) throws StoreException {
            try {
                if (!this.readLock.tryLock(30L, TimeUnit.SECONDS)) throw new StoreException("Failed to acquire the lock. Timeout after 30");
                try {
                    T t = callable.call();
                    return t;
                }
                catch (Exception e) {
                    throw new StoreException("Failed to perform read operation to cache. ", e);
                }
                finally {
                    this.readLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StoreException("Read operation to cache was interrupted", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T synchronizedCacheWrite(Callable<T> callable) throws StoreException {
            try {
                if (!this.writeLock.tryLock(180L, TimeUnit.SECONDS)) throw new StoreException.TestUpdateException("Failed to acquire the lock. Timeout after 180");
                try {
                    T t = callable.call();
                    return t;
                }
                catch (Exception e) {
                    throw new StoreException.TestUpdateException("Failed to perform write operation to cache. ", e);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StoreException.TestUpdateException("Write operation to cache was interrupted", e);
            }
        }
    }
}

