/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import com.indeed.proctor.store.FileBasedProctorStore;
import com.indeed.proctor.store.LocalDirectoryCore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.RevisionDetails;
import com.indeed.proctor.store.StoreException;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class LocalDirectoryStore
extends FileBasedProctorStore {
    private final File baseDir;

    public LocalDirectoryStore(File baseDir) {
        this(baseDir, "test-definitions");
    }

    public LocalDirectoryStore(File baseDir, String testDefinitionsDirectory) {
        super(new LocalDirectoryCore(baseDir, testDefinitionsDirectory));
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("Base dir " + baseDir + " is not a directory");
        }
        this.baseDir = baseDir;
    }

    @Override
    @Nonnull
    public String getLatestVersion() throws StoreException {
        return "";
    }

    @Override
    public boolean cleanUserWorkspace(String username) {
        return true;
    }

    @Override
    @Nonnull
    public List<Revision> getHistory(String test, int ignoredStart, int limit) throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    @Nonnull
    public List<Revision> getHistory(String test, String revision, int start, int limit) throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    @CheckForNull
    public RevisionDetails getRevisionDetails(String revisionId) throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    @Nonnull
    public List<Revision> getMatrixHistory(int start, int limit) throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    @Nonnull
    public List<Revision> getMatrixHistory(Instant sinceInclusive, Instant untilExclusive) throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    @Nonnull
    public Map<String, List<Revision>> getAllHistories() throws StoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void refresh() throws StoreException {
    }

    @Override
    public void verifySetup() throws StoreException {
        if (!this.baseDir.isDirectory()) {
            throw new RuntimeException("Base dir (" + this.baseDir.getPath() + ") is not a directory.");
        }
        if (!this.baseDir.canRead()) {
            throw new RuntimeException("Cannot read from " + this.baseDir.getPath());
        }
        if (!this.baseDir.canWrite()) {
            throw new RuntimeException("Cannot write to " + this.baseDir.getPath());
        }
    }

    public String toString() {
        return this.baseDir.getAbsolutePath();
    }

    @Override
    public String getName() {
        return "";
    }
}

