/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store.utils.test;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.store.ChangeMetadata;
import com.indeed.proctor.store.ProctorStore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.RevisionDetails;
import com.indeed.proctor.store.StoreException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InMemoryProctorStore
implements ProctorStore {
    private final List<UpdateRecord> globalHistory = new LinkedList<UpdateRecord>();
    private final Supplier<String> revisionIdGenerator;
    private static final ChangeMetadata INITIAL_CHANGE_METADATA = ChangeMetadata.builder().setUsernameAndAuthor("proctor").setPassword("password").setTimestamp(Instant.EPOCH).setComment("initialize in-memory store").build();

    public static Supplier<String> autoincrementRevisionIdGenerator() {
        AtomicLong atomicLong = new AtomicLong(0L);
        return () -> Long.toString(atomicLong.getAndIncrement());
    }

    public InMemoryProctorStore() {
        this(InMemoryProctorStore.autoincrementRevisionIdGenerator());
    }

    public InMemoryProctorStore(Supplier<String> revisionIdGenerator) {
        this.revisionIdGenerator = revisionIdGenerator;
        this.insertNewRecord(INITIAL_CHANGE_METADATA, null);
    }

    @Override
    public String getName() {
        return InMemoryProctorStore.class.getSimpleName();
    }

    @Override
    @Nonnull
    public synchronized String getLatestVersion() {
        return this.globalHistory.get(0).revision.getRevision();
    }

    @Override
    public synchronized TestMatrixVersion getTestMatrix(String revisionId) throws StoreException {
        Map<String, Optional> allTests = this.getHistoryFromRevision(revisionId).filter(r -> ((UpdateRecord)r).testEdit != null).collect(Collectors.toMap(r -> ((UpdateRecord)r).testEdit.testName, r -> Optional.ofNullable(((UpdateRecord)r).testEdit.definition), (a, b) -> a));
        Revision revision = this.getUpdateRecord(revisionId).revision;
        return new TestMatrixVersion(new TestMatrixDefinition(Maps.filterValues((Map)Maps.transformValues(allTests, x -> x.orElse(null)), Objects::nonNull)), revision.getDate(), revision.getRevision(), revision.getMessage(), revision.getAuthor());
    }

    @Override
    @CheckForNull
    public synchronized TestDefinition getTestDefinition(String testName, String revisionId) throws StoreException {
        return this.getHistoryFromRevision(revisionId).filter(r -> ((UpdateRecord)r).modifiedTests().contains(testName)).findFirst().map(r -> Objects.requireNonNull(((UpdateRecord)r).testEdit)).map(t -> ((TestEdit)t).definition).orElse(null);
    }

    @Override
    @Nonnull
    public synchronized List<Revision> getMatrixHistory(int start, int limit) {
        return this.globalHistory.stream().map(r -> ((UpdateRecord)r).revision).skip(start).limit(limit).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public synchronized List<Revision> getMatrixHistory(Instant sinceInclusive, Instant untilExclusive) {
        return this.globalHistory.stream().map(r -> ((UpdateRecord)r).revision).filter(r -> !r.getDate().toInstant().isBefore(sinceInclusive) && r.getDate().toInstant().isBefore(untilExclusive)).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public synchronized List<Revision> getHistory(String testName, String revisionId, int start, int limit) throws StoreException {
        return this.getHistoryFromRevision(revisionId).filter(r -> ((UpdateRecord)r).modifiedTests().contains(testName)).map(r -> ((UpdateRecord)r).revision).skip(start).limit(limit).collect(Collectors.toList());
    }

    @Override
    @CheckForNull
    public synchronized RevisionDetails getRevisionDetails(String revisionId) throws StoreException {
        return this.getUpdateRecord(revisionId).toRevisionDetails();
    }

    @Override
    @Nonnull
    public synchronized Map<String, List<Revision>> getAllHistories() {
        return this.globalHistory.stream().filter(r -> ((UpdateRecord)r).testEdit != null).collect(Collectors.groupingBy(r -> ((UpdateRecord)r).testEdit.testName, Collectors.mapping(r -> ((UpdateRecord)r).revision, Collectors.toList())));
    }

    @Override
    public synchronized TestMatrixVersion getCurrentTestMatrix() throws StoreException {
        return this.getTestMatrix(this.getLatestVersion());
    }

    @Override
    @CheckForNull
    public synchronized TestDefinition getCurrentTestDefinition(String testName) throws StoreException {
        return this.getTestDefinition(testName, this.getLatestVersion());
    }

    @Override
    @Nonnull
    public synchronized List<Revision> getHistory(String testName, int start, int limit) throws StoreException {
        return this.getHistory(testName, this.getLatestVersion(), start, limit);
    }

    @Override
    public synchronized void addTestDefinition(ChangeMetadata changeMetadata, String testName, TestDefinition testDefinition, Map<String, String> metadata) throws StoreException.TestUpdateException {
        if (this.getLatestUpdate(testName).isPresent()) {
            throw new StoreException.TestUpdateException(testName + " has been added before");
        }
        this.insertNewRecord(changeMetadata, new TestEdit(testName, testDefinition));
    }

    @Override
    public synchronized void updateTestDefinition(ChangeMetadata changeMetadata, String previousVersion, String testName, TestDefinition testDefinition, Map<String, String> metadata) throws StoreException.TestUpdateException {
        UpdateRecord lastUpdate = this.getLatestUpdate(testName).orElseThrow(() -> new StoreException.TestUpdateException(testName + " not yet added"));
        if (lastUpdate.testEdit.definition == null) {
            throw new StoreException.TestUpdateException(testName + " already deleted");
        }
        if (!previousVersion.equals(lastUpdate.revision.getRevision())) {
            throw new StoreException.TestUpdateException("Expected previous version is " + lastUpdate.revision.getRevision() + " but " + previousVersion);
        }
        if (testDefinition.equals((Object)lastUpdate.testEdit.definition)) {
            throw new StoreException.TestUpdateException("Attempting to save test definition without changes for test: " + testName);
        }
        this.insertNewRecord(changeMetadata, new TestEdit(testName, testDefinition));
    }

    @Override
    public synchronized void deleteTestDefinition(ChangeMetadata changeMetadata, String previousVersion, String testName, TestDefinition testDefinition) throws StoreException.TestUpdateException {
        UpdateRecord lastUpdate = this.getLatestUpdate(testName).orElseThrow(() -> new StoreException.TestUpdateException(testName + " not yet added"));
        if (lastUpdate.testEdit.definition == null) {
            throw new StoreException.TestUpdateException(testName + " already deleted");
        }
        if (!previousVersion.equals(lastUpdate.revision.getRevision())) {
            throw new StoreException.TestUpdateException("Expected previous version is " + lastUpdate.revision.getRevision() + " but " + previousVersion);
        }
        this.insertNewRecord(changeMetadata, new TestEdit(testName, null));
    }

    @Override
    public boolean cleanUserWorkspace(String username) {
        return false;
    }

    @Override
    public void verifySetup() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
    }

    private void insertNewRecord(ChangeMetadata changeMetadata, @Nullable TestEdit testEdit) {
        this.globalHistory.add(0, new UpdateRecord(new Revision(this.revisionIdGenerator.get(), changeMetadata.getAuthor(), Date.from(changeMetadata.getTimestamp()), changeMetadata.getComment()), testEdit));
    }

    private UpdateRecord getUpdateRecord(String revisionId) throws StoreException {
        return this.globalHistory.stream().filter(x -> ((UpdateRecord)x).revision.getRevision().equals(revisionId)).findFirst().orElseThrow(() -> new StoreException("Unknown revision " + revisionId));
    }

    private Optional<UpdateRecord> getLatestUpdate(String testName) {
        return this.globalHistory.stream().filter(x -> ((UpdateRecord)x).modifiedTests().contains(testName)).findFirst();
    }

    private Stream<UpdateRecord> getHistoryFromRevision(String revisionId) throws StoreException {
        UpdateRecord startRecord = this.getUpdateRecord(revisionId);
        return this.globalHistory.subList(this.globalHistory.indexOf(startRecord), this.globalHistory.size()).stream();
    }

    private static class TestEdit {
        private final String testName;
        @Nullable
        private final TestDefinition definition;

        private TestEdit(String testName, @Nullable TestDefinition definition) {
            this.testName = Objects.requireNonNull(testName);
            this.definition = definition;
        }
    }

    private static class UpdateRecord {
        private final Revision revision;
        @Nullable
        private final TestEdit testEdit;

        private UpdateRecord(Revision revision, @Nullable TestEdit testEdit) {
            this.revision = Objects.requireNonNull(revision);
            this.testEdit = testEdit;
        }

        private RevisionDetails toRevisionDetails() {
            return new RevisionDetails(this.revision, this.modifiedTests());
        }

        private Set<String> modifiedTests() {
            return this.testEdit == null ? Collections.emptySet() : Collections.singleton(this.testEdit.testName);
        }
    }
}

