/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestMatrixDefinition;
import com.indeed.proctor.common.model.TestMatrixVersion;
import com.indeed.proctor.store.ChangeMetadata;
import com.indeed.proctor.store.ProctorStore;
import com.indeed.proctor.store.Revision;
import com.indeed.proctor.store.RevisionDetails;
import com.indeed.proctor.store.StoreException;
import com.indeed.proctor.store.TestEdit;
import com.indeed.proctor.store.utils.HistoryUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class CachingProctorStore
implements ProctorStore {
    private static final Logger LOGGER = Logger.getLogger(CachingProctorStore.class);
    private static final long REFRESH_RATE_IN_SECOND = 15L;
    private static final long READ_TIMEOUT_IN_SECOND = 30L;
    private static final long WRITE_TIMEOUT_IN_SECOND = 180L;
    private final ProctorStore delegate;
    private final CacheHolder cacheHolder;

    public CachingProctorStore(ProctorStore delegate) {
        this.delegate = delegate;
        this.cacheHolder = new CacheHolder();
        try {
            this.cacheHolder.start();
        }
        catch (StoreException e) {
            LOGGER.error((Object)"Failed to initialize CachingProctorStore", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public TestMatrixVersion getCurrentTestMatrix() throws StoreException {
        return this.cacheHolder.getCachedCurrentTestMatrix();
    }

    @Override
    public TestDefinition getCurrentTestDefinition(String test) throws StoreException {
        TestMatrixDefinition testMatrixDefinition = this.cacheHolder.getCachedCurrentTestMatrix().getTestMatrixDefinition();
        Preconditions.checkNotNull((Object)testMatrixDefinition, (Object)"TestMatrix should contain non null TestMatrixDefinition");
        return (TestDefinition)testMatrixDefinition.getTests().get(test);
    }

    @Override
    public void verifySetup() throws StoreException {
        this.delegate.verifySetup();
    }

    @Override
    @Nonnull
    public String getLatestVersion() throws StoreException {
        return this.cacheHolder.getCachedLatestVersion();
    }

    @Override
    public TestMatrixVersion getTestMatrix(String fetchRevision) throws StoreException {
        return this.cacheHolder.getCachedTestMatrix(fetchRevision);
    }

    @Override
    public TestDefinition getTestDefinition(String test, String fetchRevision) throws StoreException {
        if (!this.cacheHolder.getCachedHistory().containsKey(test)) {
            LOGGER.info((Object)String.format("Test {%s} doesn't exist", test));
            return null;
        }
        if (this.isChangedRevision(test, fetchRevision)) {
            return this.cacheHolder.getCachedTestDefinition(test, fetchRevision);
        }
        return this.delegate.getTestDefinition(test, fetchRevision);
    }

    @Override
    @Nonnull
    public List<Revision> getMatrixHistory(int start, int limit) throws StoreException {
        return this.delegate.getMatrixHistory(start, limit);
    }

    @Override
    @Nonnull
    public List<Revision> getMatrixHistory(Instant start, Instant limit) throws StoreException {
        return this.delegate.getMatrixHistory(start, limit);
    }

    @Override
    @Nonnull
    public List<Revision> getHistory(String test, int start, int limit) throws StoreException {
        return HistoryUtil.selectHistorySet(this.cacheHolder.getCachedHistory().get(test), start, limit);
    }

    @Override
    @Nonnull
    public List<Revision> getHistory(String test, String revision, int start, int limit) throws StoreException {
        return HistoryUtil.selectRevisionHistorySetFrom(this.cacheHolder.getCachedHistory().get(test), revision, start, limit);
    }

    @Override
    @CheckForNull
    public RevisionDetails getRevisionDetails(String revisionId) throws StoreException {
        return this.delegate.getRevisionDetails(revisionId);
    }

    @Override
    @Nonnull
    public List<TestEdit> getTestEdits(String testName, int start, int limit) throws StoreException {
        return this.delegate.getTestEdits(testName, start, limit);
    }

    @Override
    @Nonnull
    public List<TestEdit> getTestEdits(String testName, String revision, int start, int limit) throws StoreException {
        return this.delegate.getTestEdits(testName, revision, start, limit);
    }

    @Override
    @Nonnull
    public Map<String, List<Revision>> getAllHistories() throws StoreException {
        return this.cacheHolder.getCachedHistory();
    }

    @Override
    public void refresh() throws StoreException {
        this.cacheHolder.refreshAll();
    }

    @Deprecated
    public static <T> List<T> selectHistorySet(List<T> histories, int start, int limit) {
        return HistoryUtil.selectHistorySet(histories, start, limit);
    }

    @Deprecated
    public static List<Revision> selectRevisionHistorySetFrom(List<Revision> history, String from, int start, int limit) {
        return HistoryUtil.selectRevisionHistorySetFrom(history, from, start, limit);
    }

    @Override
    public boolean cleanUserWorkspace(String username) {
        return this.delegate.cleanUserWorkspace(username);
    }

    @Override
    public void updateTestDefinition(ChangeMetadata changeMetadata, String previousVersion, String testName, TestDefinition testDefinition, Map<String, String> metadata) throws StoreException.TestUpdateException {
        this.delegate.updateTestDefinition(changeMetadata, previousVersion, testName, testDefinition, metadata);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public void deleteTestDefinition(ChangeMetadata changeMetadata, String previousVersion, String testName, TestDefinition testDefinition) throws StoreException.TestUpdateException {
        this.delegate.deleteTestDefinition(changeMetadata, previousVersion, testName, testDefinition);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public void addTestDefinition(ChangeMetadata changeMetadata, String testName, TestDefinition testDefinition, Map<String, String> metadata) throws StoreException.TestUpdateException {
        this.delegate.addTestDefinition(changeMetadata, testName, testDefinition, metadata);
        this.cacheHolder.startRefreshCacheTask();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @VisibleForTesting
    ScheduledFuture<?> getRefreshTaskFuture() {
        return this.cacheHolder.scheduledFuture;
    }

    private boolean isChangedRevision(String test, String revision) throws StoreException {
        List<Revision> revisions = this.cacheHolder.getCachedHistory().get(test);
        if (revisions != null) {
            for (Revision r : revisions) {
                if (!r.getRevision().equals(revision)) continue;
                return true;
            }
        }
        return false;
    }

    class CacheHolder {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final Lock readLock = this.readWriteLock.readLock();
        private final Lock writeLock = this.readWriteLock.writeLock();
        private TestMatrixVersion cachedLatestTestMatrixVersion;
        private Map<String, List<Revision>> historyCache;
        private final Cache<String, TestMatrixVersion> revisionTestMatrixCache = CacheBuilder.newBuilder().maximumSize(3L).build();
        private final Cache<TDKey, TestDefinition> revisionTestDefinitionCache = CacheBuilder.newBuilder().maximumSize(5000L).build();
        private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        private ScheduledFuture<?> scheduledFuture;
        final Runnable refreshCacheTask = new Runnable(){

            @Override
            public void run() {
                try {
                    CacheHolder.this.refreshAll();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Failed to update cache", (Throwable)e);
                }
            }
        };

        CacheHolder() {
        }

        @Nonnull
        public Map<String, List<Revision>> getCachedHistory() throws StoreException {
            return this.synchronizedCacheRead(new Callable<Map<String, List<Revision>>>(){

                @Override
                public Map<String, List<Revision>> call() {
                    return CacheHolder.this.historyCache;
                }
            });
        }

        @Nonnull
        public String getCachedLatestVersion() throws StoreException {
            return this.synchronizedCacheRead(new Callable<String>(){

                @Override
                public String call() {
                    return CacheHolder.this.cachedLatestTestMatrixVersion.getVersion();
                }
            });
        }

        public TestMatrixVersion getCachedTestMatrix(final String fetchRevision) throws StoreException {
            return this.synchronizedCacheRead(new Callable<TestMatrixVersion>(){

                @Override
                public TestMatrixVersion call() throws StoreException {
                    TestMatrixVersion testMatrix = (TestMatrixVersion)CacheHolder.this.revisionTestMatrixCache.getIfPresent((Object)fetchRevision);
                    if (testMatrix == null) {
                        LOGGER.debug((Object)("Cache miss for fetch revision: " + fetchRevision));
                        testMatrix = CachingProctorStore.this.delegate.getTestMatrix(fetchRevision);
                        CacheHolder.this.revisionTestMatrixCache.put((Object)fetchRevision, (Object)testMatrix);
                    }
                    return testMatrix;
                }
            });
        }

        public TestMatrixVersion getCachedCurrentTestMatrix() throws StoreException {
            return this.synchronizedCacheRead(new Callable<TestMatrixVersion>(){

                @Override
                public TestMatrixVersion call() throws StoreException {
                    return CacheHolder.this.cachedLatestTestMatrixVersion;
                }
            });
        }

        public TestDefinition getCachedTestDefinition(final String testName, final String fetchRevision) throws StoreException {
            return this.synchronizedCacheRead(new Callable<TestDefinition>(){

                @Override
                public TestDefinition call() throws Exception {
                    TDKey key = new TDKey(testName, fetchRevision);
                    TestDefinition testDefinition = (TestDefinition)CacheHolder.this.revisionTestDefinitionCache.getIfPresent((Object)key);
                    if (testDefinition == null) {
                        LOGGER.debug((Object)("Cache miss for test definition : name=" + testName + " revision=" + fetchRevision));
                        testDefinition = CachingProctorStore.this.delegate.getTestDefinition(testName, fetchRevision);
                        CacheHolder.this.revisionTestDefinitionCache.put((Object)key, (Object)testDefinition);
                    }
                    return testDefinition;
                }
            });
        }

        private boolean hasNewVersion() throws StoreException {
            String newVersion = CachingProctorStore.this.delegate.getLatestVersion();
            return !newVersion.equals(this.getCachedLatestVersion());
        }

        public void refreshAll() throws StoreException {
            CachingProctorStore.this.delegate.refresh();
            if (this.hasNewVersion()) {
                this.lockAndRefreshCache();
            } else {
                LOGGER.debug((Object)String.format("[%s] Latest version is not changed. Do not refresh cache", CachingProctorStore.this.delegate.getName()));
            }
        }

        private void lockAndRefreshCache() throws StoreException {
            LOGGER.debug((Object)String.format("[%s] Refreshing cache data started", CachingProctorStore.this.delegate.getName()));
            this.synchronizedCacheWrite(new Callable<Void>(){

                @Override
                public Void call() throws StoreException {
                    TestMatrixVersion currentTestMatrix = CachingProctorStore.this.delegate.getCurrentTestMatrix();
                    Revision revision = CachingProctorStore.this.delegate.getMatrixHistory(0, 1).get(0);
                    Map<String, List<Revision>> allHistories = CachingProctorStore.this.delegate.getAllHistories();
                    CacheHolder.this.revisionTestMatrixCache.put((Object)revision.getRevision(), (Object)currentTestMatrix);
                    CacheHolder.this.cachedLatestTestMatrixVersion = currentTestMatrix;
                    CacheHolder.this.historyCache = allHistories;
                    return null;
                }
            });
            LOGGER.debug((Object)String.format("[%s] Refreshing cache data finished", CachingProctorStore.this.delegate.getName()));
        }

        public void start() throws StoreException {
            LOGGER.info((Object)String.format("[%s] Starting Caching for ProctorStore ", CachingProctorStore.this.delegate.getName()));
            this.lockAndRefreshCache();
            this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.refreshCacheTask, 15L, 15L, TimeUnit.SECONDS);
        }

        public void startRefreshCacheTask() {
            LOGGER.info((Object)String.format("[%s] Rescheduling UpdateCacheTask due to new updates.", CachingProctorStore.this.delegate.getName()));
            this.scheduledFuture.cancel(false);
            try {
                this.lockAndRefreshCache();
            }
            catch (StoreException e) {
                LOGGER.error((Object)"failed to update the cache");
            }
            this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.refreshCacheTask, 15L, 15L, TimeUnit.SECONDS);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T synchronizedCacheRead(Callable<T> callable) throws StoreException {
            try {
                if (!this.readLock.tryLock(30L, TimeUnit.SECONDS)) throw new StoreException("Failed to acquire the lock. Timeout after 30");
                try {
                    T t = callable.call();
                    return t;
                }
                catch (Exception e) {
                    throw new StoreException("Failed to perform read operation to cache. ", e);
                }
                finally {
                    this.readLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StoreException("Read operation to cache was interrupted", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T synchronizedCacheWrite(Callable<T> callable) throws StoreException {
            try {
                if (!this.writeLock.tryLock(180L, TimeUnit.SECONDS)) throw new StoreException.TestUpdateException("Failed to acquire the lock. Timeout after 180");
                try {
                    T t = callable.call();
                    return t;
                }
                catch (Exception e) {
                    throw new StoreException.TestUpdateException("Failed to perform write operation to cache. ", e);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StoreException.TestUpdateException("Write operation to cache was interrupted", e);
            }
        }

        private class TDKey {
            private final String test;
            private final String fetchRevision;

            private TDKey(String test, String fetchRevision) {
                this.test = test;
                this.fetchRevision = fetchRevision;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TDKey tdKey = (TDKey)o;
                return Objects.equals(this.test, tdKey.test) && Objects.equals(this.fetchRevision, tdKey.fetchRevision);
            }

            public int hashCode() {
                return Objects.hash(this.test, this.fetchRevision);
            }
        }
    }
}

