/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ChangeMetadata {
    private final String username;
    private final String password;
    private final String author;
    private final Instant timestamp;
    private final String comment;

    ChangeMetadata(String username, String password, String author, String comment) {
        this(username, password, author, Instant.now(), comment);
    }

    public ChangeMetadata(@Nullable String username, @Nullable String password, String author, Instant timestamp, String comment) {
        this.username = username;
        this.password = password;
        this.author = Objects.requireNonNull(author);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.comment = Objects.requireNonNull(comment);
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public String getAuthor() {
        return this.author;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("username", (Object)this.username).append("password", (Object)this.password).append("author", (Object)this.author).append("timestamp", (Object)this.timestamp).append("comment", (Object)this.comment).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeMetadata that = (ChangeMetadata)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.author, that.author) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.author, this.timestamp, this.comment);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String password;
        private String author;
        private Instant timestamp;
        private String comment;

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setUsernameAndAuthor(String username) {
            this.setUsername(username);
            this.setAuthor(username);
            return this;
        }

        public Builder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ChangeMetadata build() {
            return new ChangeMetadata(this.username, this.password, this.author, this.timestamp == null ? Instant.now() : this.timestamp, this.comment);
        }
    }
}

