/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.store.utils;

import com.indeed.proctor.store.Revision;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class HistoryUtil {
    public static <T> List<T> selectHistorySet(@Nullable List<T> history, int start, int limit) {
        if (history == null || start >= history.size() || limit < 1) {
            return Collections.emptyList();
        }
        int s = Math.max(start, 0);
        int l = Math.min(limit, history.size() - s);
        return history.subList(s, s + l);
    }

    public static List<Revision> selectRevisionHistorySetFrom(@Nullable List<Revision> history, String from, int start, int limit) {
        if (history == null) {
            return Collections.emptyList();
        }
        int i = 0;
        for (Revision rev : history) {
            if (rev.getRevision().equals(from)) break;
            ++i;
        }
        return HistoryUtil.selectHistorySet(history, start + i, limit);
    }
}

