/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.io;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Closeables2 {
    public static final Logger log = LoggerFactory.getLogger(Closeables2.class);

    public static void close(@Nullable Closeable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            log.error("Exception during cleanup of a Closeable, ignoring", (Throwable)e);
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable Closeable closeable, @Nonnull org.apache.log4j.Logger log) {
        Closeables2.close(closeable);
    }

    public static void close(@Nonnull Iterable<? extends Closeable> closeables) {
        Throwable throwable = null;
        for (Closeable closeable : closeables) {
            try {
                Closeables2.close(closeable);
            }
            catch (Throwable e) {
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                log.error("Suppressing throwable thrown when closing " + closeable, e);
            }
        }
        if (throwable != null) {
            throw Throwables.propagate(throwable);
        }
    }

    @Deprecated
    public static void closeAll(@Nonnull Iterable<? extends Closeable> closeables, @Nonnull org.apache.log4j.Logger log) {
        Closeables2.close(closeables);
    }

    public static void close(Closeable ... closeables) {
        Closeables2.close(Arrays.asList(closeables));
    }

    @Deprecated
    public static void closeAll(@Nonnull org.apache.log4j.Logger log, Closeable ... closeables) {
        Closeables2.close(closeables);
    }

    @Deprecated
    public static void closeAll(@Nonnull org.apache.log4j.Logger log, @Nonnull Iterable<? extends Closeable> closeables) {
        Closeables2.close(closeables);
    }

    @Deprecated
    public static <C extends Closeable> Closeable forIterable(@Nonnull org.apache.log4j.Logger log, @Nonnull Iterable<C> closeables) {
        return () -> Closeables2.close(closeables);
    }

    @Deprecated
    public static Closeable forArray(@Nonnull org.apache.log4j.Logger log, Closeable ... closeables) {
        return () -> Closeables2.close(closeables);
    }
}

