/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode1D;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;

public class BarcodePostnet
extends Barcode1D {
    public static int TYPE_POSTNET = 1;
    public static int TYPE_PLANET = 2;
    private static final byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet(PdfDocument document) {
        super(document);
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = TYPE_POSTNET;
    }

    public static byte[] getBarsPostnet(String text) {
        int total = 0;
        for (int k = text.length() - 1; k >= 0; --k) {
            int n = text.charAt(k) - 48;
            total += n;
        }
        text = text + (char)((10 - total % 10) % 10 + 48);
        byte[] bars = new byte[text.length() * 5 + 2];
        bars[0] = 1;
        bars[bars.length - 1] = 1;
        for (int k = 0; k < text.length(); ++k) {
            int c = text.charAt(k) - 48;
            System.arraycopy(BARS[c], 0, bars, k * 5 + 1, 5);
        }
        return bars;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float width = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(width, this.barHeight);
    }

    @Override
    public void fitWidth(float width) {
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        float currentWidth = this.getBarcodeSize().getWidth();
        this.x *= width / currentWidth;
        this.n = (width - this.x) / (float)(bars.length - 1);
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, Color barColor, Color textColor) {
        if (barColor != null) {
            canvas.setFillColor(barColor);
        }
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        byte flip = 1;
        if (this.codeType == TYPE_PLANET) {
            flip = 0;
            bars[0] = 0;
            bars[bars.length - 1] = 0;
        }
        float startX = 0.0f;
        for (int k = 0; k < bars.length; ++k) {
            canvas.rectangle((double)startX, 0.0, (double)(this.x - this.inkSpreading), bars[k] == flip ? (double)this.barHeight : (double)this.size);
            startX += this.n;
        }
        canvas.fill();
        return this.getBarcodeSize();
    }
}

