/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringSplitUtil;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfFormFieldMergeUtil;
import com.itextpdf.forms.fields.merging.MergeFieldsStrategy;
import com.itextpdf.forms.fields.merging.OnDuplicateFormFieldNameStrategy;
import com.itextpdf.forms.xfa.XfaForm;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagReference;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfAcroForm
extends PdfObjectWrapper<PdfDictionary> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfAcroForm.class);
    public static final int SIGNATURE_EXIST = 1;
    public static final int APPEND_ONLY = 2;
    protected boolean generateAppearance = true;
    protected Map<String, PdfFormField> fields = new LinkedHashMap<String, PdfFormField>();
    protected PdfDocument document;
    private PdfDictionary defaultResources;
    private Set<PdfFormField> fieldsForFlattening = new LinkedHashSet<PdfFormField>();
    private XfaForm xfaForm;

    private PdfAcroForm(PdfDictionary pdfObject, PdfDocument pdfDocument) {
        super((PdfObject)pdfObject);
        this.document = pdfDocument;
        this.fields = this.populateFormFieldsMap();
        this.xfaForm = new XfaForm(pdfObject);
    }

    private PdfAcroForm(PdfArray fields) {
        this(PdfAcroForm.createAcroFormDictionaryByFields(fields), null);
        this.setForbidRelease();
    }

    public static PdfAcroForm getAcroForm(PdfDocument document, boolean createIfNotExist) {
        return PdfAcroForm.getAcroForm(document, createIfNotExist, new MergeFieldsStrategy());
    }

    public static PdfAcroForm getAcroForm(PdfDocument document, boolean createIfNotExist, OnDuplicateFormFieldNameStrategy onDuplicateFieldNameStrategy) {
        document.getDiContainer().register(OnDuplicateFormFieldNameStrategy.class, (Object)onDuplicateFieldNameStrategy);
        PdfDictionary acroFormDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        PdfAcroForm acroForm = null;
        if (acroFormDictionary == null) {
            if (createIfNotExist) {
                acroForm = new PdfAcroForm(new PdfArray());
                acroForm.makeIndirect(document);
                document.getCatalog().put(PdfName.AcroForm, acroForm.getPdfObject());
                document.getCatalog().setModified();
            }
        } else {
            acroForm = new PdfAcroForm(acroFormDictionary, document);
        }
        if (acroForm != null) {
            acroForm.defaultResources = acroForm.getDefaultResources();
            if (acroForm.defaultResources == null) {
                acroForm.defaultResources = new PdfDictionary();
            }
            acroForm.document = document;
            acroForm.xfaForm = new XfaForm(document);
        }
        return acroForm;
    }

    public void addField(PdfFormField field) {
        if (!field.getPdfObject().containsKey(PdfName.T)) {
            throw new PdfException("Form field must have a name. Set it using PdfFormField#setFieldName call.");
        }
        if (this.document.getNumberOfPages() == 0) {
            this.document.addNewPage();
        }
        PdfPage page = this.document.getLastPage();
        this.addField(field, page);
    }

    public void addField(PdfFormField field, PdfPage page) {
        this.addField(field, page, true);
    }

    public void addField(PdfFormField field, PdfPage page, boolean throwExceptionOnError) {
        if (!field.getPdfObject().containsKey(PdfName.T)) {
            if (throwExceptionOnError) {
                throw new PdfException("Form field must have a name. Set it using PdfFormField#setFieldName call.");
            }
            LOGGER.warn("Form field must have a name. Set it using PdfFormField#setFieldName call.");
            return;
        }
        PdfFormFieldMergeUtil.mergeKidsWithSameNames(field, throwExceptionOnError);
        if (this.needToAddToAcroform(field, throwExceptionOnError)) {
            PdfArray fieldsArray = this.getFields();
            fieldsArray.add((PdfObject)field.getPdfObject());
            fieldsArray.setModified();
            this.fields.put(field.getFieldName().toUnicodeString(), field);
        }
        PdfDictionary fieldDict = field.getPdfObject();
        this.processKids(this.fields.get(field.getFieldName().toUnicodeString()), page);
        if (fieldDict.containsKey(PdfName.Subtype) && page != null) {
            this.defineWidgetPageAndAddToIt(page, fieldDict, false);
        }
        this.setModified();
    }

    public void addFieldAppearanceToPage(PdfFormField field, PdfPage page) {
        PdfDictionary kidDict;
        PdfDictionary fieldDict = field.getPdfObject();
        PdfArray kids = field.getKids();
        if (kids == null) {
            return;
        }
        if (kids.size() == 1 && PdfFormAnnotationUtil.isPureWidget(kidDict = (PdfDictionary)kids.get(0))) {
            PdfFormAnnotationUtil.mergeWidgetWithParentField(field);
            this.defineWidgetPageAndAddToIt(page, fieldDict, false);
            return;
        }
        for (int i = 0; i < kids.size(); ++i) {
            PdfDictionary kidDict2 = (PdfDictionary)kids.get(i);
            if (!PdfFormAnnotationUtil.isPureWidgetOrMergedField(kidDict2)) continue;
            this.defineWidgetPageAndAddToIt(page, kidDict2, false);
        }
    }

    public Map<String, PdfFormField> getRootFormFields() {
        if (this.fields.size() == 0) {
            this.fields = this.populateFormFieldsMap();
        }
        return this.fields;
    }

    public Map<String, PdfFormField> getAllFormFields() {
        if (this.fields.size() == 0) {
            this.fields = this.populateFormFieldsMap();
        }
        LinkedHashMap<String, PdfFormField> allFields = new LinkedHashMap<String, PdfFormField>(this.fields);
        for (Map.Entry<String, PdfFormField> field : this.fields.entrySet()) {
            List<PdfFormField> kids = field.getValue().getAllChildFormFields();
            for (PdfFormField kid : kids) {
                PdfString kidFieldName = kid.getFieldName();
                if (kidFieldName == null) continue;
                allFields.put(kidFieldName.toUnicodeString(), kid);
            }
        }
        return allFields;
    }

    public Set<AbstractPdfFormField> getAllFormFieldsAndAnnotations() {
        if (this.fields.isEmpty()) {
            this.fields = this.populateFormFieldsMap();
        }
        LinkedHashSet<AbstractPdfFormField> allFields = new LinkedHashSet<AbstractPdfFormField>();
        for (Map.Entry<String, PdfFormField> field : this.fields.entrySet()) {
            allFields.add(field.getValue());
            List<AbstractPdfFormField> kids = field.getValue().getAllChildFields();
            allFields.addAll(kids);
        }
        return allFields;
    }

    public Collection<PdfFormField> getFieldsForFlattening() {
        return Collections.unmodifiableCollection(this.fieldsForFlattening);
    }

    public PdfDocument getPdfDocument() {
        return this.document;
    }

    public PdfAcroForm setNeedAppearances(boolean needAppearances) {
        if (VersionConforming.validatePdfVersionForDeprecatedFeatureLogError((PdfDocument)this.document, (PdfVersion)PdfVersion.PDF_2_0, (String)"NeedAppearances has been deprecated in PDF 2.0. Appearance streams are required in PDF 2.0.")) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.NeedAppearances);
            this.setModified();
        } else {
            this.put(PdfName.NeedAppearances, (PdfObject)PdfBoolean.valueOf((boolean)needAppearances));
        }
        return this;
    }

    public PdfBoolean getNeedAppearances() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.NeedAppearances);
    }

    public PdfAcroForm setSignatureFlags(int sigFlags) {
        return this.put(PdfName.SigFlags, (PdfObject)new PdfNumber(sigFlags));
    }

    public PdfAcroForm setSignatureFlag(int sigFlag) {
        int flags = this.getSignatureFlags();
        return this.setSignatureFlags(flags |= sigFlag);
    }

    public int getSignatureFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.SigFlags);
        if (f == null) {
            return 0;
        }
        return f.intValue();
    }

    public PdfAcroForm setCalculationOrder(PdfArray calculationOrder) {
        return this.put(PdfName.CO, (PdfObject)calculationOrder);
    }

    public PdfArray getCalculationOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CO);
    }

    public PdfAcroForm setDefaultResources(PdfDictionary defaultResources) {
        return this.put(PdfName.DR, (PdfObject)defaultResources);
    }

    public PdfDictionary getDefaultResources() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.DR);
    }

    public PdfAcroForm setDefaultAppearance(String appearance) {
        return this.put(PdfName.DA, (PdfObject)new PdfString(appearance));
    }

    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    public PdfAcroForm setDefaultJustification(int justification) {
        return this.put(PdfName.Q, (PdfObject)new PdfNumber(justification));
    }

    public PdfNumber getDefaultJustification() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Q);
    }

    public PdfAcroForm setXFAResource(PdfStream xfaResource) {
        return this.put(PdfName.XFA, (PdfObject)xfaResource);
    }

    public PdfAcroForm setXFAResource(PdfArray xfaResource) {
        return this.put(PdfName.XFA, (PdfObject)xfaResource);
    }

    public PdfObject getXFAResource() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.XFA);
    }

    public PdfFormField getField(String fieldName) {
        PdfFormField parentFormField;
        if (this.fields.get(fieldName) != null) {
            return this.fields.get(fieldName);
        }
        String[] splitFieldsArray = StringSplitUtil.splitKeepTrailingWhiteSpace((String)fieldName, (char)'.');
        if (splitFieldsArray.length == 0) {
            return null;
        }
        PdfFormField kidField = parentFormField = this.fields.get(splitFieldsArray[0]);
        for (int i = 1; i < splitFieldsArray.length; ++i) {
            if (parentFormField == null || parentFormField.isFlushed()) {
                return null;
            }
            parentFormField = kidField = parentFormField.getChildField(splitFieldsArray[i]);
        }
        return kidField;
    }

    public boolean isGenerateAppearance() {
        return this.generateAppearance;
    }

    public void setGenerateAppearance(boolean generateAppearance) {
        if (generateAppearance) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.NeedAppearances);
            this.setModified();
        }
        this.generateAppearance = generateAppearance;
    }

    public void flattenFields() {
        Set<Object> fields;
        if (this.document.isAppendMode()) {
            throw new PdfException("Field flattening is not supported in append mode.");
        }
        if (this.fieldsForFlattening.isEmpty()) {
            this.fields.clear();
            fields = this.getAllFormFieldsWithoutNames();
        } else {
            fields = new LinkedHashSet();
            for (PdfFormField field : this.fieldsForFlattening) {
                fields.addAll(this.prepareFieldsForFlattening(field));
            }
        }
        LinkedHashMap<Integer, PdfObject> initialPageResourceClones = new LinkedHashMap<Integer, PdfObject>();
        for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
            PdfDictionary resources = ((PdfDictionary)this.document.getPage(i).getPdfObject()).getAsDictionary(PdfName.Resources);
            initialPageResourceClones.put(i, resources == null ? null : resources.clone());
        }
        LinkedHashSet<PdfPage> wrappedPages = new LinkedHashSet<PdfPage>();
        for (PdfFormField pdfFormField : fields) {
            for (PdfFormAnnotation fieldAnnot : pdfFormField.getChildFormAnnotations()) {
                PdfObject normal;
                PdfDictionary fieldObject = fieldAnnot.getPdfObject();
                PdfPage page = this.getFieldPage(fieldObject);
                if (page == null) continue;
                PdfAnnotation annotation = PdfAnnotation.makeAnnotation((PdfObject)fieldObject);
                TagTreePointer tagPointer = null;
                if (annotation != null && this.document.isTagged()) {
                    tagPointer = this.document.getTagStructureContext().removeAnnotationTag(annotation);
                }
                PdfDictionary appDic = fieldObject.getAsDictionary(PdfName.AP);
                PdfStream asNormal = null;
                if (appDic != null && (asNormal = appDic.getAsStream(PdfName.N)) == null) {
                    asNormal = appDic.getAsDictionary(PdfName.N);
                }
                if (this.generateAppearance && (appDic == null || asNormal == null)) {
                    fieldAnnot.regenerateField();
                    appDic = fieldObject.getAsDictionary(PdfName.AP);
                }
                PdfObject pdfObject = normal = appDic != null ? appDic.get(PdfName.N) : null;
                if (null != normal) {
                    PdfName as;
                    PdfFormXObject xObject = null;
                    if (normal.isStream()) {
                        xObject = new PdfFormXObject((PdfStream)normal);
                    } else if (normal.isDictionary() && ((PdfDictionary)normal).getAsStream(as = fieldObject.getAsName(PdfName.AS)) != null) {
                        xObject = new PdfFormXObject(((PdfDictionary)normal).getAsStream(as));
                        xObject.makeIndirect(this.document);
                    }
                    if (xObject != null) {
                        xObject.put(PdfName.Subtype, (PdfObject)PdfName.Form);
                        Rectangle annotBBox = fieldObject.getAsRectangle(PdfName.Rect);
                        if (page.isFlushed()) {
                            throw new PdfException("The page has been already flushed. Use PdfAcroForm#addFieldAppearanceToPage() method before page flushing.");
                        }
                        PdfCanvas canvas = new PdfCanvas(page, !wrappedPages.contains(page));
                        wrappedPages.add(page);
                        PdfObject xObjectResources = ((PdfStream)xObject.getPdfObject()).get(PdfName.Resources);
                        PdfObject pageResources = page.getResources().getPdfObject();
                        if (xObjectResources != null && xObjectResources == pageResources) {
                            ((PdfStream)xObject.getPdfObject()).put(PdfName.Resources, (PdfObject)initialPageResourceClones.get(this.document.getPageNumber(page)));
                        }
                        if (tagPointer != null) {
                            tagPointer.setPageForTagging(page);
                            TagReference tagRef = tagPointer.getTagReference();
                            canvas.openTag(tagRef);
                        }
                        AffineTransform at = this.calcFieldAppTransformToAnnotRect(xObject, annotBBox);
                        float[] m = new float[6];
                        at.getMatrix(m);
                        canvas.addXObjectWithTransformationMatrix((PdfXObject)xObject, m[0], m[1], m[2], m[3], m[4], m[5]);
                        if (tagPointer != null) {
                            canvas.closeTag();
                        }
                    }
                } else {
                    LOGGER.warn("\\N entry is required to be present in an appearance dictionary.");
                }
                PdfArray fFields = this.getFields();
                if (annotation != null) {
                    page.removeAnnotation(annotation);
                }
                this.removeFieldFromParentAndAcroForm(fFields, fieldObject);
            }
        }
        ((PdfDictionary)this.getPdfObject()).remove(PdfName.NeedAppearances);
        if (this.fieldsForFlattening.size() == 0) {
            this.getFields().clear();
        }
        if (this.getFields().isEmpty()) {
            this.document.getCatalog().remove(PdfName.AcroForm);
        }
    }

    public boolean removeField(String fieldName) {
        PdfFormField field = this.getField(fieldName);
        if (field == null) {
            return false;
        }
        PdfDictionary fieldObject = field.getPdfObject();
        PdfPage page = this.getFieldPage(fieldObject);
        PdfAnnotation annotation = PdfAnnotation.makeAnnotation((PdfObject)fieldObject);
        if (page != null && annotation != null) {
            page.removeAnnotation(annotation);
        }
        PdfDictionary parent = field.getParent();
        PdfFormField parentField = field.getParentField();
        if (parent != null) {
            PdfArray kids = parent.getAsArray(PdfName.Kids);
            if (parentField != null) {
                parentField.removeChild(field);
            }
            kids.remove((PdfObject)fieldObject);
            kids.setModified();
            parent.setModified();
            return true;
        }
        PdfArray fieldsPdfArray = this.getFields();
        if (fieldsPdfArray.contains((PdfObject)fieldObject)) {
            fieldsPdfArray.remove((PdfObject)fieldObject);
            this.fields.remove(fieldName);
            fieldsPdfArray.setModified();
            this.setModified();
            return true;
        }
        return false;
    }

    public void partialFormFlattening(String fieldName) {
        PdfFormField field = this.getAllFormFields().get(fieldName);
        if (field != null) {
            this.fieldsForFlattening.add(field);
        }
    }

    public void renameField(String oldName, String newName) {
        PdfFormField oldField = this.getField(oldName);
        if (oldField == null) {
            LOGGER.warn(MessageFormatUtil.format((String)"Fieldname: <{0}> not found. Operation can not be completed.", (Object[])new Object[]{oldName}));
            return;
        }
        this.getField(oldName).setFieldName(newName);
        PdfFormField field = this.fields.get(oldName);
        if (field != null) {
            this.fields.remove(oldName);
            this.fields.put(newName, field);
        }
    }

    public PdfFormField copyField(String name) {
        PdfFormField oldField = this.getField(name);
        if (oldField != null) {
            return PdfFormCreator.createFormField((PdfDictionary)oldField.getPdfObject().clone().makeIndirect(this.document));
        }
        return null;
    }

    public void replaceField(String name, PdfFormField field) {
        if (name == null) {
            LOGGER.warn("No form field name provided. Process will not be continued.");
            return;
        }
        this.removeField(name);
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1) {
            this.addField(field);
            return;
        }
        String parentName = name.substring(0, lastDotIndex);
        PdfFormField parent = this.getField(parentName);
        if (parent == null) {
            this.addField(field);
        } else {
            parent.addKid(field);
        }
    }

    public void disableRegenerationForAllFields() {
        for (PdfFormField rootField : this.getRootFormFields().values()) {
            rootField.disableFieldRegeneration();
        }
    }

    public void enableRegenerationForAllFields() {
        for (PdfFormField rootField : this.getRootFormFields().values()) {
            rootField.enableFieldRegeneration();
        }
    }

    protected PdfArray getFields() {
        PdfArray fields = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Fields);
        if (fields == null) {
            LOGGER.warn("Required AcroForm entry /Fields does not exist in the document. Empty array /Fields will be created.");
            fields = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Fields, (PdfObject)fields);
        }
        return fields;
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    private Map<String, PdfFormField> populateFormFieldsMap() {
        PdfArray rawFields = this.getFields();
        LinkedHashMap<String, PdfFormField> fields = new LinkedHashMap<String, PdfFormField>();
        PdfArray shouldBeRemoved = new PdfArray();
        for (PdfObject field : rawFields) {
            if (field.isFlushed()) {
                LOGGER.info("A form field was flushed. There's no way to create this field in the AcroForm dictionary.");
                continue;
            }
            PdfFormField formField = PdfFormField.makeFormField(field, this.document);
            if (formField == null) {
                LOGGER.warn("Annotation is noticed directly in fields array of AcroForm dictionary. It violates pdf specification.");
                continue;
            }
            PdfFormFieldMergeUtil.mergeKidsWithSameNames(formField, false);
            PdfString fieldName = formField.getFieldName();
            if (fieldName == null) continue;
            String name = formField.getFieldName().toUnicodeString();
            if (formField.isInReadingMode() || !fields.containsKey(name) || !PdfFormFieldMergeUtil.mergeTwoFieldsWithTheSameNames((PdfFormField)((Object)fields.get(name)), formField, true)) {
                fields.put(formField.getFieldName().toUnicodeString(), formField);
                continue;
            }
            shouldBeRemoved.add(field);
        }
        for (PdfObject field : shouldBeRemoved) {
            rawFields.remove(field);
        }
        return fields;
    }

    private void removeFieldFromParentAndAcroForm(PdfArray formFields, PdfDictionary fieldObject) {
        formFields.remove((PdfObject)fieldObject);
        PdfDictionary parent = fieldObject.getAsDictionary(PdfName.Parent);
        if (parent != null) {
            PdfArray kids = parent.getAsArray(PdfName.Kids);
            if (kids == null) {
                formFields.remove((PdfObject)parent);
            } else {
                kids.remove((PdfObject)fieldObject);
                if (kids.isEmpty()) {
                    this.removeFieldFromParentAndAcroForm(formFields, parent);
                }
            }
        }
    }

    private void processKids(PdfFormField field, PdfPage page) {
        PdfDictionary kidDict;
        PdfName type;
        PdfArray kids = field.getKids();
        if (kids == null) {
            return;
        }
        if (kids.size() == 1 && PdfName.Widget.equals((Object)(type = (kidDict = (PdfDictionary)kids.get(0)).getAsName(PdfName.Subtype)))) {
            if (PdfFormAnnotationUtil.isPureWidget(kidDict)) {
                PdfFormAnnotationUtil.mergeWidgetWithParentField(field);
                this.defineWidgetPageAndAddToIt(page, field.getPdfObject(), true);
            } else {
                this.defineWidgetPageAndAddToIt(page, kidDict, true);
            }
            return;
        }
        for (AbstractPdfFormField child : field.getChildFields()) {
            if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(child.getPdfObject())) {
                this.defineWidgetPageAndAddToIt(page, child.getPdfObject(), true);
                continue;
            }
            if (!(child instanceof PdfFormField)) continue;
            this.processKids((PdfFormField)child, page);
        }
    }

    private void defineWidgetPageAndAddToIt(PdfPage currentPage, PdfDictionary mergedFieldAndWidget, boolean warnIfPageFlushed) {
        PdfAnnotation annot = PdfAnnotation.makeAnnotation((PdfObject)mergedFieldAndWidget);
        PdfPage page = this.getFieldPage(mergedFieldAndWidget);
        if (page != null) {
            PdfFormAnnotationUtil.addWidgetAnnotationToPage(page, annot);
            return;
        }
        PdfDictionary pageDic = annot.getPageObject();
        if (pageDic == null) {
            PdfFormAnnotationUtil.addWidgetAnnotationToPage(currentPage, annot);
        } else {
            if (warnIfPageFlushed && pageDic.isFlushed()) {
                throw new PdfException("The page has been already flushed. Use PdfAcroForm#addFieldAppearanceToPage() method before page flushing.");
            }
            PdfDocument doc = pageDic.getIndirectReference().getDocument();
            PdfPage widgetPage = doc.getPage(pageDic);
            PdfFormAnnotationUtil.addWidgetAnnotationToPage(widgetPage == null ? currentPage : widgetPage, annot);
        }
    }

    public boolean hasXfaForm() {
        return this.xfaForm != null && this.xfaForm.isXfaPresent();
    }

    public XfaForm getXfaForm() {
        return this.xfaForm;
    }

    public void removeXfaForm() {
        if (this.hasXfaForm()) {
            PdfDictionary root = (PdfDictionary)this.document.getCatalog().getPdfObject();
            PdfDictionary acroform = root.getAsDictionary(PdfName.AcroForm);
            acroform.remove(PdfName.XFA);
            this.xfaForm = null;
        }
    }

    public PdfAcroForm put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public void release() {
        this.unsetForbidRelease();
        ((PdfDictionary)this.getPdfObject()).release();
        if (this.fields != null) {
            for (PdfFormField field : this.fields.values()) {
                field.release();
            }
            this.fields.clear();
            this.fields = null;
        }
    }

    public PdfObjectWrapper<PdfDictionary> setModified() {
        if (((PdfDictionary)this.getPdfObject()).getIndirectReference() != null) {
            super.setModified();
        } else {
            this.document.getCatalog().setModified();
        }
        return this;
    }

    private static PdfDictionary createAcroFormDictionaryByFields(PdfArray fields) {
        PdfDictionary dictionary = new PdfDictionary();
        dictionary.put(PdfName.Fields, (PdfObject)fields);
        return dictionary;
    }

    private PdfPage getFieldPage(PdfDictionary annotDict) {
        PdfDictionary pageDic = annotDict.getAsDictionary(PdfName.P);
        if (pageDic != null) {
            return this.document.getPage(pageDic);
        }
        for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
            PdfAnnotation annotation;
            PdfPage page = this.document.getPage(i);
            if (page.isFlushed() || (annotation = PdfAnnotation.makeAnnotation((PdfObject)annotDict)) == null || !page.containsAnnotation(annotation)) continue;
            return page;
        }
        return null;
    }

    private Set<PdfFormField> prepareFieldsForFlattening(PdfFormField field) {
        LinkedHashSet<PdfFormField> preparedFields = new LinkedHashSet<PdfFormField>();
        preparedFields.add(field);
        for (PdfFormField child : field.getChildFormFields()) {
            preparedFields.addAll(this.prepareFieldsForFlattening(child));
        }
        return preparedFields;
    }

    private AffineTransform calcFieldAppTransformToAnnotRect(PdfFormXObject xObject, Rectangle annotBBox) {
        Rectangle transformedRect;
        PdfArray bBox = xObject.getBBox();
        if (bBox.size() != 4) {
            bBox = new PdfArray(new Rectangle(0.0f, 0.0f));
            xObject.setBBox(bBox);
        }
        float[] xObjBBox = bBox.toFloatArray();
        PdfArray xObjMatrix = ((PdfStream)xObject.getPdfObject()).getAsArray(PdfName.Matrix);
        if (xObjMatrix != null && xObjMatrix.size() == 6) {
            Point[] xObjRectPoints = new Point[]{new Point((double)xObjBBox[0], (double)xObjBBox[1]), new Point((double)xObjBBox[0], (double)xObjBBox[3]), new Point((double)xObjBBox[2], (double)xObjBBox[1]), new Point((double)xObjBBox[2], (double)xObjBBox[3])};
            Point[] transformedAppBoxPoints = new Point[xObjRectPoints.length];
            new AffineTransform(xObjMatrix.toDoubleArray()).transform(xObjRectPoints, 0, transformedAppBoxPoints, 0, xObjRectPoints.length);
            float[] transformedRectArr = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f};
            for (Point p : transformedAppBoxPoints) {
                transformedRectArr[0] = (float)Math.min((double)transformedRectArr[0], p.x);
                transformedRectArr[1] = (float)Math.min((double)transformedRectArr[1], p.y);
                transformedRectArr[2] = (float)Math.max((double)transformedRectArr[2], p.x);
                transformedRectArr[3] = (float)Math.max((double)transformedRectArr[3], p.y);
            }
            transformedRect = new Rectangle(transformedRectArr[0], transformedRectArr[1], transformedRectArr[2] - transformedRectArr[0], transformedRectArr[3] - transformedRectArr[1]);
        } else {
            transformedRect = new Rectangle(0.0f, 0.0f).setBbox(xObjBBox[0], xObjBBox[1], xObjBBox[2], xObjBBox[3]);
        }
        AffineTransform at = AffineTransform.getTranslateInstance((double)(-transformedRect.getX()), (double)(-transformedRect.getY()));
        float scaleX = transformedRect.getWidth() == 0.0f ? 1.0f : annotBBox.getWidth() / transformedRect.getWidth();
        float scaleY = transformedRect.getHeight() == 0.0f ? 1.0f : annotBBox.getHeight() / transformedRect.getHeight();
        at.preConcatenate(AffineTransform.getScaleInstance((double)scaleX, (double)scaleY));
        at.preConcatenate(AffineTransform.getTranslateInstance((double)annotBBox.getX(), (double)annotBBox.getY()));
        return at;
    }

    private Set<PdfFormField> getAllFormFieldsWithoutNames() {
        if (this.fields.isEmpty()) {
            this.fields = this.populateFormFieldsMap();
        }
        LinkedHashSet<PdfFormField> allFields = new LinkedHashSet<PdfFormField>();
        for (Map.Entry<String, PdfFormField> field : this.fields.entrySet()) {
            allFields.add(field.getValue());
            List<PdfFormField> kids = field.getValue().getAllChildFormFields();
            allFields.addAll(kids);
        }
        return allFields;
    }

    private boolean needToAddToAcroform(PdfFormField field, boolean throwExceptionOnError) {
        String fieldNameBeforeMergeCall = field.getFieldName().toUnicodeString();
        if (!this.fields.containsKey(fieldNameBeforeMergeCall)) {
            return true;
        }
        if (!PdfFormFieldMergeUtil.mergeTwoFieldsWithTheSameNames(this.fields.get(fieldNameBeforeMergeCall), field, throwExceptionOnError)) {
            return true;
        }
        boolean isFieldNameChanged = !fieldNameBeforeMergeCall.equals(field.getFieldName().toUnicodeString());
        return isFieldNameChanged;
    }
}

