/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.signatures.CertificateVerifier;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.VerificationOK;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RootStoreVerifier
extends CertificateVerifier {
    protected KeyStore rootStore = null;

    public RootStoreVerifier(CertificateVerifier verifier) {
        super(verifier);
    }

    public void setRootStore(KeyStore keyStore) {
        this.rootStore = keyStore;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        if (this.rootStore == null) {
            return super.verify(signCert, issuerCert, signDate);
        }
        try {
            ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
            for (X509Certificate anchor : SignUtils.getCertificates(this.rootStore)) {
                try {
                    signCert.verify(anchor.getPublicKey());
                    result.add(new VerificationOK(signCert, this.getClass(), "Certificate verified against root store."));
                    result.addAll(super.verify(signCert, issuerCert, signDate));
                    return result;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            result.addAll(super.verify(signCert, issuerCert, signDate));
            return result;
        }
        catch (GeneralSecurityException e) {
            return super.verify(signCert, issuerCert, signDate);
        }
    }
}

