/*
 * Decompiled with CFR 0.152.
 */
package com.itv.scalapact.plugin.shared;

import com.itv.scalapact.plugin.shared.PactContractWriter$;
import com.itv.scalapact.shared.BuildInfo$;
import com.itv.scalapact.shared.Contract;
import com.itv.scalapact.shared.Pact;
import com.itv.scalapact.shared.ScalaPactSettings;
import com.itv.scalapact.shared.json.IPactReader;
import com.itv.scalapact.shared.json.IPactWriter;
import com.itv.scalapact.shared.utils.ColourOutput;
import com.itv.scalapact.shared.utils.ColourOutput$;
import com.itv.scalapact.shared.utils.PactLogger$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ScalaPactTestCommand$ {
    public static ScalaPactTestCommand$ MODULE$;

    static {
        new ScalaPactTestCommand$();
    }

    public void doPactPack(ScalaPactSettings scalaPactSettings, boolean areScalaPactContracts, IPactReader pactReader, IPactWriter pactWriter) {
        PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.bold$extension(ColourOutput$.MODULE$.ColouredString(ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString("*************************************")))));
        PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.bold$extension(ColourOutput$.MODULE$.ColouredString(ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString("** ScalaPact: Squashing Pact Files **")))));
        PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.bold$extension(ColourOutput$.MODULE$.ColouredString(ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString("*************************************")))));
        File pactDir = new File(scalaPactSettings.giveOutputPath());
        if (pactDir.exists() && pactDir.isDirectory()) {
            int n;
            List files = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pactDir.listFiles())).toList().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ScalaPactTestCommand$.$anonfun$doPactPack$4(f)));
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.bold$extension(ColourOutput$.MODULE$.ColouredString(ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString(new StringBuilder(43).append("> ").append(Integer.toString(files.length())).append(" files found that could be Pact contracts").toString())))));
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString(((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(4).append("> - ").append(x$1.getName()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n"))));
            List groupedFileList = files.groupBy((Function1 & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.getName().split("_"))).take(2))).mkString("_")).toList();
            if (areScalaPactContracts) {
                n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)groupedFileList.map((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToInteger((int)ScalaPactTestCommand$.MODULE$.squashPactFiles(scalaPactSettings.giveOutputPath(), (List<File>)((List)g._2()), pactReader, pactWriter)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else {
                PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> "Expecting pact-jvm contracts, so not combining pact files.");
                n = 0;
            }
            int errorCount = n;
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.bold$extension(ColourOutput$.MODULE$.ColouredString(ColourOutput.ColouredString$.MODULE$.white$extension(ColourOutput$.MODULE$.ColouredString(new StringBuilder(15).append("> ").append(Integer.toString(groupedFileList.length())).append(" pacts found:").toString())))));
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)groupedFileList.map((Function1 & Serializable & scala.Serializable)g -> new StringBuilder(5).append("> - ").append(((String)g._1()).replace("_", " -> ")).append("\n").toString(), List$.MODULE$.canBuildFrom())).mkString());
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("> ").append(Integer.toString(errorCount)).append(" errors").toString());
        } else {
            PactLogger$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.red$extension(ColourOutput$.MODULE$.ColouredString(new StringBuilder(104).append("No Pact files found in '").append(scalaPactSettings.giveOutputPath()).append("'. Make sure you have Pact CDC tests and have run 'sbt test' or 'sbt pact-test'.").toString())));
        }
    }

    private int squashPactFiles(String outputPath, List<File> files, IPactReader pactReader, IPactWriter pactWriter) {
        Function1 & Serializable & scala.Serializable jsonStringToPact = (Function1 & Serializable & scala.Serializable)x$2 -> pactReader.jsonStringToScalaPact(x$2).toOption();
        Tuple2 tuple2 = ((TraversableLike)files.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.fileToJsonString((File)x$3).flatMap(jsonStringToPact), List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List failed = (List)tuple2._1();
        List squashedPacts = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)failed, (Object)squashedPacts);
        Tuple2 tuple23 = tuple22;
        List failed2 = (List)tuple23._1();
        List squashedPacts2 = (List)tuple23._2();
        ((TraversableOnce)squashedPacts2.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Pact>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Pact pact = (Pact)some.value();
                    object = pact;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Pact> x1) {
                Option<Pact> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(p1, p2) -> MODULE$.combinePacts((Pact)p1, (Pact)p2)).foreach((Function1 & Serializable & scala.Serializable)combined -> {
            ScalaPactTestCommand$.$anonfun$squashPactFiles$6(outputPath, pactWriter, combined);
            return BoxedUnit.UNIT;
        });
        return failed2.size();
    }

    private Option<String> fileToJsonString(File file) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
            String contents = source.getLines().mkString();
            source.close();
            file.delete();
            return var2_2;
        }).toOption().orElse((Function0 & Serializable & scala.Serializable)() -> {
            PactLogger$.MODULE$.message((Function0 & Serializable & scala.Serializable)() -> ColourOutput.ColouredString$.MODULE$.red$extension(ColourOutput$.MODULE$.ColouredString(new StringBuilder(35).append("Problem reading Pact file at path: ").append(file.getCanonicalPath()).toString())));
            return None$.MODULE$;
        });
    }

    private Pact combinePacts(Pact p1, Pact p2) {
        List x$1 = (List)p1.interactions().$plus$plus((GenTraversableOnce)p2.interactions(), List$.MODULE$.canBuildFrom());
        String x$2 = p1.copy$default$1();
        String x$3 = p1.copy$default$2();
        Option x$4 = p1.copy$default$4();
        Option x$5 = p1.copy$default$5();
        return p1.copy(x$2, x$3, x$1, x$4, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$doPactPack$4(File f) {
        return f.getName().endsWith(".json");
    }

    public static final /* synthetic */ void $anonfun$squashPactFiles$6(String outputPath$1, IPactWriter pactWriter$2, Pact combined) {
        ((Function1)((Function1)((Function1)PactContractWriter$.MODULE$.writePactToFile().apply((Object)outputPath$1)).apply((Object)combined.provider())).apply((Object)combined.consumer())).apply((Object)pactWriter$2.pactToJsonString((Contract)combined, BuildInfo$.MODULE$.version()));
    }

    private ScalaPactTestCommand$() {
        MODULE$ = this;
    }
}

