package com.ixaris.commons.misc.lib.object;

import java.util.Comparator;

@FunctionalInterface
public interface Ordered {
    
    Comparator<Ordered> COMPARATOR = Comparator.comparingInt(Ordered::getOrder);
    
    /**
     * Useful constant for the highest precedence value.
     *
     * @see java.lang.Integer#MIN_VALUE
     */
    int HIGHEST_PRECEDENCE = Integer.MIN_VALUE;
    
    /**
     * Useful constant for the lowest precedence value.
     *
     * @see java.lang.Integer#MAX_VALUE
     */
    int LOWEST_PRECEDENCE = Integer.MAX_VALUE;
    
    /**
     * Get the order value of this object.
     *
     * <p>Higher values are interpreted as lower priority. As a consequence, the object with the lowest value has the
     * highest priority (somewhat analogous to Servlet {@code load-on-startup} values).
     *
     * <p>Same order values will result in arbitrary sort positions for the affected objects.
     *
     * @return the order value
     * @see #HIGHEST_PRECEDENCE
     * @see #LOWEST_PRECEDENCE
     */
    int getOrder();
    
}
