/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.examples.springmvc.controller;

import com.jayway.restassured.examples.springmvc.controller.FileDescription;
import com.jayway.restassured.examples.springmvc.controller.FileWithParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class FileUploadController {
    @RequestMapping(value={"/fileUpload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public String fileUpload(@RequestParam MultipartFile file) {
        return "{ \"size\" : " + file.getSize() + ", \"name\" : \"" + file.getName() + "\" }";
    }

    @RequestMapping(value={"/fileUpload2"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public String fileUpload2(@RequestParam(value="controlName") MultipartFile file) {
        return "{ \"size\" : " + file.getSize() + ", \"name\" : \"" + file.getName() + "\", \"originalName\" : \"" + file.getOriginalFilename() + "\", \"mimeType\" : \"" + file.getContentType() + "\" }";
    }

    @RequestMapping(value={"/multiFileUpload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public List<FileDescription> multiFileUpload(@RequestParam(value="controlName1") MultipartFile file1, @RequestParam(value="controlName2") MultipartFile file2) throws IOException {
        FileDescription fd1 = new FileDescription();
        fd1.setContent(new String(file1.getBytes()));
        fd1.setName(file1.getName());
        fd1.setMimeType(file1.getContentType());
        fd1.setOriginalName(file1.getOriginalFilename());
        fd1.setSize(file1.getSize());
        FileDescription fd2 = new FileDescription();
        fd2.setContent(new String(file2.getBytes()));
        fd2.setName(file2.getName());
        fd2.setMimeType(file2.getContentType());
        fd2.setOriginalName(file2.getOriginalFilename());
        fd2.setSize(file2.getSize());
        return Arrays.asList(fd1, fd2);
    }

    @RequestMapping(value={"/fileUploadWithParam"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public FileWithParam fileUploadWithParam(@RequestParam(value="controlName") MultipartFile file, @RequestParam(value="param", required=false) String param) throws IOException {
        FileDescription fd1 = new FileDescription();
        fd1.setContent(new String(file.getBytes()));
        fd1.setName(file.getName());
        fd1.setMimeType(file.getContentType());
        fd1.setOriginalName(file.getOriginalFilename());
        fd1.setSize(file.getSize());
        FileWithParam fileWithParam = new FileWithParam();
        fileWithParam.setFile(fd1);
        fileWithParam.setParam(param);
        return fileWithParam;
    }

    @RequestMapping(value={"/nonMultipartFileUpload"}, method={RequestMethod.POST}, consumes={"application/octet-stream"}, produces={"application/json"})
    @ResponseBody
    public String nonMultipartFileUpload(@RequestBody String is) throws IOException {
        return "{ \"size\" : " + is.length() + ", \"content\":\"" + is + "\" }";
    }

    @RequestMapping(value={"/fileUploadWithControlNameEqualToSomething"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseBody
    public String fileUploadWithControlNameEqualToSomething(@RequestParam(value="something") MultipartFile file) {
        return "{ \"size\" : " + file.getSize() + ", \"name\" : \"" + file.getName() + "\", \"originalName\" : \"" + file.getOriginalFilename() + "\", \"mimeType\" : \"" + file.getContentType() + "\" }";
    }
}

