/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.engine;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import com.jetdrone.vertx.yoke.core.YokeAsyncResult;
import com.jetdrone.vertx.yoke.engine.AbstractEngineSync;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class HandlebarsEngine
extends AbstractEngineSync<Template> {
    private final Handlebars handlebars;
    private final String prefix;
    private final String extension = ".hbs";

    public HandlebarsEngine(String views) {
        super(null);
        this.prefix = "".equals(views) ? views : (views.endsWith("/") ? views : views + "/");
        this.handlebars = new Handlebars(new TemplateLoader(){

            public TemplateSource sourceAt(final String location) throws IOException {
                final String buffer = HandlebarsEngine.this.read(this.resolve(location));
                if (buffer == null) {
                    throw new FileNotFoundException(location);
                }
                return new TemplateSource(){

                    public String content() throws IOException {
                        return buffer;
                    }

                    public String filename() {
                        return location;
                    }

                    public long lastModified() {
                        return HandlebarsEngine.this.lastModified(location);
                    }
                };
            }

            public String resolve(String location) {
                return HandlebarsEngine.this.resolve(location);
            }

            public String getPrefix() {
                return HandlebarsEngine.this.prefix;
            }

            public String getSuffix() {
                return ".hbs";
            }
        });
    }

    public String extension() {
        return ".hbs";
    }

    private String resolve(String location) {
        String normalized = this.normalize(location);
        if (normalized.endsWith(".hbs")) {
            return this.prefix + normalized;
        }
        return this.prefix + normalized + ".hbs";
    }

    private String normalize(String location) {
        if (location.startsWith("/")) {
            return location.substring(1);
        }
        return location;
    }

    public void render(String filename, Map<String, Object> context, Handler<AsyncResult<Buffer>> next) {
        try {
            Template template = (Template)this.getTemplateFromCache(this.resolve(filename));
            if (template == null) {
                template = this.handlebars.compile(filename);
                this.putTemplateToCache(this.resolve(filename), template);
            }
            next.handle((Object)new YokeAsyncResult((Object)new Buffer(template.apply(context))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            next.handle((Object)new YokeAsyncResult((Throwable)ex));
        }
    }

    public void render(String filename, String layoutFilename, Map<String, Object> context, Handler<AsyncResult<Buffer>> handler) {
        handler.handle((Object)new YokeAsyncResult((Throwable)new UnsupportedOperationException()));
    }

    public void registerHelper(String name, Helper<?> helper) {
        this.handlebars.registerHelper(name, helper);
    }
}

