/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.engine;

import com.jetdrone.vertx.yoke.core.YokeAsyncResult;
import com.jetdrone.vertx.yoke.engine.AbstractEngineSync;
import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;

public class Jade4JEngine
extends AbstractEngineSync<JadeTemplate> {
    private final JadeConfiguration config = new JadeConfiguration();
    private final String prefix;
    private final String extension = ".jade";

    public Jade4JEngine(String views) {
        super(null);
        this.prefix = "".equals(views) ? views : (views.endsWith("/") ? views : views + "/");
        this.config.setTemplateLoader(new TemplateLoader(){

            public long getLastModified(String name) throws IOException {
                return Jade4JEngine.this.lastModified(name);
            }

            public Reader getReader(String name) throws IOException {
                return new StringReader(Jade4JEngine.this.read(Jade4JEngine.this.resolve(name)));
            }
        });
    }

    private String resolve(String location) {
        String normalized = this.normalize(location);
        if (normalized.endsWith(".jade")) {
            return this.prefix + normalized;
        }
        return this.prefix + normalized + ".jade";
    }

    private String normalize(String location) {
        if (location.startsWith("/")) {
            return location.substring(1);
        }
        return location;
    }

    public String extension() {
        return ".jade";
    }

    public void render(String filename, String layoutFilename, Map<String, Object> context, Handler<AsyncResult<Buffer>> handler) {
        handler.handle((Object)new YokeAsyncResult((Throwable)new UnsupportedOperationException()));
    }

    public void render(String filename, Map<String, Object> context, Handler<AsyncResult<Buffer>> next) {
        try {
            JadeTemplate template = (JadeTemplate)this.getTemplateFromCache(this.resolve(filename));
            if (template == null) {
                template = this.config.getTemplate(filename);
                this.putTemplateToCache(this.resolve(filename), template);
            }
            next.handle((Object)new YokeAsyncResult((Object)new Buffer(this.config.renderTemplate(template, context))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            next.handle((Object)new YokeAsyncResult((Throwable)ex));
        }
    }
}

