/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.middleware;

import com.jetdrone.vertx.yoke.Middleware;
import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import com.jetdrone.vertx.yoke.middleware.impl.WebClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.vertx.java.core.Handler;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class CSP
extends Middleware {
    private final List<String> ALL_HEADERS = Arrays.asList("X-Content-Security-Policy", "Content-Security-Policy", "X-WebKit-CSP");
    private final List<String> DIRECTIVES = Arrays.asList("default-src", "script-src", "object-src", "img-src", "media-src", "frame-src", "font-src", "connect-src", "style-src", "report-uri", "sandbox");
    private final List<String> MUST_BE_QUOTED = Arrays.asList("none", "self", "unsafe-inline", "unsafe-eval");
    private final JsonObject options;
    private final boolean reportOnly;
    private final boolean setAllHeaders;
    private final boolean safari5;

    public CSP() {
        this(new JsonObject().putArray("default-src", new JsonArray().add((Object)"'self'")));
    }

    public CSP(JsonObject options) {
        this.options = options;
        this.reportOnly = options.getBoolean("reportOnly", false);
        this.setAllHeaders = options.getBoolean("setAllHeaders", false);
        this.safari5 = options.getBoolean("safari5", false);
        Set keys = options.getFieldNames();
        for (String key : keys) {
            Object value = options.getField(key);
            if (value instanceof JsonArray) {
                for (String must : this.MUST_BE_QUOTED) {
                    if (((JsonArray)value).contains((Object)must)) continue;
                    throw new RuntimeException(value + " must be quoted");
                }
                continue;
            }
            for (String must : this.MUST_BE_QUOTED) {
                if (!must.equals(value)) continue;
                throw new RuntimeException(value + " must be quoted");
            }
        }
        if (this.reportOnly && options.getString("report-uri") == null) {
            throw new RuntimeException("Please remove reportOnly or add a report-uri.");
        }
    }

    public void handle(@NotNull YokeRequest request, @NotNull Handler<Object> next) {
        List<String> headers = new ArrayList<String>();
        HashMap<String, Object> policy = new HashMap<String, Object>();
        boolean setAllHeaders = this.setAllHeaders;
        WebClient webClient = WebClient.detect(request.getHeader("user-agent"));
        WebClient.UserAgent userAgent = webClient.getUserAgent();
        int version = webClient.getMajorVersion();
        for (String directive : this.DIRECTIVES) {
            boolean shouldWrapInArray;
            Object value = this.options.getField(directive);
            if (value != null) {
                policy.put(directive, value);
            }
            if (!(shouldWrapInArray = value instanceof String && !"sandbox".equals(directive) || "sandbox".equals(directive) && !Boolean.TRUE.equals(value))) continue;
            policy.put(directive, value.toString().split("\\s"));
        }
        switch (userAgent) {
            case IE: {
                if (version < 10) break;
                headers.add("X-Content-Security-Policy");
                if (policy.get("sandbox") != null) break;
                policy.put("sandbox", Boolean.TRUE);
                break;
            }
            case FIREFOX: {
                if (version >= 23) {
                    headers.add("Content-Security-Policy");
                    break;
                }
                if (version < 4 || version >= 23) break;
                headers.add("X-Content-Security-Policy");
                if (policy.get("default-src") == null) {
                    policy.put("default-src", Arrays.asList("*"));
                }
                Set keys = this.options.getFieldNames();
                for (String key : keys) {
                    Object value = this.options.getField(key);
                    if ("connect-src".equals(key)) {
                        policy.put("xhr-src", value);
                    } else if ("default-src".equals(key)) {
                        if (version < 5) {
                            policy.put("allow", value);
                        } else {
                            policy.put("default-src", value);
                        }
                    } else if (!"sandbox".equals(key)) {
                        policy.put(key, value);
                    }
                    if (!(policy.get(key) instanceof List)) continue;
                    List list = (List)policy.get(key);
                    int index = list.indexOf("'unsafe-inline'");
                    if (index != -1) {
                        if ("script-src".equals(key)) {
                            list.set(index, "'inline-script'");
                        } else {
                            list.remove(index);
                        }
                    }
                    if ((index = list.indexOf("'unsafe-eval'")) == -1) continue;
                    if ("script-src".equals(key)) {
                        list.set(index, "'eval-script'");
                        continue;
                    }
                    list.remove(index);
                }
                break;
            }
            case CHROME: {
                if (version >= 14 && version < 25) {
                    headers.add("X-WebKit-CSP");
                    break;
                }
                if (version < 25) break;
                headers.add("Content-Security-Policy");
                break;
            }
            case SAFARI: {
                if (version >= 7) {
                    headers.add("Content-Security-Policy");
                    break;
                }
                if (version < 6 && (!((double)version >= 5.1) || !this.safari5)) break;
                headers.add("X-WebKit-CSP");
                break;
            }
            case OPERA: {
                if (version < 15) break;
                headers.add("Content-Security-Policy");
                break;
            }
            case CHROME_MOBILE: {
                if (version < 14) break;
                headers.add("Content-Security-Policy");
                break;
            }
            default: {
                setAllHeaders = true;
            }
        }
        StringBuilder policyString = new StringBuilder();
        for (Map.Entry entry : policy.entrySet()) {
            if ("sandbox".equals(entry.getKey()) && Boolean.TRUE.equals(entry.getValue())) {
                policyString.append("sandbox;");
                continue;
            }
            if (entry.getValue() instanceof List) {
                policyString.append((String)entry.getKey());
                policyString.append(" ");
                for (Object item : (List)entry.getValue()) {
                    policyString.append(item);
                    policyString.append(" ");
                }
                policyString.setLength(policyString.length() - 1);
                continue;
            }
            policyString.append((String)entry.getKey());
            policyString.append(" ");
            policyString.append(entry.getValue());
            policyString.append(";");
        }
        if (policyString.length() > 0) {
            policyString.setLength(policyString.length() - 1);
        }
        if (setAllHeaders) {
            headers = this.ALL_HEADERS;
        }
        for (String header : headers) {
            if (this.reportOnly) {
                header = header + "-Report-Only";
            }
            request.response().putHeader(header, policyString.toString());
        }
        next.handle(null);
    }
}

