/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.middleware;

import com.jetdrone.vertx.yoke.Middleware;
import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import org.jetbrains.annotations.NotNull;
import org.vertx.java.core.Handler;

public final class XFrame
extends Middleware {
    private final String header;

    public XFrame() {
        this(Action.DENY);
    }

    public XFrame(Action action) {
        this(action, null);
    }

    public XFrame(Action action, String option) {
        if (action == Action.ALLOWFROM && option == null) {
            throw new RuntimeException("ALLOW-FROM requires a second argument");
        }
        this.header = action == Action.ALLOWFROM ? Action.ALLOWFROM.toString() + " " + option : action.toString();
    }

    public void handle(@NotNull YokeRequest request, @NotNull Handler<Object> next) {
        request.response().putHeader("X-FRAME-OPTIONS", this.header);
        next.handle(null);
    }

    public static enum Action {
        DENY("DENY"),
        ALLOWFROM("ALLOW-FROM"),
        SAMEORIGIN("SAMEORIGIN");

        private final String action;

        private Action(String action) {
            this.action = action;
        }

        public String toString() {
            return this.action;
        }
    }
}

