/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.middleware.impl;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public final class WebClient {
    private final UserAgent userAgent;
    private final int majorVersion;
    private final String fullVersion;

    private WebClient(UserAgent userAgent, int majorVersion, String fullVersion) {
        this.userAgent = userAgent;
        this.majorVersion = majorVersion;
        this.fullVersion = fullVersion;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public static WebClient detect(YokeRequest req) {
        return WebClient.detect(req.getHeader("User-Agent"));
    }

    public static WebClient detect(String userAgentString) {
        UserAgent ua = UserAgent.UNKNOWN;
        int version = 0;
        String ver = null;
        if (userAgentString != null && !"".equals(userAgentString)) {
            try {
                if (userAgentString.contains("Yahoo! Slurp")) {
                    ua = UserAgent.YAHOO_SLURP;
                } else if (userAgentString.contains("Googlebot/")) {
                    ua = UserAgent.GOOGLEBOT;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("Googlebot/") + 10)).indexOf(";") > 0 ? ver.indexOf(";") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("msnbot/")) {
                    ua = UserAgent.MSNBOT;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("msnbot/") + 7)).indexOf(" ") > 0 ? ver.indexOf(" ") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Chrome/")) {
                    ua = UserAgent.CHROME;
                    ver = userAgentString.substring(userAgentString.indexOf("Chrome/") + 7);
                    ver = ver.substring(0, ver.indexOf(" ")).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Safari/")) {
                    ua = UserAgent.SAFARI;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("Version/") + 8)).indexOf(" ") > 0 ? ver.indexOf(" ") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Opera Mini/")) {
                    ua = UserAgent.OPERA_MINI;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("Opera Mini/") + 11)).indexOf("/") > 0 ? ver.indexOf("/") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Opera ")) {
                    ua = UserAgent.OPERA;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("Opera ") + 6)).indexOf(" ") > 0 ? ver.indexOf(" ") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Firefox/")) {
                    ua = UserAgent.FIREFOX;
                    ver = ver.substring(0, (ver = userAgentString.substring(userAgentString.indexOf("Firefox/") + 8)).indexOf(" ") > 0 ? ver.indexOf(" ") : ver.length()).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("MSIE ")) {
                    ua = UserAgent.IE;
                    ver = userAgentString.substring(userAgentString.indexOf("MSIE ") + 5);
                    ver = ver.substring(0, ver.indexOf(";")).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                } else if (userAgentString.contains("Opera/")) {
                    ua = UserAgent.OPERA;
                    ver = userAgentString.substring(userAgentString.indexOf("Opera/") + 6);
                    ver = ver.substring(0, ver.indexOf(" ")).trim();
                    version = Integer.parseInt(ver.substring(0, ver.indexOf(".")));
                }
            }
            catch (NumberFormatException nfe) {
                ver = null;
                version = 0;
            }
        }
        return new WebClient(ua, version, ver);
    }

    public String toString() {
        return (Object)((Object)this.userAgent) + " " + this.fullVersion;
    }

    public static enum UserAgent {
        IE,
        FIREFOX,
        CHROME,
        CHROME_MOBILE,
        OPERA,
        OPERA_MINI,
        SAFARI,
        GOOGLEBOT,
        YAHOO_SLURP,
        MSNBOT,
        UNKNOWN;

    }
}

