/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.constraint.validator;

import com.jfireframework.baseutil.exception.JustThrowException;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;

public class PatternValidator
implements ConstraintValidator<Pattern, CharSequence> {
    private java.util.regex.Pattern pattern;

    public void initialize(Pattern parameters) {
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw new JustThrowException((Throwable)e);
        }
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

