/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.constraint.validator;

import java.lang.reflect.Array;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Size;

public class SizeValidator
implements ConstraintValidator<Size, Object> {
    private int min;
    private int max;

    public void initialize(Size constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        if (this.min > this.max) {
            throw new UnsupportedOperationException("min \u5fc5\u987b\u5c0f\u4e8emax");
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int size = 0;
        if (value instanceof String) {
            String str = (String)value;
            size = str.length();
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            size = collection.size();
        } else if (value.getClass().isArray()) {
            size = Array.getLength(value);
        }
        return size >= this.min && size <= this.max;
    }
}

