/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.engine;

import com.jfireframework.validator.engine.ConstraintViolationImpl;
import com.jfireframework.validator.executor.BeanValidateExecutor;
import com.jfireframework.validator.executor.ExecutorFactory;
import com.jfireframework.validator.executor.MethodValidatorExecutor;
import com.jfireframework.validator.metadata.AnnoRelConstraintMetaDataStore;
import com.jfireframework.validator.metadata.ConstraintMetaData;
import com.jfireframework.validator.paramnamefetcher.ParamNameFetcher;
import com.jfireframework.validator.paramnamefetcher.impl.DefaultParamNameFetcher;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcherFactory;
import com.jfireframework.validator.propertyfetcher.impl.ReflectPropertyValueFetcherFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.GroupSequence;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;

public class JfireValidator
implements Validator {
    private final ExecutorFactory executorFactory;
    private final AnnoRelConstraintMetaDataStore metaDataStore;

    public JfireValidator(MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory) {
        this.metaDataStore = new AnnoRelConstraintMetaDataStore(messageInterpolator, constraintValidatorFactory);
        this.executorFactory = new ExecutorFactory(new ReflectPropertyValueFetcherFactory(), new DefaultParamNameFetcher(), this.metaDataStore);
    }

    public void setParamNameFetcher(ParamNameFetcher paramNameFetcher) {
        this.executorFactory.setParamNameFetcher(paramNameFetcher);
    }

    public void setPropertyValueFetcherFactory(PropertyValueFetcherFactory fetcherFactory) {
        this.executorFactory.setPropertyValueFetcherFactory(fetcherFactory);
    }

    public <T> Set<ConstraintViolation<T>> validate(final T object, Class<?> ... groups) {
        ValidateBeanHelper helper = new ValidateBeanHelper<T>(object, groups){

            @Override
            BeanValidateExecutor getBeanValidator() {
                return JfireValidator.this.executorFactory.getInstance(object.getClass());
            }

            @Override
            void validate(BeanValidateExecutor beanValidator, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
                beanValidator.validateBean(object, null, constraintViolations, group);
            }
        };
        Set result = helper.doValidate();
        helper.setRootBean(result, object);
        return result;
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(final T object, final String propertyName, Class<?> ... groups) {
        ValidateBeanHelper validateHelper = new ValidateBeanHelper<T>(object, groups){

            @Override
            void validate(BeanValidateExecutor beanValidator, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
                beanValidator.validateProperty(object, propertyName, null, constraintViolations, group);
            }

            @Override
            BeanValidateExecutor getBeanValidator() {
                return JfireValidator.this.executorFactory.getInstance(object.getClass());
            }
        };
        Set result = validateHelper.doValidate();
        validateHelper.setRootBean(result, object);
        return result;
    }

    public <T> Set<ConstraintViolation<T>> validateValue(final Class<T> beanType, final String propertyName, final Object value, Class<?> ... groups) {
        ValidateBeanHelper validateHelper = new ValidateBeanHelper<T>(beanType, groups){

            @Override
            void validate(BeanValidateExecutor beanValidator, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
                beanValidator.validatePropertyValue(propertyName, value, null, constraintViolations, group);
            }

            @Override
            BeanValidateExecutor getBeanValidator() {
                return JfireValidator.this.executorFactory.getInstance(beanType);
            }
        };
        Set result = validateHelper.doValidate();
        validateHelper.setRootBeanClass(result, beanType);
        return result;
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    public Set<ConstraintViolation<Method>> validateMethod(final Method method, final Object[] params, Class<?> ... groups) {
        class Helper {
            Class<?>[] groups;

            public Helper(Class<?>[] groups) {
                this.groups = this.getGroups(groups);
            }

            Set<ConstraintViolation<Method>> validate() {
                LinkedHashSet<ConstraintViolation<Method>> result = new LinkedHashSet<ConstraintViolation<Method>>();
                MethodValidatorExecutor validator = executorFactory.getInstace(method);
                for (Class<?> group : this.groups) {
                    validator.validate(params, result, group);
                }
                for (ConstraintViolation constraintViolation : result) {
                    ((ConstraintViolationImpl)constraintViolation).setRootBean(method);
                }
                return result;
            }

            Class<?>[] getGroups(Class<?>[] groups) {
                if (groups.length == 0) {
                    groups = new Class[]{Default.class};
                } else if (groups.length == 1 && groups[0].isAnnotationPresent(GroupSequence.class)) {
                    GroupSequence sequence = groups[0].getAnnotation(GroupSequence.class);
                    groups = sequence.value();
                }
                return groups;
            }
        }
        Helper helper = new Helper((Class[])groups);
        return helper.validate();
    }

    public ConstraintMetaData[] relevanceConstraintMetaDatas(Annotation annotation) {
        return this.metaDataStore.relevanceConstraintMetaDatas(annotation);
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    abstract class ValidateBeanHelper<T> {
        Object check;
        Class<?>[] groups;

        public ValidateBeanHelper(Object value, Class<?>[] groups) {
            this.check = value;
            this.groups = groups;
        }

        Set<ConstraintViolation<T>> doValidate() {
            if (this.check == null) {
                return new HashSet<ConstraintViolation<T>>();
            }
            BeanValidateExecutor beanValidator = this.getBeanValidator();
            Class<?>[] groups = this.getGroups();
            LinkedHashSet<ConstraintViolation<T>> result = new LinkedHashSet<ConstraintViolation<T>>();
            for (Class<?> group : groups) {
                this.validate(beanValidator, result, group);
                if (result.size() <= 0) continue;
                return result;
            }
            return result;
        }

        abstract void validate(BeanValidateExecutor var1, Set<ConstraintViolation<T>> var2, Class<?> var3);

        abstract BeanValidateExecutor getBeanValidator();

        Class<?>[] getGroups() {
            if (this.groups.length == 0) {
                this.groups = new Class[]{Default.class};
            } else if (this.groups.length == 1 && this.groups[0].isAnnotationPresent(GroupSequence.class)) {
                GroupSequence sequence = this.groups[0].getAnnotation(GroupSequence.class);
                this.groups = sequence.value();
            }
            return this.groups;
        }

        void setRootBean(Set<ConstraintViolation<T>> result, T rootBean) {
            Class<?> type = rootBean == null ? null : rootBean.getClass();
            for (ConstraintViolation<T> each : result) {
                ((ConstraintViolationImpl)each).setRootBean(rootBean);
                ((ConstraintViolationImpl)each).setRootBeanClass(type);
            }
        }

        void setRootBeanClass(Set<ConstraintViolation<T>> result, Class<T> type) {
            for (ConstraintViolation<T> each : result) {
                ((ConstraintViolationImpl)each).setRootBeanClass(type);
            }
        }
    }
}

