/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.engine;

import com.jfireframework.baseutil.collection.StringCache;
import java.util.Iterator;
import java.util.LinkedList;
import javax.validation.Path;

public class PathImpl
implements Path {
    private final PathImpl pred;
    private final Path.Node self;

    public PathImpl(String name) {
        this(null, name, false, null, null);
    }

    public PathImpl(PathImpl path, String name) {
        this(path, name, false, null, null);
    }

    public PathImpl(PathImpl path, String name, boolean inIterable, Integer index, Object key) {
        this.pred = path;
        this.self = new NodeImpl(name, inIterable, index, key);
    }

    public Iterator<Path.Node> iterator() {
        LinkedList<Path.Node> list = new LinkedList<Path.Node>();
        list.push(this.self);
        PathImpl pred = this.pred;
        while (pred != null) {
            list.push(pred.self);
            pred = pred.pred;
        }
        return list.iterator();
    }

    public String toString() {
        StringCache cache = new StringCache();
        Iterator<Path.Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            Path.Node node = iterator.next();
            cache.append(node.getName());
            if (node.isInIterable()) {
                if (node.getIndex() != null) {
                    cache.append('[').append(node.getIndex()).append(']');
                } else {
                    cache.append('[').append(node.getKey()).append(']');
                }
            }
            cache.append('.');
        }
        cache.deleteLast();
        return cache.toString();
    }

    class NodeImpl
    implements Path.Node {
        private final String name;
        private final boolean inIterable;
        private final Integer index;
        private final Object key;

        public NodeImpl(String name, boolean inIterable, Integer index, Object key) {
            this.name = name;
            this.inIterable = inIterable;
            this.index = index;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return this.inIterable;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

